/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class FunctObjectPropAxiomImpl
implements FunctObjectPropAxiom {
    private final int property;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    FunctObjectPropAxiomImpl(int propertyId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.property = propertyId;
        this.annotations = annotations;
        this.hashCode = this.property + 31 * this.annotations.hashCode();
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FunctObjectPropAxiom)) {
            return false;
        }
        FunctObjectPropAxiom other = (FunctObjectPropAxiom)obj;
        return this.getProperty() == other.getProperty() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.singleton(this.getProperty());
    }

    @Override
    public int getProperty() {
        return this.property;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("FunctionalObjectProperty*");
        sbuf.append("(");
        sbuf.append(this.getProperty());
        sbuf.append(")");
        return sbuf.toString();
    }
}

