/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class RI1AxiomImpl
implements RI1Axiom {
    private final int superProperty;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    RI1AxiomImpl(int propertyId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.superProperty = propertyId;
        this.annotations = annotations;
        this.hashCode = this.superProperty + 31 * this.annotations.hashCode();
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RI1Axiom)) {
            return false;
        }
        RI1Axiom other = (RI1Axiom)obj;
        return this.getSuperProperty() == other.getSuperProperty() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.singleton(this.superProperty);
    }

    @Override
    public int getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubObjectPropertyOf*");
        sbuf.append("(");
        sbuf.append("()");
        sbuf.append(" ");
        sbuf.append(this.getSuperProperty());
        sbuf.append(")");
        return sbuf.toString();
    }
}

