/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class RI2AxiomImpl
implements RI2Axiom {
    private final int subProperty;
    private final int superProperty;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    RI2AxiomImpl(int leftPropertyId, int rightPropertyId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.subProperty = leftPropertyId;
        this.superProperty = rightPropertyId;
        this.annotations = annotations;
        this.hashCode = this.subProperty + 31 * (this.superProperty + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RI2Axiom)) {
            return false;
        }
        RI2Axiom other = (RI2Axiom)obj;
        return this.getSubProperty() == other.getSubProperty() && this.getSuperProperty() == other.getSuperProperty() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.subProperty);
        ret.add(this.superProperty);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public int getSubProperty() {
        return this.subProperty;
    }

    @Override
    public int getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubObjectPropertyOf*");
        sbuf.append("(");
        sbuf.append(this.getSubProperty());
        sbuf.append(" ");
        sbuf.append(this.getSuperProperty());
        sbuf.append(")");
        return sbuf.toString();
    }
}

