/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owlapi.ElkReasoner;
import org.semanticweb.elk.owlapi.ElkReasonerConfiguration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class ElkReasonerFactory
implements OWLReasonerFactory {
    private static final Logger LOGGER_ = Logger.getLogger(ElkReasonerFactory.class);

    public String getReasonerName() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"getReasonerName()");
        }
        return ElkReasonerFactory.class.getPackage().getImplementationTitle();
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"createNonBufferingReasoner(OWLOntology)");
        }
        return this.createElkReasoner(ontology, false, null);
    }

    public OWLReasoner createReasoner(OWLOntology ontology) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"createReasoner(OWLOntology)");
        }
        return this.createElkReasoner(ontology, true, null);
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"createNonBufferingReasoner(OWLOntology, OWLReasonerConfiguration)");
        }
        return this.createElkReasoner(ontology, false, config);
    }

    public OWLReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"createReasoner(OWLOntology, OWLReasonerConfiguration)");
        }
        return this.createElkReasoner(ontology, true, config);
    }

    ElkReasoner createElkReasoner(OWLOntology ontology, boolean isBufferingMode, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"createElkReasoner(OWLOntology, boolean, OWLReasonerConfiguration)");
        }
        ElkReasonerConfiguration elkReasonerConfig = config != null ? (config instanceof ElkReasonerConfiguration ? (ElkReasonerConfiguration)config : new ElkReasonerConfiguration(config)) : new ElkReasonerConfiguration();
        return new ElkReasoner(ontology, isBufferingMode, elkReasonerConfig);
    }
}

