/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationFactory;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class ClassExpressionSaturationFactory<J extends SaturationJob<? extends IndexedClassExpression>>
implements InputProcessorFactory<J, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(ClassExpressionSaturationFactory.class);
    private final ClassExpressionSaturationListener<J> listener_;
    private final RuleApplicationFactory ruleApplicationFactory_;
    private final Queue<J> jobsToDo_;
    private final Queue<J> jobsInProgress_;
    private final AtomicInteger countJobsSubmitted_ = new AtomicInteger(0);
    private final AtomicInteger countJobsProcessed_ = new AtomicInteger(0);
    private final AtomicInteger countJobsFinished_ = new AtomicInteger(0);
    private final Queue<Context> nonSaturatedContexts_;
    private final AtomicInteger countContextsCreated_ = new AtomicInteger(0);
    private final AtomicInteger countContextsProcessed_ = new AtomicInteger(0);
    private final AtomicInteger countContextsFinished_ = new AtomicInteger(0);
    private final int threshold_;
    private volatile boolean workersWaiting_ = false;
    private final AtomicInteger countStartedWorkers_ = new AtomicInteger(0);
    private final AtomicInteger countFinishedWorkers_ = new AtomicInteger(0);
    private final AtomicInteger lastInterruptStartedWorkersSnapshot_ = new AtomicInteger(0);
    private final ThisStatistics aggregatedStats_;

    public ClassExpressionSaturationFactory(SaturationState saturationState, int maxWorkers, ClassExpressionSaturationListener<J> listener) {
        this(new RuleApplicationFactory(saturationState), maxWorkers, listener);
    }

    public ClassExpressionSaturationFactory(RuleApplicationFactory ruleAppFactory, int maxWorkers, ClassExpressionSaturationListener<J> listener) {
        this.threshold_ = 64 + 32 * maxWorkers;
        this.listener_ = listener;
        this.jobsToDo_ = new ConcurrentLinkedQueue<J>();
        this.jobsInProgress_ = new ConcurrentLinkedQueue<J>();
        this.ruleApplicationFactory_ = ruleAppFactory;
        this.aggregatedStats_ = new ThisStatistics();
        this.nonSaturatedContexts_ = new ConcurrentLinkedQueue<Context>();
    }

    public ClassExpressionSaturationFactory(RuleApplicationFactory ruleAppFactory, int maxWorkers) {
        this(ruleAppFactory, maxWorkers, new ClassExpressionSaturationListener<J>(){

            @Override
            public void notifyFinished(J job) throws InterruptedException {
            }
        });
    }

    @Override
    public Engine getEngine() {
        return new Engine();
    }

    public void printStatistics() {
        this.ruleApplicationFactory_.getSaturationStatistics().print(LOGGER_);
        this.checkStatistics();
        if (LOGGER_.isDebugEnabled()) {
            if (this.aggregatedStats_.jobsSubmittedNo > 0) {
                LOGGER_.debug((Object)("Saturation Jobs Submitted=Done+Processed: " + this.aggregatedStats_.jobsSubmittedNo + "=" + this.aggregatedStats_.jobsAlreadyDoneNo + "+" + this.aggregatedStats_.jobsProcessedNo));
            }
            LOGGER_.debug((Object)("Locks: " + this.aggregatedStats_.locks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterrupt(boolean flag) {
        this.ruleApplicationFactory_.setInterrupt(flag);
        AtomicInteger atomicInteger = this.countContextsProcessed_;
        synchronized (atomicInteger) {
            if (this.workersWaiting_) {
                this.workersWaiting_ = false;
                this.countContextsProcessed_.notifyAll();
            }
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.ruleApplicationFactory_.isInterrupted();
    }

    @Override
    public void finish() {
        this.checkStatistics();
    }

    private void checkStatistics() {
        if (this.isInterrupted()) {
            return;
        }
        if (this.aggregatedStats_.jobsSubmittedNo != this.aggregatedStats_.jobsAlreadyDoneNo + this.aggregatedStats_.jobsProcessedNo) {
            LOGGER_.error((Object)"Some submitted saturation jobs were not processed!");
        }
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.ruleApplicationFactory_.getSaturationStatistics();
    }

    private void processFinishedCounters(ThisStatistics localStatistics) throws InterruptedException {
        int shapshotJobsFinished;
        int shapshotContextsFinished;
        while ((shapshotContextsFinished = this.countContextsFinished_.get()) != this.countContextsProcessed_.get()) {
            if (!this.countContextsFinished_.compareAndSet(shapshotContextsFinished, shapshotContextsFinished + 1)) continue;
            Context nextContext = this.nonSaturatedContexts_.poll();
            nextContext.setSaturated(true);
        }
        while ((shapshotJobsFinished = this.countJobsFinished_.get()) != this.countJobsProcessed_.get()) {
            if (!this.countJobsFinished_.compareAndSet(shapshotJobsFinished, shapshotJobsFinished + 1)) continue;
            SaturationJob nextJob = (SaturationJob)this.jobsInProgress_.poll();
            IndexedClassExpression root = (IndexedClassExpression)nextJob.getInput();
            Context rootSaturation = this.ruleApplicationFactory_.getSaturationState().getContext(root);
            rootSaturation.setSaturated(true);
            nextJob.setOutput(rootSaturation);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(root + ": saturation finished"));
            }
            ++localStatistics.jobsProcessedNo;
            this.listener_.notifyFinished(nextJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessedCounters(int snapshotFinishedWorkers) {
        if (this.lastInterruptStartedWorkersSnapshot_.get() >= this.countStartedWorkers_.get()) {
            return;
        }
        int snapshotCountContextCreated = this.countContextsCreated_.get();
        int snapshotCountJobsSubmitted = this.countJobsSubmitted_.get();
        if (this.countStartedWorkers_.get() > snapshotFinishedWorkers) {
            return;
        }
        ClassExpressionSaturationFactory.updateIfSmaller(this.countJobsProcessed_, snapshotCountJobsSubmitted);
        if (ClassExpressionSaturationFactory.updateIfSmaller(this.countContextsProcessed_, snapshotCountContextCreated) && this.workersWaiting_) {
            AtomicInteger atomicInteger = this.countContextsProcessed_;
            synchronized (atomicInteger) {
                this.workersWaiting_ = false;
                this.countContextsProcessed_.notifyAll();
            }
        }
    }

    private static boolean updateIfSmaller(AtomicInteger counter, int value) {
        int snapshotCoutner;
        do {
            if ((snapshotCoutner = counter.get()) < value) continue;
            return false;
        } while (!counter.compareAndSet(snapshotCoutner, value));
        return true;
    }

    private static class ThisStatistics {
        int jobsSubmittedNo;
        int jobsAlreadyDoneNo;
        int jobsProcessedNo;
        int locks;

        private ThisStatistics() {
        }

        public synchronized void merge(ThisStatistics statistics) {
            this.jobsSubmittedNo += statistics.jobsSubmittedNo;
            this.jobsProcessedNo += statistics.jobsProcessedNo;
            this.jobsAlreadyDoneNo += statistics.jobsAlreadyDoneNo;
            this.locks += statistics.locks;
        }
    }

    public class Engine
    implements InputProcessor<J> {
        private final RuleApplicationFactory.BaseEngine ruleApplicationEngine_;
        private final ThisStatistics stats_;

        private Engine() {
            this.ruleApplicationEngine_ = ClassExpressionSaturationFactory.this.ruleApplicationFactory_.getDefaultEngine(new ContextCreationListener(){

                @Override
                public void notifyContextCreation(Context newContext) {
                    ClassExpressionSaturationFactory.this.nonSaturatedContexts_.add(newContext);
                    ClassExpressionSaturationFactory.this.countContextsCreated_.incrementAndGet();
                }
            }, ContextModificationListener.DUMMY);
            this.stats_ = new ThisStatistics();
        }

        @Override
        public void submit(J job) {
            ClassExpressionSaturationFactory.this.jobsToDo_.add(job);
            ++this.stats_.jobsSubmittedNo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws InterruptedException {
            ClassExpressionSaturationFactory.this.countStartedWorkers_.incrementAndGet();
            this.ruleApplicationEngine_.process();
            if (ClassExpressionSaturationFactory.this.isInterrupted()) {
                ClassExpressionSaturationFactory.updateIfSmaller(ClassExpressionSaturationFactory.this.lastInterruptStartedWorkersSnapshot_, ClassExpressionSaturationFactory.this.countStartedWorkers_.get());
            }
            ClassExpressionSaturationFactory.this.updateProcessedCounters(ClassExpressionSaturationFactory.this.countFinishedWorkers_.incrementAndGet());
            ClassExpressionSaturationFactory.this.processFinishedCounters(this.stats_);
            while (!ClassExpressionSaturationFactory.this.isInterrupted()) {
                int snapshotCountContextsProcessed = ClassExpressionSaturationFactory.this.countContextsProcessed_.get();
                if (ClassExpressionSaturationFactory.this.countContextsCreated_.get() - snapshotCountContextsProcessed > ClassExpressionSaturationFactory.this.threshold_) {
                    AtomicInteger atomicInteger = ClassExpressionSaturationFactory.this.countContextsProcessed_;
                    synchronized (atomicInteger) {
                        ClassExpressionSaturationFactory.this.workersWaiting_ = true;
                        ++this.stats_.locks;
                        if (ClassExpressionSaturationFactory.this.countContextsProcessed_.get() > snapshotCountContextsProcessed || ClassExpressionSaturationFactory.this.isInterrupted()) {
                            ClassExpressionSaturationFactory.this.workersWaiting_ = false;
                            ClassExpressionSaturationFactory.this.countContextsProcessed_.notifyAll();
                        }
                        ClassExpressionSaturationFactory.this.countContextsProcessed_.wait();
                    }
                }
                SaturationJob nextJob = (SaturationJob)ClassExpressionSaturationFactory.this.jobsToDo_.poll();
                if (nextJob == null) {
                    return;
                }
                IndexedClassExpression root = (IndexedClassExpression)nextJob.getInput();
                Context rootContext = ClassExpressionSaturationFactory.this.ruleApplicationFactory_.getSaturationState().getContext(root);
                if (rootContext != null && rootContext.isSaturated()) {
                    nextJob.setOutput(rootContext);
                    ++this.stats_.jobsAlreadyDoneNo;
                    ClassExpressionSaturationFactory.this.listener_.notifyFinished(nextJob);
                    continue;
                }
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)(root + ": saturation started"));
                }
                ClassExpressionSaturationFactory.this.countStartedWorkers_.incrementAndGet();
                ClassExpressionSaturationFactory.this.jobsInProgress_.add(nextJob);
                ClassExpressionSaturationFactory.this.countJobsSubmitted_.incrementAndGet();
                this.ruleApplicationEngine_.submit(root);
                this.ruleApplicationEngine_.process();
                if (ClassExpressionSaturationFactory.this.isInterrupted()) {
                    ClassExpressionSaturationFactory.updateIfSmaller(ClassExpressionSaturationFactory.this.lastInterruptStartedWorkersSnapshot_, ClassExpressionSaturationFactory.this.countStartedWorkers_.get());
                }
                ClassExpressionSaturationFactory.this.updateProcessedCounters(ClassExpressionSaturationFactory.this.countFinishedWorkers_.incrementAndGet());
                ClassExpressionSaturationFactory.this.processFinishedCounters(this.stats_);
            }
            return;
        }

        @Override
        public void finish() {
            this.ruleApplicationEngine_.finish();
            ClassExpressionSaturationFactory.this.aggregatedStats_.merge(this.stats_);
        }
    }
}

