/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class ReflexivePropertyComputationFactory
extends SimpleInterrupter
implements InputProcessorFactory<IndexedObjectProperty, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(ReflexivePropertyComputationFactory.class);
    private final Queue<IndexedPropertyChain> toDo_ = new ConcurrentLinkedQueue<IndexedPropertyChain>();
    private final IndexedPropertyChainVisitor<Void> reflexivityPropagator_ = new IndexedPropertyChainVisitor<Void>(){

        @Override
        public Void visit(IndexedObjectProperty element) {
            ReflexivePropertyComputationFactory.this.toDoLeftChains(element);
            this.commonVisit(element);
            return null;
        }

        @Override
        public Void visit(IndexedBinaryPropertyChain element) {
            this.commonVisit(element);
            return null;
        }

        public void commonVisit(IndexedPropertyChain element) {
            ReflexivePropertyComputationFactory.this.toDoSuperProperties(element);
            ReflexivePropertyComputationFactory.this.toDoRightChains(element);
        }
    };

    @Override
    public Engine getEngine() {
        return new Engine();
    }

    @Override
    public void finish() {
    }

    private void toDo(IndexedPropertyChain ipc) {
        SaturatedPropertyChain saturation = SaturatedPropertyChain.getCreate(ipc);
        if (saturation.setReflexive()) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(ipc + ": set reflexive"));
            }
            this.toDo_.add(ipc);
        }
    }

    private void toDoSuperProperties(IndexedPropertyChain ipc) {
        for (IndexedPropertyChain indexedPropertyChain : ipc.getToldSuperProperties()) {
            this.toDo(indexedPropertyChain);
        }
    }

    private void toDoLeftChains(IndexedObjectProperty iop) {
        for (IndexedBinaryPropertyChain chain : iop.getLeftChains()) {
            SaturatedPropertyChain rightSaturation = chain.getRightProperty().getSaturated();
            if (rightSaturation == null || !rightSaturation.isDerivedReflexive()) continue;
            this.toDo(chain);
        }
    }

    private void toDoRightChains(IndexedPropertyChain ipc) {
        for (IndexedBinaryPropertyChain chain : ipc.getRightChains()) {
            SaturatedPropertyChain leftSaturation = chain.getLeftProperty().getSaturated();
            if (leftSaturation == null || !leftSaturation.isDerivedReflexive()) continue;
            this.toDo(chain);
        }
    }

    class Engine
    implements InputProcessor<IndexedObjectProperty> {
        Engine() {
        }

        @Override
        public void submit(IndexedObjectProperty job) {
            ReflexivePropertyComputationFactory.this.toDo(job);
        }

        @Override
        public void process() {
            while (!ReflexivePropertyComputationFactory.this.isInterrupted()) {
                IndexedPropertyChain next = (IndexedPropertyChain)ReflexivePropertyComputationFactory.this.toDo_.poll();
                if (next == null) {
                    return;
                }
                next.accept(ReflexivePropertyComputationFactory.this.reflexivityPropagator_);
            }
            return;
        }

        @Override
        public void finish() {
        }
    }
}

