/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.cel;

import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExistentialEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExtensionEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ImplicationEntry;
import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI0Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NominalAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CelExtendedOntology
implements NormalizedIntegerAxiomVisitor<Boolean> {
    private final Map<Integer, Set<ExtensionEntry>> ohatOfClass = new HashMap<Integer, Set<ExtensionEntry>>();
    private final Map<Integer, Map<Integer, Set<ExtensionEntry>>> ohatOfExistential = new HashMap<Integer, Map<Integer, Set<ExtensionEntry>>>();
    private final Map<Integer, Set<RI3Axiom>> subPropertyAxiomSetByLeft = new HashMap<Integer, Set<RI3Axiom>>();
    private final Map<Integer, Set<RI3Axiom>> subPropertyAxiomSetByRight = new HashMap<Integer, Set<RI3Axiom>>();

    private void addClass(Integer classId) {
        if (Objects.isNull(this.ohatOfClass.get(classId))) {
            this.ohatOfClass.put(classId, new HashSet());
        }
    }

    private void addClassEntry(Integer classId, ExtensionEntry entry) {
        this.addClass(classId);
        this.ohatOfClass.get(classId).add(entry);
    }

    private void addTo(Integer property, RI3Axiom axiom, Map<Integer, Set<RI3Axiom>> map) {
        Set<RI3Axiom> axiomSet = map.get(property);
        if (Objects.isNull(axiomSet)) {
            axiomSet = new HashSet<RI3Axiom>();
            map.put(property, axiomSet);
        }
        axiomSet.add(axiom);
    }

    public void clear() {
        this.ohatOfClass.clear();
        this.ohatOfExistential.clear();
        this.subPropertyAxiomSetByLeft.clear();
        this.subPropertyAxiomSetByRight.clear();
    }

    public Set<ExtensionEntry> getClassEntries(Integer classId) {
        Objects.requireNonNull(classId);
        Set<ExtensionEntry> ret = this.ohatOfClass.get(classId);
        if (Objects.isNull(ret)) {
            ret = Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<Integer> getClassSet() {
        return Collections.unmodifiableSet(this.ohatOfClass.keySet());
    }

    public Set<ExtensionEntry> getExistentialEntries(Integer propertyId, Integer classId) {
        Objects.requireNonNull(propertyId);
        Objects.requireNonNull(classId);
        Set<Object> ret = Collections.emptySet();
        Map<Integer, Set<ExtensionEntry>> map = this.ohatOfExistential.get(propertyId);
        if (Objects.nonNull(map) && Objects.isNull(ret = map.get(classId))) {
            ret = Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<RI3Axiom> getSubPropertyAxiomSetByLeft(Integer elem) {
        Objects.requireNonNull(elem);
        Set<RI3Axiom> ret = this.subPropertyAxiomSetByLeft.get(elem);
        if (Objects.isNull(ret)) {
            ret = Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<RI3Axiom> getSubPropertyAxiomSetByRight(Integer elem) {
        Objects.requireNonNull(elem);
        Set<RI3Axiom> ret = this.subPropertyAxiomSetByRight.get(elem);
        if (Objects.isNull(ret)) {
            ret = Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public void load(Set<NormalizedIntegerAxiom> axiomSet) {
        Objects.requireNonNull(axiomSet);
        this.clear();
        axiomSet.forEach(axiom -> {
            axiom.accept(this);
            if (axiom instanceof RI3Axiom) {
                RI3Axiom subPropAxiom = (RI3Axiom)axiom;
                Integer left = subPropAxiom.getLeftSubProperty();
                Integer right = subPropAxiom.getRightSubProperty();
                this.addTo(left, subPropAxiom, this.subPropertyAxiomSetByLeft);
                this.addTo(right, subPropAxiom, this.subPropertyAxiomSetByRight);
            }
        });
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[");
        sbuf.append("OHat(cl)=" + this.ohatOfClass.toString());
        sbuf.append("OHat(ex)=" + this.ohatOfExistential.toString());
        sbuf.append("]");
        return sbuf.toString();
    }

    @Override
    public Boolean visit(FunctObjectPropAxiom axiom) {
        Objects.requireNonNull(axiom);
        return false;
    }

    @Override
    public Boolean visit(GCI0Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.addClassEntry(axiom.getSubClass(), new ImplicationEntry(new HashSet<Integer>(), axiom.getSuperClass()));
        return true;
    }

    @Override
    public Boolean visit(GCI1Axiom axiom) {
        Objects.requireNonNull(axiom);
        Integer superClass = axiom.getSuperClass();
        ArrayList<Integer> operandSet = new ArrayList<Integer>();
        operandSet.add(axiom.getLeftSubClass());
        operandSet.add(axiom.getRightSubClass());
        operandSet.forEach(currentOperand -> {
            HashSet<Integer> currentSet = new HashSet<Integer>();
            currentSet.addAll(operandSet);
            currentSet.remove(currentOperand);
            this.addClassEntry((Integer)currentOperand, new ImplicationEntry(currentSet, superClass));
        });
        return true;
    }

    @Override
    public Boolean visit(GCI2Axiom axiom) {
        Objects.requireNonNull(axiom);
        this.addClassEntry(axiom.getSubClass(), new ExistentialEntry(axiom.getPropertyInSuperClass(), axiom.getClassInSuperClass()));
        return true;
    }

    @Override
    public Boolean visit(GCI3Axiom axiom) {
        Set<ExtensionEntry> set;
        Objects.requireNonNull(axiom);
        ImplicationEntry entry = new ImplicationEntry(new HashSet<Integer>(), axiom.getSuperClass());
        Integer propertyId = axiom.getPropertyInSubClass();
        Integer classId = axiom.getClassInSubClass();
        Map<Integer, Set<ExtensionEntry>> map = this.ohatOfExistential.get(propertyId);
        if (Objects.isNull(map)) {
            map = new HashMap<Integer, Set<ExtensionEntry>>();
            this.ohatOfExistential.put(propertyId, map);
        }
        if (Objects.isNull(set = map.get(classId))) {
            set = new HashSet<ExtensionEntry>();
            map.put(classId, set);
        }
        set.add(entry);
        return true;
    }

    @Override
    public Boolean visit(NominalAxiom axiom) {
        Objects.requireNonNull(axiom);
        return false;
    }

    @Override
    public Boolean visit(RangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        return false;
    }

    @Override
    public Boolean visit(RI1Axiom axiom) {
        Objects.requireNonNull(axiom);
        return false;
    }

    @Override
    public Boolean visit(RI2Axiom axiom) {
        Objects.requireNonNull(axiom);
        return false;
    }

    @Override
    public Boolean visit(RI3Axiom axiom) {
        Objects.requireNonNull(axiom);
        return false;
    }
}

