/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.ArraySetIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public class ArraySet
implements Set<Integer> {
    private static final int exponentialGrowthFactor = 2;
    private static final int initialSize = 1;
    private static final int linearGrowthFactor = 1;
    private int[] array = null;
    private int size = 0;

    public ArraySet() {
        this.clear();
    }

    @Override
    public synchronized boolean add(Integer elem) {
        Objects.requireNonNull(elem);
        boolean ret = false;
        int pointer = Arrays.binarySearch(this.array, 0, this.size, elem);
        if (pointer < 0) {
            pointer = -1 * (pointer + 1);
            ret = true;
            if (this.size >= this.array.length) {
                int[] newArray = new int[1 + 2 * this.array.length];
                System.arraycopy(this.array, 0, newArray, 0, pointer);
                System.arraycopy(this.array, pointer, newArray, pointer + 1, this.size - pointer);
                this.array = newArray;
            } else {
                System.arraycopy(this.array, pointer, this.array, pointer + 1, this.size - pointer);
            }
            this.array[pointer] = elem;
            ++this.size;
        }
        return ret;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Integer> collection) {
        Objects.requireNonNull(collection);
        boolean ret = false;
        for (Integer n : collection) {
            ret |= this.add(n);
        }
        return ret;
    }

    @Override
    public synchronized void clear() {
        this.array = new int[1];
        this.size = 0;
    }

    @Override
    public synchronized boolean contains(Object elem) {
        Objects.requireNonNull(elem);
        boolean ret = false;
        int e = (Integer)elem;
        int pointer = Arrays.binarySearch(this.array, 0, this.size, e);
        ret = pointer >= 0;
        return ret;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        return collection.stream().allMatch(elem -> this.contains(elem));
    }

    @Override
    public synchronized boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof ArraySet) {
            ArraySet other = (ArraySet)o;
            ret = this.size == other.size;
            ret = ret && IntStream.range(0, this.size).allMatch(index -> this.array[index] == other.array[index]);
        }
        return ret;
    }

    @Override
    public synchronized int hashCode() {
        return this.array.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized Iterator<Integer> iterator() {
        return new ArraySetIterator(this.array, this.size);
    }

    @Override
    public synchronized boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.toArrayList().toArray(a);
    }

    private synchronized ArrayList<Integer> toArrayList() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        IntStream.range(0, this.size).forEach((int index) -> ret.add(this.array[index]));
        return ret;
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[ ");
        IntStream.range(0, this.size()).forEach((int index) -> {
            sbuf.append(this.array[index]);
            sbuf.append(" ");
        });
        sbuf.append("]");
        return sbuf.toString();
    }
}

