/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;

public class HashArraySetIterator
implements Iterator<Integer> {
    private final int[] array;
    private int count = 0;
    private int pointer = 0;
    private final int size;

    public HashArraySetIterator(int[] a, int s) {
        Objects.requireNonNull(a);
        this.array = a;
        this.size = s;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof HashArraySetIterator) {
            HashArraySetIterator other = (HashArraySetIterator)o;
            ret = this.size == other.size && this.pointer == other.pointer && this.count == other.count;
            ret = ret && IntStream.range(0, this.size).allMatch(index -> this.array[index] == other.array[index]);
        }
        return ret;
    }

    public int hashCode() {
        return this.pointer + 31 * this.array.hashCode();
    }

    @Override
    public boolean hasNext() {
        return this.count < this.size;
    }

    @Override
    public Integer next() {
        if (this.count >= this.size) {
            throw new NoSuchElementException();
        }
        while (this.pointer < this.array.length && this.array[this.pointer] == Integer.MIN_VALUE) {
            ++this.pointer;
        }
        if (this.pointer == this.array.length) {
            throw new IllegalStateException("Illegal state: " + this.toString());
        }
        int ret = this.array[this.pointer];
        ++this.pointer;
        ++this.count;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("at ");
        sbuf.append(this.count);
        sbuf.append("/");
        sbuf.append(this.size);
        sbuf.append(" (");
        sbuf.append(this.pointer);
        sbuf.append("/");
        sbuf.append(this.array.length);
        sbuf.append(")   ");
        sbuf.append("[ ");
        IntStream.range(0, this.array.length).forEach(index -> {
            int element = this.array[index];
            if (index == this.pointer) {
                sbuf.append("^");
            }
            if (element == Integer.MIN_VALUE) {
                sbuf.append(".");
            } else {
                sbuf.append(element);
            }
            sbuf.append(" ");
        });
        sbuf.append("]");
        return sbuf.toString();
    }
}

