/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.VNode;
import de.tudresden.inf.lat.jcel.core.graph.VNodeObjectSomeValuesFrom;
import de.tudresden.inf.lat.jcel.core.graph.VNodeObjectSomeValuesFromImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class VNodeImpl
implements VNode {
    private final int classIdentifier;
    private final Set<VNodeObjectSomeValuesFrom> existentialSet = new HashSet<VNodeObjectSomeValuesFrom>();

    public VNodeImpl(int id) {
        this.classIdentifier = id;
    }

    public boolean addExistential(int propertyId, int classId) {
        boolean ret = this.existentialSet.add(new VNodeObjectSomeValuesFromImpl(propertyId, classId));
        return ret;
    }

    public boolean addExistentialsOf(VNode other) {
        Objects.requireNonNull(other);
        return this.existentialSet.addAll(other.getExistentialEntries());
    }

    @Override
    public boolean containsExistential(int propertyId, int classId) {
        return this.existentialSet.contains(new VNodeObjectSomeValuesFromImpl(propertyId, classId));
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof VNode) {
            VNode other = (VNode)o;
            ret = this.getClassId() == other.getClassId() && this.getExistentialEntries().equals(other.getExistentialEntries());
        }
        return ret;
    }

    @Override
    public int getClassId() {
        return this.classIdentifier;
    }

    public long getDeepSize() {
        return this.existentialSet.size();
    }

    @Override
    public Collection<VNodeObjectSomeValuesFrom> getExistentialEntries() {
        return Collections.unmodifiableSet(this.existentialSet);
    }

    public int hashCode() {
        return this.classIdentifier + 31 * this.existentialSet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.existentialSet.isEmpty();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.classIdentifier);
        ret.append(" ");
        this.existentialSet.forEach(expression -> {
            ret.append(expression.toString());
            ret.append(", ");
        });
        ret.append(" ");
        return ret.toString();
    }
}

