/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.saturation;

import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class SaturationRuleHelper {
    public Map<Integer, Set<Integer>> getMapBySubObjectProperty(Set<RI2Axiom> axiomSet) {
        Objects.requireNonNull(axiomSet);
        HashMap ret = new HashMap();
        axiomSet.forEach(axiom -> {
            HashSet<Integer> relatedElemSet = (HashSet<Integer>)ret.get(axiom.getSubProperty());
            if (Objects.isNull(relatedElemSet)) {
                relatedElemSet = new HashSet<Integer>();
                ret.put(axiom.getSubProperty(), relatedElemSet);
            }
            relatedElemSet.add(axiom.getSuperProperty());
        });
        return Collections.unmodifiableMap(ret);
    }

    public Map<Integer, Set<Integer>> getMapBySuperObjectProperty(Set<RI2Axiom> axiomSet) {
        Objects.requireNonNull(axiomSet);
        HashMap ret = new HashMap();
        axiomSet.forEach(axiom -> {
            HashSet<Integer> relatedElemSet = (HashSet<Integer>)ret.get(axiom.getSuperProperty());
            if (Objects.isNull(relatedElemSet)) {
                relatedElemSet = new HashSet<Integer>();
                ret.put(axiom.getSuperProperty(), relatedElemSet);
            }
            relatedElemSet.add(axiom.getSubProperty());
        });
        return Collections.unmodifiableMap(ret);
    }

    public Set<Integer> getReachable(Integer first, Map<Integer, Set<Integer>> map) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(map);
        HashSet<Integer> ret = new HashSet<Integer>();
        HashSet<Integer> toVisit = new HashSet<Integer>();
        toVisit.add(first);
        while (!toVisit.isEmpty()) {
            Integer elem = (Integer)toVisit.iterator().next();
            toVisit.remove(elem);
            ret.add(elem);
            Set<Integer> set = map.get(elem);
            if (!Objects.nonNull(set)) continue;
            set.forEach(newElem -> {
                if (!ret.contains(newElem)) {
                    toVisit.add((Integer)newElem);
                }
            });
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<RI2Axiom> getRI2Axioms(Set<NormalizedIntegerAxiom> originalSet) {
        Objects.requireNonNull(originalSet);
        HashSet ret = new HashSet();
        originalSet.forEach(axiom -> {
            if (axiom instanceof RI2Axiom) {
                ret.add((RI2Axiom)axiom);
            }
        });
        return Collections.unmodifiableSet(ret);
    }
}

