/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.Owl2StreamLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyPrinter;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.logging.Statistics;

public class Main {
    private static final Logger LOGGER_ = Logger.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> inputFile = parser.acceptsAll(Arrays.asList("input", "i"), "input ontology file").withRequiredArg().ofType(File.class).describedAs("ontology");
        ArgumentAcceptingOptionSpec<File> outputFile = parser.acceptsAll(Arrays.asList("output", "o"), "output taxonomy file").withRequiredArg().ofType(File.class).describedAs("taxonomy");
        OptionSpecBuilder printHash = parser.acceptsAll(Arrays.asList("print-hash"), "print taxonomy hash to log");
        OptionSpecBuilder classify = parser.acceptsAll(Arrays.asList("classify", "c"), "classify the ontology");
        OptionSpecBuilder realize = parser.acceptsAll(Arrays.asList("realize", "r"), "realize the ontology");
        OptionSpecBuilder satisfiable = parser.acceptsAll(Arrays.asList("consistent", "satisfiable", "s"), "check consistency of the ontology");
        ArgumentAcceptingOptionSpec<Integer> nWorkers = parser.acceptsAll(Arrays.asList("workers", "w"), "number of concurrent worker threads").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<String> logging = parser.acceptsAll(Arrays.asList("logging", "l"), "logging level for log4j; default INFO").withRequiredArg().ofType(String.class).describedAs("level");
        OptionSpecBuilder verbose = parser.acceptsAll(Arrays.asList("verbose", "v"), "equivalent to --logging=DEBUG");
        OptionSpecBuilder Verbose = parser.acceptsAll(Arrays.asList("Verbose", "V"), "equivalent to --logging=TRACE");
        OptionSpecBuilder quiet = parser.acceptsAll(Arrays.asList("quiet", "q"), "equivalent to --logging=ERROR");
        OptionSpecBuilder version = parser.acceptsAll(Arrays.asList("version"), "print version information");
        OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("help", "h", "?"), "show help");
        OptionSet options = parser.parse(args);
        if (!options.hasOptions() || options.has(help)) {
            parser.printHelpOn(System.out);
            return;
        }
        if (options.has(version)) {
            System.out.println(Main.class.getPackage().getImplementationTitle() + " " + Main.class.getPackage().getImplementationVersion());
            return;
        }
        if (!options.has(inputFile) || Main.countOptions(options, satisfiable, classify, realize) != 1) {
            System.err.println("An input ontology and exactly one reasoning task are required!");
            return;
        }
        if (Main.countOptions(options, logging, verbose, Verbose, quiet) > 1) {
            System.err.println("Cannot set more than one logging level!");
            return;
        }
        Logger allLoggers = Logger.getLogger("org.semanticweb.elk");
        if (options.has(logging)) {
            allLoggers.setLevel(Level.toLevel(options.valueOf(logging), Level.INFO));
        }
        if (options.has(verbose)) {
            allLoggers.setLevel(Level.DEBUG);
        }
        if (options.has(Verbose)) {
            allLoggers.setLevel(Level.TRACE);
        }
        if (options.has(quiet)) {
            allLoggers.setLevel(Level.ERROR);
        }
        ReasonerConfiguration configuration = ReasonerConfiguration.getConfiguration();
        if (options.has(nWorkers)) {
            configuration.setParameter("elk.reasoner.number_of_workers", options.valueOf(nWorkers).toString());
        }
        ReasonerFactory reasoningFactory = new ReasonerFactory();
        Owl2FunctionalStyleParserFactory parserFactory = new Owl2FunctionalStyleParserFactory();
        Owl2StreamLoader loader = new Owl2StreamLoader((Owl2ParserFactory)parserFactory, options.valueOf(inputFile));
        Reasoner reasoner = reasoningFactory.createReasoner(loader, new LoggingStageExecutor(), configuration);
        try {
            if (options.has(satisfiable)) {
                boolean inconsistent = reasoner.isInconsistent();
                if (options.hasArgument(outputFile)) {
                    Main.writeConsistencyToFile(options.valueOf(outputFile), !inconsistent);
                }
            }
            if (options.has(classify)) {
                Taxonomy<ElkClass> taxonomy = reasoner.getTaxonomyQuietly();
                if (options.hasArgument(outputFile)) {
                    Main.writeClassTaxonomyToFile(options.valueOf(outputFile), taxonomy);
                }
                if (options.has(printHash)) {
                    Main.printTaxonomyHash(taxonomy);
                }
            }
            if (options.has(realize)) {
                InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = null;
                taxonomy = reasoner.getInstanceTaxonomyQuietly();
                if (options.hasArgument(outputFile)) {
                    Main.writeInstanceTaxonomyToFile(options.valueOf(outputFile), taxonomy);
                }
                if (options.has(printHash)) {
                    Main.printTaxonomyHash(taxonomy);
                }
            }
        }
        finally {
            reasoner.shutdown();
        }
    }

    static void writeConsistencyToFile(File file, Boolean consistent) throws IOException, ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info("Writing consistency to " + file);
        }
        FileWriter fstream = new FileWriter(file);
        BufferedWriter writer = new BufferedWriter(fstream);
        writer.write(consistent.toString() + "\n");
        writer.write("# The ontology is " + (consistent != false ? "consistent" : "inconsistent") + ".\n");
        writer.close();
    }

    static void writeClassTaxonomyToFile(File file, Taxonomy<ElkClass> taxonomy) throws IOException, ElkInconsistentOntologyException, ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info("Writing taxonomy to " + file);
        }
        Statistics.logOperationStart("Writing taxonomy", LOGGER_);
        TaxonomyPrinter.dumpClassTaxomomyToFile(taxonomy, file.getPath(), true);
        Statistics.logOperationFinish("Writing taxonomy", LOGGER_);
    }

    static void writeInstanceTaxonomyToFile(File file, InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) throws IOException, ElkInconsistentOntologyException, ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info("Writing taxonomy with instances to " + file);
        }
        Statistics.logOperationStart("Writing taxonomy with instances", LOGGER_);
        TaxonomyPrinter.dumpInstanceTaxomomyToFile(taxonomy, file.getPath(), true);
        Statistics.logOperationFinish("Writing taxonomy with instances", LOGGER_);
    }

    static void printTaxonomyHash(Taxonomy<ElkClass> taxonomy) {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info("Taxonomy hash: " + Integer.toHexString(TaxonomyHasher.hash(taxonomy)));
        }
    }

    static void printTaxonomyHash(InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info("Taxonomy hash: " + Integer.toHexString(InstanceTaxonomyHasher.hash(taxonomy)));
        }
    }

    static int countOptions(OptionSet options, OptionSpec<?> ... specs) {
        int count = 0;
        for (OptionSpec<?> s : specs) {
            if (!options.has(s)) continue;
            ++count;
        }
        return count;
    }
}

