/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassEntityVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class IndexedClass
extends IndexedClassEntity {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedClass.class);
    protected final ElkClass elkClass;
    protected int occurrenceNo = 0;

    protected IndexedClass(ElkClass elkClass) {
        this.elkClass = elkClass;
    }

    public ElkClass getElkClass() {
        return this.elkClass;
    }

    public <O> O accept(IndexedClassVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedClassEntityVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment, int positiveIncrement, int negativeIncrement) {
        if (this.occurrenceNo == 0 && increment > 0) {
            index.addClass(this.elkClass);
        }
        if (this.negativeOccurrenceNo == 0 && negativeIncrement > 0 && this.elkClass == PredefinedElkClass.OWL_THING) {
            index.addContextInitRule(new OwlThingContextInitializationRule());
        }
        this.occurrenceNo += increment;
        this.positiveOccurrenceNo += positiveIncrement;
        this.negativeOccurrenceNo += negativeIncrement;
        if (this.occurrenceNo == 0 && increment < 0) {
            index.removeClass(this.elkClass);
        }
        if (this.negativeOccurrenceNo == 0 && negativeIncrement < 0 && this.elkClass == PredefinedElkClass.OWL_THING) {
            index.removeContextInitRule(new OwlThingContextInitializationRule());
        }
    }

    @Override
    public String printOccurrenceNumbers() {
        return "[all=" + this.occurrenceNo + "; pos=" + this.positiveOccurrenceNo + "; neg=" + this.negativeOccurrenceNo + "]";
    }

    @Override
    public void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(this.toString() + " occurences: " + this.printOccurrenceNumbers());
        }
        if (this.occurrenceNo < 0 || this.positiveOccurrenceNo < 0 || this.negativeOccurrenceNo < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    @Override
    public boolean occurs() {
        return this.occurrenceNo > 0;
    }

    @Override
    public void accept(DecompositionRuleApplicationVisitor visitor, Context context) {
        visitor.visit(this, context);
    }

    @Override
    public String toStringStructural() {
        return '<' + this.getElkClass().getIri().getFullIriAsString() + '>';
    }

    public static class OwlThingContextInitializationRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        public static final String NAME = "owl:Thing Introduction";
        private static final Matcher<ChainableRule<Context>, OwlThingContextInitializationRule> MATCHER_ = new SimpleTypeBasedMatcher<ChainableRule<Context>, OwlThingContextInitializationRule>(OwlThingContextInitializationRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, OwlThingContextInitializationRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, OwlThingContextInitializationRule>(){

            @Override
            public OwlThingContextInitializationRule create(ChainableRule<Context> tail) {
                return new OwlThingContextInitializationRule(tail);
            }
        };

        private OwlThingContextInitializationRule(ChainableRule<Context> tail) {
            super(tail);
        }

        public OwlThingContextInitializationRule() {
            super(null);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("Applying owl:Thing Introduction to " + context);
            }
            writer.produce(context, new PositiveSubsumer(writer.getOwlThing()));
        }

        @Override
        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            OwlThingContextInitializationRule rule = ruleChain.find(MATCHER_);
            if (rule == null) {
                ruleChain.getCreate(MATCHER_, FACTORY_);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            return ruleChain.remove(MATCHER_) != null;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }
    }
}

