/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectPropertyVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitorEx;

public class IndexedObjectProperty
extends IndexedPropertyChain {
    protected final ElkObjectProperty elkObjectProperty;
    private Collection<IndexedBinaryPropertyChain> leftChains_;
    protected List<IndexedPropertyChain> toldSubProperties;
    int reflexiveAxiomOccurrenceNo = 0;

    protected IndexedObjectProperty(ElkObjectProperty elkObjectProperty) {
        this.elkObjectProperty = elkObjectProperty;
    }

    public ElkObjectProperty getElkObjectProperty() {
        return this.elkObjectProperty;
    }

    public List<IndexedPropertyChain> getToldSubProperties() {
        return this.toldSubProperties == null ? Collections.emptyList() : Collections.unmodifiableList(this.toldSubProperties);
    }

    public Collection<IndexedBinaryPropertyChain> getLeftChains() {
        return this.leftChains_ == null ? Collections.emptySet() : Collections.unmodifiableCollection(this.leftChains_);
    }

    protected void addLeftChain(IndexedBinaryPropertyChain chain) {
        if (this.leftChains_ == null) {
            this.leftChains_ = new ArrayList<IndexedBinaryPropertyChain>(1);
        }
        this.leftChains_.add(chain);
    }

    protected boolean removeLeftChain(IndexedBinaryPropertyChain chain) {
        boolean success = false;
        if (this.leftChains_ != null) {
            success = this.leftChains_.remove(chain);
            if (this.leftChains_.isEmpty()) {
                this.leftChains_ = null;
            }
        }
        return success;
    }

    public boolean isToldReflexive() {
        return this.reflexiveAxiomOccurrenceNo > 0;
    }

    protected void addToldSubPropertyChain(IndexedPropertyChain subObjectProperty) {
        if (this.toldSubProperties == null) {
            this.toldSubProperties = new ArrayList<IndexedPropertyChain>(1);
        }
        this.toldSubProperties.add(subObjectProperty);
    }

    protected boolean removeToldSubObjectProperty(IndexedPropertyChain subObjectProperty) {
        boolean success = false;
        if (this.toldSubProperties != null) {
            success = this.toldSubProperties.remove(subObjectProperty);
            if (this.toldSubProperties.isEmpty()) {
                this.toldSubProperties = null;
            }
        }
        return success;
    }

    @Override
    protected void updateOccurrenceNumber(int increment) {
        this.occurrenceNo += increment;
    }

    public <O> O accept(IndexedObjectPropertyVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedPropertyChainVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toStringStructural() {
        return '<' + this.getElkObjectProperty().getIri().getFullIriAsString() + '>';
    }

    @Override
    public <O, P> O accept(IndexedPropertyChainVisitorEx<O, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }
}

