/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionCounter;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionTimer;

public class ConclusionStatistics {
    private final ConclusionCounter producedConclusionCounts_;
    private final ConclusionCounter processedConclusionCounts_;
    private final ConclusionCounter usedConclusionCounts_;
    private final ConclusionTimer conclusionProcessingTimer_;
    private int numOfMeasurements_ = 0;
    private static String ERR_MSG_MORE_USED = ": more used that processed!";

    public ConclusionStatistics(ConclusionCounter producedConclusionCounter, ConclusionCounter processedConclusionCounts, ConclusionCounter usedConclusionCounts, ConclusionTimer conclusionTimers) {
        this.producedConclusionCounts_ = producedConclusionCounter;
        this.processedConclusionCounts_ = processedConclusionCounts;
        this.usedConclusionCounts_ = usedConclusionCounts;
        this.conclusionProcessingTimer_ = conclusionTimers;
    }

    public ConclusionStatistics() {
        this(new ConclusionCounter(), new ConclusionCounter(), new ConclusionCounter(), new ConclusionTimer());
    }

    public ConclusionCounter getProducedConclusionCounts() {
        return this.producedConclusionCounts_;
    }

    public ConclusionCounter getProcessedConclusionCounts() {
        return this.processedConclusionCounts_;
    }

    public ConclusionCounter getUsedConclusionCounts() {
        return this.usedConclusionCounts_;
    }

    public ConclusionTimer getConclusionTimers() {
        return this.conclusionProcessingTimer_;
    }

    public void reset() {
        this.producedConclusionCounts_.reset();
        this.processedConclusionCounts_.reset();
        this.usedConclusionCounts_.reset();
        this.conclusionProcessingTimer_.reset();
        this.numOfMeasurements_ = 0;
    }

    public synchronized void add(ConclusionStatistics stats) {
        if (stats.measurementsTaken()) {
            this.numOfMeasurements_ += stats.numOfMeasurements_;
            this.producedConclusionCounts_.add(stats.producedConclusionCounts_);
            this.processedConclusionCounts_.add(stats.processedConclusionCounts_);
            this.usedConclusionCounts_.add(stats.usedConclusionCounts_);
            this.conclusionProcessingTimer_.add(stats.conclusionProcessingTimer_);
        }
    }

    public void check(Logger logger) {
        if (this.usedConclusionCounts_.countPositiveSubsumers > this.processedConclusionCounts_.countPositiveSubsumers) {
            logger.error("Positive Subsumers" + ERR_MSG_MORE_USED);
        }
        if (this.usedConclusionCounts_.countNegativeSubsumers > this.processedConclusionCounts_.countNegativeSubsumers) {
            logger.error("Negative Subsumers" + ERR_MSG_MORE_USED);
        }
        if (this.usedConclusionCounts_.countBackwardLinks > this.processedConclusionCounts_.countBackwardLinks) {
            logger.error("Backward Links" + ERR_MSG_MORE_USED);
        }
        if (this.usedConclusionCounts_.countForwardLinks > this.processedConclusionCounts_.countForwardLinks) {
            logger.error("Forward Links" + ERR_MSG_MORE_USED);
        }
        if (this.usedConclusionCounts_.countPropagations > this.processedConclusionCounts_.countPropagations) {
            logger.error("Propagations" + ERR_MSG_MORE_USED);
        }
        if (this.usedConclusionCounts_.countContradictions > this.processedConclusionCounts_.countContradictions) {
            logger.error("Contradictions" + ERR_MSG_MORE_USED);
        }
        if (this.usedConclusionCounts_.countDisjointnessAxioms > this.processedConclusionCounts_.countDisjointnessAxioms) {
            logger.error("Disjointness Axioms" + ERR_MSG_MORE_USED);
        }
    }

    public void print(Logger logger) {
        long totalTime;
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (!this.measurementsTaken()) {
            return;
        }
        if (this.processedConclusionCounts_.countPositiveSubsumers > 0 || this.conclusionProcessingTimer_.timePositiveSubsumers > 0L) {
            logger.debug("Positive Subsumers produced/used: " + this.processedConclusionCounts_.countPositiveSubsumers + "/" + this.usedConclusionCounts_.countPositiveSubsumers + " (" + this.conclusionProcessingTimer_.timePositiveSubsumers / (long)this.numOfMeasurements_ + " ms)");
        }
        if (this.processedConclusionCounts_.countNegativeSubsumers > 0 || this.conclusionProcessingTimer_.timeNegativeSubsumers > 0L) {
            logger.debug("Negative Subsumers produced/used: " + this.processedConclusionCounts_.countNegativeSubsumers + "/" + this.usedConclusionCounts_.countNegativeSubsumers + " (" + this.conclusionProcessingTimer_.timeNegativeSubsumers / (long)this.numOfMeasurements_ + " ms)");
        }
        if (this.processedConclusionCounts_.countBackwardLinks > 0 || this.conclusionProcessingTimer_.timeBackwardLinks > 0L) {
            logger.debug("Backward Links produced/used: " + this.processedConclusionCounts_.countBackwardLinks + "/" + this.usedConclusionCounts_.countBackwardLinks + " (" + this.conclusionProcessingTimer_.timeBackwardLinks / (long)this.numOfMeasurements_ + " ms)");
        }
        if (this.processedConclusionCounts_.countForwardLinks > 0 || this.conclusionProcessingTimer_.timeForwardLinks > 0L) {
            logger.debug("Forward Links produced/used: " + this.processedConclusionCounts_.countForwardLinks + "/" + this.usedConclusionCounts_.countForwardLinks + " (" + this.conclusionProcessingTimer_.timeForwardLinks / (long)this.numOfMeasurements_ + " ms)");
        }
        if (this.processedConclusionCounts_.countPropagations > 0 || this.conclusionProcessingTimer_.timePropagations > 0L) {
            logger.debug("Propagations produced/used: " + this.processedConclusionCounts_.countPropagations + "/" + this.usedConclusionCounts_.countPropagations + " (" + this.conclusionProcessingTimer_.timePropagations / (long)this.numOfMeasurements_ + " ms)");
        }
        if (this.processedConclusionCounts_.countContradictions > 0 || this.conclusionProcessingTimer_.timeContradictions > 0L) {
            logger.debug("Contradictions produced/used: " + this.processedConclusionCounts_.countContradictions + "/" + this.usedConclusionCounts_.countContradictions + " (" + this.conclusionProcessingTimer_.timeContradictions / (long)this.numOfMeasurements_ + " ms)");
        }
        if (this.processedConclusionCounts_.countDisjointnessAxioms > 0 || this.conclusionProcessingTimer_.timeDisjointnessAxioms > 0L) {
            logger.debug("Disjointness Axioms produced/used: " + this.processedConclusionCounts_.countDisjointnessAxioms + "/" + this.usedConclusionCounts_.countDisjointnessAxioms + " (" + this.conclusionProcessingTimer_.timeDisjointnessAxioms / (long)this.numOfMeasurements_ + " ms)");
        }
        if ((totalTime = this.conclusionProcessingTimer_.getTotalTime()) > 0L) {
            logger.debug("Total conclusion processing time: " + totalTime / (long)this.numOfMeasurements_ + " ms");
        }
    }

    public void startMeasurements() {
        if (this.numOfMeasurements_ < 1) {
            this.numOfMeasurements_ = 1;
        }
    }

    private boolean measurementsTaken() {
        return this.numOfMeasurements_ > 0;
    }
}

