/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionTimer;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.conclusions.DisjointnessAxiom;
import org.semanticweb.elk.reasoner.saturation.conclusions.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.Propagation;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.util.logging.CachedTimeThread;

public class TimedConclusionVisitor
implements ConclusionVisitor<Long> {
    private final ConclusionTimer timer_;
    private final ConclusionVisitor<?> processor_;

    public TimedConclusionVisitor(ConclusionTimer timer, ConclusionVisitor<?> processor) {
        this.timer_ = timer;
        this.processor_ = processor;
    }

    @Override
    public Long visit(NegativeSubsumer negSCE, Context context) {
        this.timer_.timeNegativeSubsumers -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(negSCE, context);
        return this.timer_.timeNegativeSubsumers += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    public Long visit(PositiveSubsumer posSCE, Context context) {
        this.timer_.timePositiveSubsumers -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(posSCE, context);
        return this.timer_.timePositiveSubsumers += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    public Long visit(BackwardLink link, Context context) {
        this.timer_.timeBackwardLinks -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(link, context);
        return this.timer_.timeBackwardLinks += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    public Long visit(ForwardLink link, Context context) {
        this.timer_.timeForwardLinks -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(link, context);
        return this.timer_.timeForwardLinks += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    public Long visit(Contradiction bot, Context context) {
        this.timer_.timeContradictions -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(bot, context);
        return this.timer_.timeContradictions += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    public Long visit(Propagation propagation, Context context) {
        this.timer_.timePropagations -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(propagation, context);
        return this.timer_.timePropagations += CachedTimeThread.getCurrentTimeMillis();
    }

    @Override
    public Long visit(DisjointnessAxiom disjointnessAxiom, Context context) {
        this.timer_.timeDisjointnessAxioms -= CachedTimeThread.getCurrentTimeMillis();
        this.processor_.visit(disjointnessAxiom, context);
        return this.timer_.timeDisjointnessAxioms += CachedTimeThread.getCurrentTimeMillis();
    }
}

