/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules;

import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;

abstract class BasicDecompositionRuleApplicationVisitor
implements DecompositionRuleApplicationVisitor {
    protected static final Logger LOGGER_ = Logger.getLogger(BasicDecompositionRuleApplicationVisitor.class);

    BasicDecompositionRuleApplicationVisitor() {
    }

    @Override
    public void visit(IndexedClass ice, Context context) {
        BasicSaturationStateWriter writer = this.getSaturationStateWriter();
        if (ice == this.getSaturationStateWriter().getOwlNothing()) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("Producing contradiction for " + context.getRoot());
            }
            writer.produce(context, Contradiction.getInstance());
        }
    }

    @Override
    public void visit(IndexedDataHasValue ice, Context context) {
    }

    @Override
    public void visit(IndexedObjectComplementOf ice, Context context) {
        BasicSaturationStateWriter writer = this.getSaturationStateWriter();
        if (context.getSubsumers().contains(ice.getNegated())) {
            writer.produce(context, Contradiction.getInstance());
        }
    }

    @Override
    public void visit(IndexedObjectIntersectionOf ice, Context context) {
        BasicSaturationStateWriter writer = this.getSaturationStateWriter();
        writer.produce(context, new PositiveSubsumer(ice.getFirstConjunct()));
        writer.produce(context, new PositiveSubsumer(ice.getSecondConjunct()));
    }

    protected abstract BasicSaturationStateWriter getSaturationStateWriter();
}

