/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.ClassTaxonomyComputation;
import org.semanticweb.elk.util.collections.Operations;

public class IncrementalClassTaxonomyComputationStage
extends AbstractReasonerStage {
    protected ClassTaxonomyComputation computation_ = null;

    public IncrementalClassTaxonomyComputationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return IncrementalStages.TAXONOMY_CONSTRUCTION.toString();
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        Operations.Transformation<ElkClass, IndexedClass> transformation = new Operations.Transformation<ElkClass, IndexedClass>(){

            @Override
            public IndexedClass transform(ElkClass element) {
                IndexedClass indexedClass = (IndexedClass)element.accept(IncrementalClassTaxonomyComputationStage.this.reasoner.objectCache_.getIndexObjectConverter());
                return indexedClass.occurs() ? indexedClass : null;
            }
        };
        Collection<IndexedClass> modified = Operations.getCollection(Operations.map(this.reasoner.classTaxonomyState.classesForModifiedNodes, transformation), this.reasoner.classTaxonomyState.classesForModifiedNodes.size());
        this.computation_ = new ClassTaxonomyComputation(Operations.split(modified, 64), this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.saturationState, this.reasoner.classTaxonomyState.getTaxonomy());
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.classTaxonomyState.getWriter().clearModifiedNodeObjects();
        this.reasoner.ontologyIndex.initClassSignatureChanges();
        this.reasoner.ruleAndConclusionStats.add(this.computation_.getRuleAndConclusionStatistics());
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }

    @Override
    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.setInterrupt(this.computation_, flag);
    }
}

