/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import java.util.LinkedHashMap;
import java.util.Map;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class NodeHasher
implements Hasher<Node<? extends ElkEntity>> {
    public static NodeHasher INSTANCE = new NodeHasher();
    final Hasher<ElkEntity> elkEntityHasher = new Hasher<ElkEntity>(){

        @Override
        public int hash(ElkEntity elkEntity) {
            return elkEntity.getIri().hashCode();
        }
    };
    final int cacheNodeMemberNo = 50;
    final int cacheMaxSize = 100;
    final LinkedHashMap<Node<? extends ElkEntity>, Integer> hashCache = new LinkedHashMap<Node<? extends ElkEntity>, Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Node<? extends ElkEntity>, Integer> eldest) {
            return this.size() > 100;
        }
    };

    private NodeHasher() {
    }

    @Override
    public int hash(Node<? extends ElkEntity> node) {
        if (node.getMembers().size() >= 50) {
            if (this.hashCache.containsKey(node)) {
                return this.hashCache.get(node);
            }
            int hash = HashGenerator.combineMultisetHash(true, node.getMembers(), this.elkEntityHasher);
            this.hashCache.put(node, hash);
            return hash;
        }
        return HashGenerator.combineMultisetHash(true, node.getMembers(), this.elkEntityHasher);
    }
}

