/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections.chains;

import java.util.Map;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLink;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;

public abstract class AbstractChain<T extends ModifiableLink<T>>
implements Chain<T> {
    @Override
    public <S extends T> S find(Matcher<T, S> matcher) {
        ModifiableLink candidate = (ModifiableLink)this.next();
        while (candidate != null) {
            ModifiableLink match = (ModifiableLink)matcher.match(candidate);
            if (match != null) {
                return (S)match;
            }
            candidate = (ModifiableLink)candidate.next();
        }
        return null;
    }

    @Override
    public <S extends T> S getCreate(Matcher<T, S> matcher, ReferenceFactory<T, S> factory) {
        ModifiableLink candidate = (ModifiableLink)this.next();
        while (true) {
            if (candidate == null) {
                S result = factory.create(this.next());
                this.setNext(result);
                return result;
            }
            ModifiableLink match = (ModifiableLink)matcher.match(candidate);
            if (match != null) {
                return (S)match;
            }
            candidate = (ModifiableLink)candidate.next();
        }
    }

    @Override
    public <S extends T> S remove(Matcher<T, S> matcher) {
        ModifiableLink<T> point = this;
        ModifiableLink next;
        while ((next = (ModifiableLink)point.next()) != null) {
            ModifiableLink match = (ModifiableLink)matcher.match(next);
            if (match != null) {
                point.setNext(next.next());
                return (S)match;
            }
            point = next;
        }
        return null;
    }

    public static <K, T extends ModifiableLink<T>> Chain<T> getMapBackedChain(final Map<K, T> map, final K key) {
        return new AbstractChain<T>(){

            @Override
            public T next() {
                return (ModifiableLink)map.get(key);
            }

            @Override
            public void setNext(T next) {
                if (next == null) {
                    map.remove(key);
                } else {
                    map.put(key, next);
                }
            }
        };
    }
}

