/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.semanticweb.elk.util.collections.DirectAccess;

public class ArrayHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    protected volatile transient K[] keys;
    protected volatile transient V[] values;
    protected transient int size;
    int upperSize;
    int lowerSize;

    public ArrayHashMap(int initialCapacity) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.size = 0;
        this.upperSize = ArrayHashMap.computeUpperSize(capacity);
        this.lowerSize = ArrayHashMap.computeLowerSize(capacity);
    }

    public ArrayHashMap() {
        int capacity = 16;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.size = 0;
        this.upperSize = ArrayHashMap.computeUpperSize(capacity);
        this.lowerSize = ArrayHashMap.computeLowerSize(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int computeUpperSize(int capacity) {
        if (capacity > 64) {
            return 3 * capacity / 4;
        }
        return capacity;
    }

    private static int computeLowerSize(int capacity) {
        return capacity / 4;
    }

    private static int getIndex(Object key, int length) {
        return key.hashCode() & length - 1;
    }

    @Override
    public boolean containsKey(Object key) {
        int i;
        if (key == null) {
            throw new NullPointerException();
        }
        K[] keys = this.keys;
        int j = i = ArrayHashMap.getIndex(key, keys.length);
        do {
            K probe;
            if ((probe = keys[i]) == null) {
                return false;
            }
            if (key.equals(probe)) {
                return true;
            }
            if (i == 0) {
                i = keys.length - 1;
                continue;
            }
            --i;
        } while (i != j);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        V[] values = this.values;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!value.equals(values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int i;
        V[] values;
        K[] keys;
        if (key == null) {
            throw new NullPointerException();
        }
        while ((keys = this.keys).length != (values = this.values).length) {
        }
        int j = i = ArrayHashMap.getIndex(key, keys.length);
        do {
            K probe;
            if ((probe = keys[i]) == null) {
                return null;
            }
            if (key.equals(probe)) {
                return values[i];
            }
            if (i == 0) {
                i = keys.length - 1;
                continue;
            }
            --i;
        } while (i != j);
        return null;
    }

    private V putKeyValue(K[] keys, V[] values, K key, V value) {
        int i = ArrayHashMap.getIndex(key, keys.length);
        while (true) {
            K probe;
            if ((probe = keys[i]) == null) {
                keys[i] = key;
                values[i] = value;
                return null;
            }
            if (key.equals(probe)) {
                V oldValue = values[i];
                values[i] = value;
                return oldValue;
            }
            if (i == 0) {
                i = keys.length - 1;
                continue;
            }
            --i;
        }
    }

    private void shift(K[] keys, V[] values, int i) {
        int del = i;
        int j = i;
        while (true) {
            j = j == 0 ? keys.length - 1 : --j;
            if (j == del) {
                keys[del] = null;
                values[del] = null;
                return;
            }
            K test = keys[j];
            if (test == null) {
                keys[del] = null;
                values[del] = null;
                return;
            }
            int k = ArrayHashMap.getIndex(test, keys.length);
            if (j < del ? j <= k && k < del : j <= k || k < del) continue;
            keys[del] = test;
            values[del] = values[j];
            del = j;
        }
    }

    private V removeEntry(K[] keys, V[] values, Object key) {
        int i;
        int j = i = ArrayHashMap.getIndex(key, keys.length);
        do {
            K probe;
            if ((probe = keys[i]) == null) {
                return null;
            }
            if (key.equals(probe)) {
                V result = values[i];
                this.shift(keys, values, i);
                return result;
            }
            if (i == 0) {
                i = keys.length - 1;
                continue;
            }
            --i;
        } while (i != j);
        return null;
    }

    private void stretch() {
        int oldCapacity = this.keys.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalArgumentException("Map cannot grow beyond capacity: 1073741824");
        }
        K[] oldKeys = this.keys;
        V[] oldValues = this.values;
        int newCapacity = oldCapacity << 1;
        Object[] newKeys = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            K key = oldKeys[i];
            if (key == null) continue;
            this.putKeyValue(newKeys, newValues, key, oldValues[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
        this.upperSize = ArrayHashMap.computeUpperSize(newCapacity);
        this.lowerSize = ArrayHashMap.computeLowerSize(newCapacity);
    }

    private void shrink() {
        int oldCapacity = this.keys.length;
        if (oldCapacity <= 16) {
            return;
        }
        K[] oldKeys = this.keys;
        V[] oldValues = this.values;
        int newCapacity = oldCapacity >> 1;
        Object[] newKeys = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            K key = oldKeys[i];
            if (key == null) continue;
            this.putKeyValue(newKeys, newValues, key, oldValues[i]);
        }
        this.keys = newKeys;
        this.values = newValues;
        this.upperSize = ArrayHashMap.computeUpperSize(newCapacity);
        this.lowerSize = ArrayHashMap.computeLowerSize(newCapacity);
    }

    @Override
    public V put(K key, V value) {
        V result;
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.size == this.upperSize) {
            this.stretch();
        }
        if ((result = this.putKeyValue(this.keys, this.values, key, value)) == null) {
            ++this.size;
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        V result = this.removeEntry(this.keys, this.values, key);
        if (result != null) {
            --this.size;
        }
        if (this.size == this.lowerSize) {
            this.shrink();
        }
        return result;
    }

    @Override
    public void clear() {
        int capacity = this.keys.length >> 2;
        if (capacity == 0) {
            capacity = 1;
        }
        this.size = 0;
        this.upperSize = ArrayHashMap.computeUpperSize(capacity);
        this.lowerSize = ArrayHashMap.computeLowerSize(capacity);
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            return ArrayHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            return ArrayHashMap.this.remove(k) != null;
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public void clear() {
            ArrayHashMap.this.clear();
        }
    }

    class Entry
    implements Map.Entry<K, V> {
        final EntryIterator iterator;
        final int cursor;

        Entry(EntryIterator iterator, int cursor) {
            this.iterator = iterator;
            this.cursor = cursor;
        }

        @Override
        public K getKey() {
            return this.iterator.keysSnapshot[this.cursor];
        }

        @Override
        public V getValue() {
            return this.iterator.valuesSnapshot[this.cursor];
        }

        @Override
        public V setValue(V value) {
            Object previous = this.iterator.valuesSnapshot[this.cursor];
            this.iterator.valuesSnapshot[this.cursor] = value;
            return previous;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final K[] keysSnapshot;
        final V[] valuesSnapshot;
        final int expectedSize;
        int cursor;
        K nextKey;

        EntryIterator() {
            this.expectedSize = ArrayHashMap.this.size;
            this.keysSnapshot = ArrayHashMap.this.keys;
            this.valuesSnapshot = ArrayHashMap.this.values;
            this.cursor = 0;
            this.seekNext();
        }

        void seekNext() {
            while (this.cursor < this.keysSnapshot.length) {
                if ((this.nextKey = this.keysSnapshot[this.cursor++]) == null) continue;
                return;
            }
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Entry next() {
            if (this.expectedSize != ArrayHashMap.this.size) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            Entry result = new Entry(this, this.cursor - 1);
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ValueCollection
    extends AbstractCollection<V>
    implements DirectAccess<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public V[] getRawData() {
            return ArrayHashMap.this.values;
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        final V[] valuesSnapshot;
        final int expectedSize;
        int cursor;
        V nextValue;

        ValueIterator() {
            this.expectedSize = ArrayHashMap.this.size;
            this.valuesSnapshot = ArrayHashMap.this.values;
            this.cursor = 0;
            this.seekNext();
        }

        void seekNext() {
            while (this.cursor < this.valuesSnapshot.length) {
                if ((this.nextValue = this.valuesSnapshot[this.cursor++]) == null) continue;
                return;
            }
            this.nextValue = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public V next() {
            if (this.expectedSize != ArrayHashMap.this.size) {
                throw new ConcurrentModificationException();
            }
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            Object result = this.nextValue;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractSet<K>
    implements DirectAccess<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ArrayHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return ArrayHashMap.this.size;
        }

        @Override
        public K[] getRawData() {
            return ArrayHashMap.this.keys;
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        final K[] keysSnapshot;
        final int expectedSize;
        int cursor;
        K nextKey;

        KeyIterator() {
            this.expectedSize = ArrayHashMap.this.size;
            this.keysSnapshot = ArrayHashMap.this.keys;
            this.cursor = 0;
            this.seekNext();
        }

        void seekNext() {
            while (this.cursor < this.keysSnapshot.length) {
                if ((this.nextKey = this.keysSnapshot[this.cursor++]) == null) continue;
                return;
            }
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public K next() {
            if (this.expectedSize != ArrayHashMap.this.size) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            Object result = this.nextKey;
            this.seekNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

