/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorPool<OBJECT_TYPE, ITERATOR_TYPE extends AbstractIterator<OBJECT_TYPE>>
extends ObjectPool<ITERATOR_TYPE> {
    public static final int MAX_SIZE_GROWTH_FACTOR = 4;
    public static final String POOL_INITIAL_SIZE_PROPERTY = "HPPC_ITERATOR_POOLSIZE";
    private static int INITIAL_SIZE;
    private static int LINEAR_GROWTH_SIZE;
    private static int MAX_SIZE;
    private static int DISCARDING_SIZE;

    public IteratorPool(ObjectFactory<ITERATOR_TYPE> objFactory) {
        super(objFactory, INITIAL_SIZE, new ArraySizingStrategy(){

            public int grow(int currentBufferLength, int elementsCount, int expectedAdditions) {
                int newSize = Math.max(elementsCount, currentBufferLength) + LINEAR_GROWTH_SIZE + expectedAdditions;
                if (newSize > MAX_SIZE) {
                    newSize = -1 * DISCARDING_SIZE;
                }
                return newSize;
            }
        });
    }

    @Override
    public ITERATOR_TYPE borrow() {
        AbstractIterator newObject = (AbstractIterator)super.borrow();
        newObject.setPool(this);
        newObject.resetState();
        newObject.setBorrowed();
        return (ITERATOR_TYPE)newObject;
    }

    public static final void configureInitialPoolSize(int initialSize) {
        LINEAR_GROWTH_SIZE = INITIAL_SIZE = initialSize;
        DISCARDING_SIZE = INITIAL_SIZE;
        MAX_SIZE = 4 * LINEAR_GROWTH_SIZE;
    }

    public static final int getMaxPoolSize() {
        return MAX_SIZE;
    }

    static {
        try {
            INITIAL_SIZE = Integer.parseInt(System.getProperty(POOL_INITIAL_SIZE_PROPERTY));
            if (INITIAL_SIZE < 1) {
                INITIAL_SIZE = 1;
            }
        }
        catch (Exception e) {
            INITIAL_SIZE = Containers.NB_OF_PROCESSORS;
        }
        LINEAR_GROWTH_SIZE = INITIAL_SIZE;
        MAX_SIZE = 4 * LINEAR_GROWTH_SIZE;
        DISCARDING_SIZE = LINEAR_GROWTH_SIZE;
    }
}

