/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;
import org.eclipse.rdf4j.common.lang.ObjectUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;

public class LexicalValueComparator
implements Serializable,
Comparator<Value> {
    private static final long serialVersionUID = -7055973992568220217L;

    @Override
    public int compare(Value o1, Value o2) {
        if (ObjectUtil.nullEquals((Object)o1, (Object)o2)) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean b1 = o1 instanceof BNode;
        boolean b2 = o2 instanceof BNode;
        if (b1 && b2) {
            return this.compareBNodes((BNode)o1, (BNode)o2);
        }
        if (b1) {
            return -1;
        }
        if (b2) {
            return 1;
        }
        boolean u1 = o1 instanceof IRI;
        boolean u2 = o2 instanceof IRI;
        if (u1 && u2) {
            return this.compareURIs((IRI)o1, (IRI)o2);
        }
        if (u1) {
            return -1;
        }
        if (u2) {
            return 1;
        }
        return this.compareLiterals((Literal)o1, (Literal)o2);
    }

    private int compareBNodes(BNode leftBNode, BNode rightBNode) {
        return leftBNode.getID().compareTo(rightBNode.getID());
    }

    private int compareURIs(IRI leftURI, IRI rightURI) {
        return leftURI.toString().compareTo(rightURI.toString());
    }

    private int compareLiterals(Literal leftLit, Literal rightLit) {
        int result = 0;
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null) {
            result = rightDatatype != null ? this.compareDatatypes(leftDatatype, rightDatatype) : 1;
        } else if (rightDatatype != null) {
            result = -1;
        }
        if (result == 0) {
            Optional<String> leftLanguage = leftLit.getLanguage();
            Optional<String> rightLanguage = rightLit.getLanguage();
            if (leftLanguage.isPresent()) {
                result = rightLanguage.isPresent() ? leftLanguage.get().compareTo(rightLanguage.get()) : 1;
            } else if (rightLanguage.isPresent()) {
                result = -1;
            }
        }
        if (result == 0) {
            result = leftLit.getLabel().compareTo(rightLit.getLabel());
        }
        return result;
    }

    private int compareDatatypes(IRI leftDatatype, IRI rightDatatype) {
        if (XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            if (XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            return 1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(leftDatatype)) {
            if (XMLDatatypeUtil.isCalendarDatatype(rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(rightDatatype)) {
            return 1;
        }
        return this.compareURIs(leftDatatype, rightDatatype);
    }
}

