/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DirectIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObject;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.collections.chains.Chain;

public class DifferentialIndex
extends DirectIndex {
    private static final Logger LOGGER_ = Logger.getLogger(DifferentialIndex.class);
    boolean incrementalMode = false;
    private Set<ElkClass> addedClasses_;
    private Set<ElkNamedIndividual> addedIndividuals_;
    private IndexedObjectCache todoDeletions_;
    private ChainableRule<Context> addedContextInitRules_;
    private ChainableRule<Context> removedContextInitRules_;
    private Map<IndexedClassExpression, ChainableRule<Context>> addedContextRuleHeadByClassExpressions_;
    private Map<IndexedClassExpression, ChainableRule<Context>> removedContextRuleHeadByClassExpressions_;

    public DifferentialIndex(IndexedObjectCache objectCache) {
        super(objectCache);
        this.init();
    }

    private void init() {
        this.initClassSignatureChanges();
        this.initIndividualSignatureChanges();
        this.initAdditions();
        this.initDeletions();
    }

    public void initClassSignatureChanges() {
        this.addedClasses_ = new ArrayHashSet(32);
    }

    public void initIndividualSignatureChanges() {
        this.addedIndividuals_ = new ArrayHashSet(32);
    }

    public void initAdditions() {
        this.addedContextInitRules_ = null;
        this.addedContextRuleHeadByClassExpressions_ = new ArrayHashMap(32);
    }

    public void initDeletions() {
        this.removedContextInitRules_ = null;
        this.todoDeletions_ = new IndexedObjectCache();
        this.removedContextRuleHeadByClassExpressions_ = new ArrayHashMap(32);
    }

    @Override
    public void addClass(ElkClass newClass) {
        if (this.incrementalMode) {
            this.addedClasses_.add(newClass);
        } else {
            super.addClass(newClass);
        }
    }

    @Override
    public void removeClass(ElkClass oldClass) {
        if (this.incrementalMode) {
            this.addedClasses_.remove(oldClass);
        } else {
            super.removeClass(oldClass);
        }
    }

    @Override
    public void addNamedIndividual(ElkNamedIndividual newIndividual) {
        if (this.incrementalMode) {
            this.addedIndividuals_.add(newIndividual);
        } else {
            super.addNamedIndividual(newIndividual);
        }
    }

    @Override
    public void removeNamedIndividual(ElkNamedIndividual oldIndividual) {
        if (this.incrementalMode) {
            this.addedIndividuals_.remove(oldIndividual);
        } else {
            super.removeNamedIndividual(oldIndividual);
        }
    }

    @Override
    public void add(IndexedClassExpression target, ChainableRule<Context> newRule) {
        if (this.incrementalMode) {
            if (newRule.removeFrom(this.getRemovedContextRuleChain(target))) {
                newRule.addTo(target.getCompositionRuleChain());
            } else {
                newRule.addTo(this.getAddedContextRuleChain(target));
            }
        } else {
            super.add(target, newRule);
        }
    }

    @Override
    public void remove(IndexedClassExpression target, ChainableRule<Context> oldRule) {
        if (this.incrementalMode) {
            if (!oldRule.removeFrom(this.getAddedContextRuleChain(target))) {
                oldRule.addTo(this.getRemovedContextRuleChain(target));
                if (!oldRule.removeFrom(target.getCompositionRuleChain())) {
                    throw new ElkUnexpectedIndexingException("Cannot remove context rule " + oldRule.getName() + " for " + target);
                }
            }
        } else {
            super.remove(target, oldRule);
        }
    }

    @Override
    public void addContextInitRule(ChainableRule<Context> newRule) {
        if (this.incrementalMode) {
            if (newRule.removeFrom(this.getRemovedContextInitRuleChain())) {
                newRule.addTo(this.getContextInitRuleChain());
            } else {
                newRule.addTo(this.getAddedContextInitRuleChain());
            }
        } else {
            super.addContextInitRule(newRule);
        }
    }

    @Override
    public void removeContextInitRule(ChainableRule<Context> oldRule) {
        if (this.incrementalMode) {
            if (!oldRule.removeFrom(this.getAddedContextInitRuleChain())) {
                oldRule.addTo(this.getRemovedContextInitRuleChain());
                if (!oldRule.removeFrom(this.getContextInitRuleChain())) {
                    throw new ElkUnexpectedIndexingException("Cannot remove context initialization rule " + oldRule.getName());
                }
            }
        } else {
            super.removeContextInitRule(oldRule);
        }
    }

    @Override
    public void add(IndexedObject newObject) {
        if (this.incrementalMode) {
            this.addIndexedObject(newObject);
        } else {
            super.add(newObject);
        }
    }

    @Override
    public void remove(IndexedObject oldObject) {
        if (this.incrementalMode) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("To remove: " + oldObject));
            }
            oldObject.accept(this.todoDeletions_.inserter);
        } else {
            super.remove(oldObject);
        }
    }

    public ChainableRule<Context> getAddedContextInitRules() {
        return this.addedContextInitRules_;
    }

    public ChainableRule<Context> getRemovedContextInitRules() {
        return this.removedContextInitRules_;
    }

    public Map<IndexedClassExpression, ChainableRule<Context>> getAddedContextRulesByClassExpressions() {
        return this.addedContextRuleHeadByClassExpressions_;
    }

    public Map<IndexedClassExpression, ChainableRule<Context>> getRemovedContextRulesByClassExpressions() {
        return this.removedContextRuleHeadByClassExpressions_;
    }

    public Collection<ElkClass> getAddedClasses() {
        return this.addedClasses_;
    }

    public Collection<ElkNamedIndividual> getAddedIndividuals() {
        return this.addedIndividuals_;
    }

    public Collection<IndexedClassExpression> getRemovedClassExpressions() {
        return this.todoDeletions_.indexedClassExpressionLookup;
    }

    public void clearDeletedRules() {
        this.objectCache.subtract(this.todoDeletions_);
        this.initDeletions();
    }

    public void commitAddedRules() {
        ChainableRule nextRule;
        Chain<ChainableRule<Context>> chain = this.getContextInitRuleChain();
        for (nextRule = this.addedContextInitRules_; nextRule != null; nextRule = (ChainableRule)nextRule.next()) {
            nextRule.addTo(chain);
        }
        for (IndexedClassExpression target : this.addedContextRuleHeadByClassExpressions_.keySet()) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Committing context rule additions for " + target));
            }
            chain = target.getCompositionRuleChain();
            for (nextRule = this.addedContextRuleHeadByClassExpressions_.get(target); nextRule != null; nextRule = (ChainableRule)nextRule.next()) {
                nextRule.addTo(chain);
            }
        }
        this.initAdditions();
    }

    public boolean isEmpty() {
        return !(this.addedContextInitRules_ != null || this.removedContextInitRules_ != null || this.addedContextRuleHeadByClassExpressions_ != null && !this.addedContextRuleHeadByClassExpressions_.isEmpty() || this.removedContextRuleHeadByClassExpressions_ != null && !this.removedContextRuleHeadByClassExpressions_.isEmpty());
    }

    public void setIncrementalMode(boolean mode) {
        if (this.incrementalMode == mode) {
            return;
        }
        this.incrementalMode = mode;
        if (!mode) {
            this.clearDeletedRules();
            this.commitAddedRules();
            this.initClassSignatureChanges();
            this.initIndividualSignatureChanges();
        }
    }

    public boolean isIncrementalMode() {
        return this.incrementalMode;
    }

    private Chain<ChainableRule<Context>> getAddedContextInitRuleChain() {
        return new AbstractChain<ChainableRule<Context>>(){

            public ChainableRule<Context> next() {
                return DifferentialIndex.this.addedContextInitRules_;
            }

            public void setNext(ChainableRule<Context> tail) {
                DifferentialIndex.this.addedContextInitRules_ = tail;
            }
        };
    }

    private Chain<ChainableRule<Context>> getRemovedContextInitRuleChain() {
        return new AbstractChain<ChainableRule<Context>>(){

            public ChainableRule<Context> next() {
                return DifferentialIndex.this.removedContextInitRules_;
            }

            public void setNext(ChainableRule<Context> tail) {
                DifferentialIndex.this.removedContextInitRules_ = tail;
            }
        };
    }

    private Chain<ChainableRule<Context>> getAddedContextRuleChain(IndexedClassExpression target) {
        return AbstractChain.getMapBackedChain(this.addedContextRuleHeadByClassExpressions_, (Object)target);
    }

    private Chain<ChainableRule<Context>> getRemovedContextRuleChain(IndexedClassExpression target) {
        return AbstractChain.getMapBackedChain(this.removedContextRuleHeadByClassExpressions_, (Object)target);
    }

    void addIndexedObject(IndexedObject iobj) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Adding: " + iobj));
        }
        if (!iobj.accept(this.todoDeletions_.deletor).booleanValue()) {
            iobj.accept(this.objectCache.inserter);
        }
    }
}

