/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.reasoner.consistency.ConsistencyChecking;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.util.concurrent.computation.Interrupter;

class ConsistencyCheckingStage
extends AbstractReasonerStage {
    protected ConsistencyChecking computation_ = null;

    public ConsistencyCheckingStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Consistency Checking";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.computation_ = new ConsistencyChecking(this.reasoner.getProcessExecutor(), this.workerNo, this.reasoner.getProgressMonitor(), this.reasoner.ontologyIndex, this.reasoner.saturationState);
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.inconsistentOntology = this.computation_.isInconsistent();
        this.reasoner.ruleAndConclusionStats.add(this.computation_.getRuleAndConclusionStatistics());
        if (this.reasoner.inconsistentOntology) {
            this.reasoner.classTaxonomyState.getWriter().clearTaxonomy();
            this.reasoner.instanceTaxonomyState.getWriter().clearTaxonomy();
        }
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }

    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.setInterrupt((Interrupter)this.computation_, flag);
    }
}

