import shutil

def get_terminal_width():
    """Gets the terminal width, ensuring a max width of 80 for readability."""
    width = shutil.get_terminal_size().columns - 10  # Adjust width based on terminal size
    return min(width, 80)  # Limit max width to 80 characters for consistency

def print_right_aligned_header(text):
    """Prints the main header shifted more to the right."""
    width = get_terminal_width()
    padding = " " * (width // 4)  # Adjust right shift
    print(f"{padding}{text}\n")

def print_boxed(text, header):
    """Prints text inside a properly aligned bordered box with a centered header."""
    width = get_terminal_width()
    border = "+" + "-" * (width - 2) + "+"

    print(border)
    print(f"{header.center(width - 2)}")  # Centering the header inside the box
    print(border)

    for line in text.split("\n"):
        print(f"{line.ljust(width - 2)}")  # Left-align content
    print(border + "\n")  # Bottom border

def main():
    """Main function to display the portfolio in a properly formatted style."""
    terminal_width = get_terminal_width()
    
    # Print main title shifted to the right
    print_right_aligned_header("🚀 Alvin Albert Michael's Portfolio 🚀")

    portfolio_text = """👨‍💻 Name: Alvin Albert Michael
📍 Location: Chennai, India
📧 Email: michaelalvinalbert@gmail.com
🔗 LinkedIn: https://www.linkedin.com/in/alvin-albert-michael
🐍 GitHub: https://github.com/alvin-dotcom
    """
    skills_text = """- JavaScript, C++, Python, SQL, HTML, CSS
- ReactJS, NextJS, MySQL, NodeJS, ExpressJS, MongoDB, PostgreSQL
- UI/UX, TailwindCSS, Responsive Web Design
- Data Structures and Algorithms (DSA), Object-Oriented Programming (OOPs)
    """
    projects_text = """1️⃣ GEMX - AI-powered text, voice & video chat app
   🔗 https://gem-x.vercel.app/
2️⃣ SaaS Landing Page - Next.js-based high-performance landing page
   🔗 https://rise-academy.onrender.com/
3️⃣ Resume Builder - Create and download professional resumes
   🔗 https://resumebuldr.vercel.app/
4️⃣ NEO - AI Virtual Assistant with voice control and hand gestures
   🔗 https://github.com/alvin-dotcom/Neo-AI-Assistant
    """
    experience_text = """🎯 AI Trainer, Outlier AI
- Improved model accuracy by 15% through advanced data preprocessing.
- Managed 100,000+ dataset points for AI model training.
- Enhanced model fairness by 18% through continuous monitoring.
📅 December 2024 - Present
    """
    achievements_text = """🥇 1st Prize, Epoch - Employee Prediction System
🥈 2nd Prize, Inter College Project Day - AI Virtual Assistant (NEO)
🥈 2nd Prize, Abinito 3.0 - OpenAI GPT-powered chatbot
    """

    print_boxed(portfolio_text.strip(), "📜 About Me")
    print_boxed(skills_text.strip(), "🛠️ Skills")
    print_boxed(projects_text.strip(), "📌 Projects")
    print_boxed(experience_text.strip(), "💼 Experience")
    print_boxed(achievements_text.strip(), "🏆 Achievements")

if __name__ == "__main__":
    main()
