"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkCloudWatchAlarmChatBot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CdkCloudWatchAlarmChatBot extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.topic = new aws_cdk_lib_1.aws_sns.Topic(this, 'Topic', {
            displayName: props.topicName,
        });
        new aws_cdk_lib_1.aws_chatbot.SlackChannelConfiguration(this, 'MySlackChannel', {
            slackChannelConfigurationName: 'cw-alarm-slack',
            slackWorkspaceId: props.slackWorkSpaceId,
            slackChannelId: props.slackChannelId,
            notificationTopics: [this.topic],
        });
    }
}
exports.CdkCloudWatchAlarmChatBot = CdkCloudWatchAlarmChatBot;
_a = JSII_RTTI_SYMBOL_1;
CdkCloudWatchAlarmChatBot[_a] = { fqn: "cdk-cloudwatch-alarm-chatbot.CdkCloudWatchAlarmChatBot", version: "1.0.30" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBcUU7QUFDckUsMkNBQXVDO0FBT3ZDLE1BQWEseUJBQTBCLFNBQVEsc0JBQVM7SUFFdEQsWUFDRSxLQUFnQixFQUNoQixFQUFVLEVBQ1YsS0FBcUM7UUFFckMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUkscUJBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLE9BQU8sRUFBRTtZQUN4QyxXQUFXLEVBQUUsS0FBSyxDQUFDLFNBQVM7U0FDN0IsQ0FBQyxDQUFDO1FBRUgsSUFBSSx5QkFBTyxDQUFDLHlCQUF5QixDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUM1RCw2QkFBNkIsRUFBRSxnQkFBZ0I7WUFDL0MsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsa0JBQWtCLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ2pDLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBbkJILDhEQW9CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGF3c19zbnMgYXMgc25zLCBhd3NfY2hhdGJvdCBhcyBjaGF0Ym90IH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ2RrQ2xvdWRXYXRjaEFsYXJtQ2hhdEJvdFByb3BzIHtcbiAgcmVhZG9ubHkgdG9waWNOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNsYWNrV29ya1NwYWNlSWQ6IHN0cmluZztcbiAgcmVhZG9ubHkgc2xhY2tDaGFubmVsSWQ6IHN0cmluZztcbn1cbmV4cG9ydCBjbGFzcyBDZGtDbG91ZFdhdGNoQWxhcm1DaGF0Qm90IGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljO1xuICBjb25zdHJ1Y3RvcihcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgcHJvcHM6IENka0Nsb3VkV2F0Y2hBbGFybUNoYXRCb3RQcm9wcyxcbiAgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMudG9waWMgPSBuZXcgc25zLlRvcGljKHRoaXMsICdUb3BpYycsIHtcbiAgICAgIGRpc3BsYXlOYW1lOiBwcm9wcy50b3BpY05hbWUsXG4gICAgfSk7XG5cbiAgICBuZXcgY2hhdGJvdC5TbGFja0NoYW5uZWxDb25maWd1cmF0aW9uKHRoaXMsICdNeVNsYWNrQ2hhbm5lbCcsIHtcbiAgICAgIHNsYWNrQ2hhbm5lbENvbmZpZ3VyYXRpb25OYW1lOiAnY3ctYWxhcm0tc2xhY2snLFxuICAgICAgc2xhY2tXb3Jrc3BhY2VJZDogcHJvcHMuc2xhY2tXb3JrU3BhY2VJZCxcbiAgICAgIHNsYWNrQ2hhbm5lbElkOiBwcm9wcy5zbGFja0NoYW5uZWxJZCxcbiAgICAgIG5vdGlmaWNhdGlvblRvcGljczogW3RoaXMudG9waWNdLFxuICAgIH0pO1xuICB9XG59XG4iXX0=