import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAdGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The group's identifier. It can be the group's GUID, SID, Distinguished Name, or SAM Account Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/group#group_id DataAdGroup#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/group#id DataAdGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/d/group ad_group}
*/
export declare class DataAdGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ad_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/d/group ad_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAdGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAdGroupConfig);
    get category(): string;
    get container(): string;
    get description(): string;
    get displayName(): string;
    get dn(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get samAccountName(): string;
    get scope(): string;
    get sid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
