import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAdUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/user#id DataAdUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The user's identifier. It can be the group's GUID, SID, Distinguished Name, or SAM Account Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/user#user_id DataAdUser#user_id}
    */
    readonly userId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/d/user ad_user}
*/
export declare class DataAdUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ad_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/d/user ad_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAdUserConfig
    */
    constructor(scope: Construct, id: string, config: DataAdUserConfig);
    get city(): string;
    get company(): string;
    get country(): string;
    get department(): string;
    get description(): string;
    get displayName(): string;
    get division(): string;
    get dn(): string;
    get emailAddress(): string;
    get employeeId(): string;
    get employeeNumber(): string;
    get fax(): string;
    get givenName(): string;
    get homeDirectory(): string;
    get homeDrive(): string;
    get homePage(): string;
    get homePhone(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get initials(): string;
    get mobilePhone(): string;
    get office(): string;
    get officePhone(): string;
    get organization(): string;
    get otherName(): string;
    get poBox(): string;
    get postalCode(): string;
    get principalName(): string;
    get samAccountName(): string;
    get sid(): string;
    get smartCardLogonRequired(): cdktf.IResolvable;
    get state(): string;
    get streetAddress(): string;
    get surname(): string;
    get title(): string;
    get trustedForDelegation(): cdktf.IResolvable;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
