import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OuConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the OU.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/ou#description Ou#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/ou#id Ou#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the OU.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/ou#name Ou#name}
    */
    readonly name: string;
    /**
    * DN of the object that contains the OU.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/ou#path Ou#path}
    */
    readonly path?: string;
    /**
    * Protect this OU from being deleted accidentaly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/ou#protected Ou#protected}
    */
    readonly protected?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/ou ad_ou}
*/
export declare class Ou extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_ou";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/ou ad_ou} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OuConfig
    */
    constructor(scope: Construct, id: string, config: OuConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get dn(): string;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _protected?;
    get protected(): boolean | cdktf.IResolvable;
    set protected(value: boolean | cdktf.IResolvable);
    resetProtected(): void;
    get protectedInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
