"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad ad}
*/
class AdProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad ad} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'ad',
            terraformGeneratorMetadata: {
                providerName: 'ad',
                providerVersion: '0.4.4',
                providerVersionConstraint: '~> 0.4'
            },
            terraformProviderSource: 'ad'
        });
        this._domainController = config.domainController;
        this._krbConf = config.krbConf;
        this._krbKeytab = config.krbKeytab;
        this._krbRealm = config.krbRealm;
        this._krbSpn = config.krbSpn;
        this._winrmHostname = config.winrmHostname;
        this._winrmInsecure = config.winrmInsecure;
        this._winrmPassCredentials = config.winrmPassCredentials;
        this._winrmPassword = config.winrmPassword;
        this._winrmPort = config.winrmPort;
        this._winrmProto = config.winrmProto;
        this._winrmUseNtlm = config.winrmUseNtlm;
        this._winrmUsername = config.winrmUsername;
        this._alias = config.alias;
    }
    get domainController() {
        return this._domainController;
    }
    set domainController(value) {
        this._domainController = value;
    }
    resetDomainController() {
        this._domainController = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get domainControllerInput() {
        return this._domainController;
    }
    get krbConf() {
        return this._krbConf;
    }
    set krbConf(value) {
        this._krbConf = value;
    }
    resetKrbConf() {
        this._krbConf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get krbConfInput() {
        return this._krbConf;
    }
    get krbKeytab() {
        return this._krbKeytab;
    }
    set krbKeytab(value) {
        this._krbKeytab = value;
    }
    resetKrbKeytab() {
        this._krbKeytab = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get krbKeytabInput() {
        return this._krbKeytab;
    }
    get krbRealm() {
        return this._krbRealm;
    }
    set krbRealm(value) {
        this._krbRealm = value;
    }
    resetKrbRealm() {
        this._krbRealm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get krbRealmInput() {
        return this._krbRealm;
    }
    get krbSpn() {
        return this._krbSpn;
    }
    set krbSpn(value) {
        this._krbSpn = value;
    }
    resetKrbSpn() {
        this._krbSpn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get krbSpnInput() {
        return this._krbSpn;
    }
    get winrmHostname() {
        return this._winrmHostname;
    }
    set winrmHostname(value) {
        this._winrmHostname = value;
    }
    // Temporarily expose input value. Use with caution.
    get winrmHostnameInput() {
        return this._winrmHostname;
    }
    get winrmInsecure() {
        return this._winrmInsecure;
    }
    set winrmInsecure(value) {
        this._winrmInsecure = value;
    }
    resetWinrmInsecure() {
        this._winrmInsecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get winrmInsecureInput() {
        return this._winrmInsecure;
    }
    get winrmPassCredentials() {
        return this._winrmPassCredentials;
    }
    set winrmPassCredentials(value) {
        this._winrmPassCredentials = value;
    }
    resetWinrmPassCredentials() {
        this._winrmPassCredentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get winrmPassCredentialsInput() {
        return this._winrmPassCredentials;
    }
    get winrmPassword() {
        return this._winrmPassword;
    }
    set winrmPassword(value) {
        this._winrmPassword = value;
    }
    // Temporarily expose input value. Use with caution.
    get winrmPasswordInput() {
        return this._winrmPassword;
    }
    get winrmPort() {
        return this._winrmPort;
    }
    set winrmPort(value) {
        this._winrmPort = value;
    }
    resetWinrmPort() {
        this._winrmPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get winrmPortInput() {
        return this._winrmPort;
    }
    get winrmProto() {
        return this._winrmProto;
    }
    set winrmProto(value) {
        this._winrmProto = value;
    }
    resetWinrmProto() {
        this._winrmProto = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get winrmProtoInput() {
        return this._winrmProto;
    }
    get winrmUseNtlm() {
        return this._winrmUseNtlm;
    }
    set winrmUseNtlm(value) {
        this._winrmUseNtlm = value;
    }
    resetWinrmUseNtlm() {
        this._winrmUseNtlm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get winrmUseNtlmInput() {
        return this._winrmUseNtlm;
    }
    get winrmUsername() {
        return this._winrmUsername;
    }
    set winrmUsername(value) {
        this._winrmUsername = value;
    }
    // Temporarily expose input value. Use with caution.
    get winrmUsernameInput() {
        return this._winrmUsername;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            domain_controller: cdktf.stringToTerraform(this._domainController),
            krb_conf: cdktf.stringToTerraform(this._krbConf),
            krb_keytab: cdktf.stringToTerraform(this._krbKeytab),
            krb_realm: cdktf.stringToTerraform(this._krbRealm),
            krb_spn: cdktf.stringToTerraform(this._krbSpn),
            winrm_hostname: cdktf.stringToTerraform(this._winrmHostname),
            winrm_insecure: cdktf.booleanToTerraform(this._winrmInsecure),
            winrm_pass_credentials: cdktf.booleanToTerraform(this._winrmPassCredentials),
            winrm_password: cdktf.stringToTerraform(this._winrmPassword),
            winrm_port: cdktf.numberToTerraform(this._winrmPort),
            winrm_proto: cdktf.stringToTerraform(this._winrmProto),
            winrm_use_ntlm: cdktf.booleanToTerraform(this._winrmUseNtlm),
            winrm_username: cdktf.stringToTerraform(this._winrmUsername),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.AdProvider = AdProvider;
_a = JSII_RTTI_SYMBOL_1;
AdProvider[_a] = { fqn: "@cdktf/provider-ad.provider.AdProvider", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
AdProvider.tfResourceType = "ad";
//# sourceMappingURL=data:application/json;base64,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