/*
 * Decompiled with CFR 0.152.
 */
package com.cmayes.common.util;

import com.cmayes.common.exception.ExceptionUtils;
import com.cmayes.common.util.TypeUtils;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BeanMap<T>
extends AbstractMap<String, Object> {
    private final T bean;
    private final Map<String, PropertyDescriptor> descriptors;
    private boolean isStrict;

    public BeanMap(T wrappedBean) {
        this(wrappedBean, false);
    }

    public BeanMap(T wrappedBean, boolean strict) {
        this.isStrict = strict;
        this.bean = ExceptionUtils.asNotNull(wrappedBean, "Missing bean", new Object[0]);
        HashMap<String, PropertyDescriptor> localDescriptors = new HashMap<String, PropertyDescriptor>();
        try {
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(wrappedBean.getClass()).getPropertyDescriptors()) {
                if (descriptor instanceof IndexedPropertyDescriptor) continue;
                if (this.isStrict) {
                    localDescriptors.put(descriptor.getName(), descriptor);
                    continue;
                }
                localDescriptors.put(descriptor.getName().toLowerCase(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Problems introspecting the given bean: ", e);
        }
        this.descriptors = Collections.unmodifiableMap(localDescriptors);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new BeanSet();
    }

    @Override
    public Object get(Object key) {
        return super.get(this.checkKey(key));
    }

    public Class<?> getType(String key) {
        return this.descriptors.get(this.checkKey(key)).getPropertyType();
    }

    @Override
    public Object put(String key, Object value) {
        this.checkKey(key);
        return new BeanEntry(this.descriptors.get(this.checkKey(key))).setValue(value);
    }

    @Override
    public Object remove(Object key) {
        return super.remove(this.checkKey(key));
    }

    private String checkKey(Object key) {
        String name = this.isStrict ? ExceptionUtils.asNotNull(key, "Missing key", new Object[0]).toString() : ExceptionUtils.asNotNull(key, "Missing key", new Object[0]).toString().toLowerCase();
        if (!this.containsKey(ExceptionUtils.asNotNull(name, "Missing key", new Object[0]))) {
            throw new IllegalArgumentException("Bad key: " + key);
        }
        return name;
    }

    protected Object[] createWriteMethodArguments(Method method, Object value) throws IllegalAccessException {
        try {
            Class<?> paramType;
            Class<?>[] types;
            Object localValue = value;
            if (localValue != null && (types = method.getParameterTypes()) != null && types.length > 0 && !(paramType = types[0]).isAssignableFrom(localValue.getClass())) {
                localValue = TypeUtils.convertType(paramType, localValue);
            }
            Object[] answer = new Object[]{localValue};
            return answer;
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static Object unwrap(Wrapped wrapped) {
        try {
            return wrapped.run();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    public T getBean() {
        return this.bean;
    }

    public boolean isReadOnlyProperty(String propName) {
        PropertyDescriptor propDesc = ExceptionUtils.asNotNull(this.descriptors.get(this.checkKey(propName)), "No field found with name " + propName, new Object[0]);
        return propDesc.getWriteMethod() == null;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isStrict) {
            return super.containsKey(key);
        }
        if (key == null) {
            return false;
        }
        return this.descriptors.containsKey(key.toString().toLowerCase());
    }

    static interface Transformer {
        public Object transform(Object var1);
    }

    private static interface Wrapped {
        public Object run() throws IllegalAccessException, InvocationTargetException;
    }

    private class BeanEntry
    implements Map.Entry<String, Object> {
        private final PropertyDescriptor descriptor;

        public BeanEntry(PropertyDescriptor wrappedDesc) {
            this.descriptor = wrappedDesc;
        }

        @Override
        public String getKey() {
            return this.descriptor.getName();
        }

        @Override
        public Object getValue() {
            return BeanMap.unwrap(new Wrapped(){

                @Override
                public Object run() throws IllegalAccessException, InvocationTargetException {
                    Method method = BeanEntry.this.descriptor.getReadMethod();
                    if (null == method) {
                        throw new UnsupportedOperationException("No getter: " + BeanEntry.this.descriptor.getName());
                    }
                    return method.invoke(BeanMap.this.bean, new Object[0]);
                }
            });
        }

        @Override
        public Object setValue(final Object value) {
            return BeanMap.unwrap(new Wrapped(){

                @Override
                public Object run() throws IllegalAccessException, InvocationTargetException {
                    Method method = BeanEntry.this.descriptor.getWriteMethod();
                    if (null == method) {
                        throw new UnsupportedOperationException("No setter: " + BeanEntry.this.descriptor.getName());
                    }
                    Object old = BeanEntry.this.getValue();
                    if (BeanMap.this.isStrict) {
                        method.invoke(BeanMap.this.bean, value);
                    } else {
                        Object[] arguments = BeanMap.this.createWriteMethodArguments(method, value);
                        method.invoke(BeanMap.this.bean, arguments);
                    }
                    return old;
                }
            });
        }
    }

    private class BeanIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<PropertyDescriptor> it;

        public BeanIterator(Iterator<PropertyDescriptor> wrappedIt) {
            this.it = wrappedIt;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            return new BeanEntry(this.it.next());
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private class BeanSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private BeanSet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new BeanIterator(BeanMap.this.descriptors.values().iterator());
        }

        @Override
        public int size() {
            return BeanMap.this.descriptors.size();
        }
    }
}

