/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import com.cmayes.common.chem.AtomicElement;
import com.cmayes.common.exception.NotFoundException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.util.ChemUtils;
import java.util.ArrayList;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.def.CpCalculationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomericDihedralAngleCalculation
implements Calculation {
    private static final int O5_LOC = 0;
    private static final int C1_LOC = 1;
    private static final int C2_LOC = 2;
    private static final int C3_LOC = 3;
    private static final int C5_LOC = 5;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object calculate(Object rawInput) {
        if (rawInput instanceof CpCalculationSnapshot) {
            CpCalculationSnapshot cpSnap = new CpCalculationSnapshot((CpCalculationSnapshot)rawInput);
            if (cpSnap.getGlucoseRing() == null) {
                this.logger.warn("No glucose ring for third arm calc {}, skipping.", (Object)cpSnap.getSourceName());
                return cpSnap;
            }
            try {
                this.fillThirdDihedralAngles(cpSnap);
            }
            catch (NotFoundException e) {
                this.logger.warn("Missing atoms for third arm calc {}, skipping.", (Object)cpSnap.getSourceName(), (Object)e);
            }
            return cpSnap;
        }
        throw new IllegalArgumentException(String.format("Unhandled class '%s'", rawInput.getClass()));
    }

    private void fillThirdDihedralAngles(CpCalculationSnapshot cpSnap) {
        List<Atom> glucoseRing = cpSnap.getGlucoseRing();
        ArrayList<Atom> otherAtoms = new ArrayList<Atom>(cpSnap.getAtoms());
        otherAtoms.removeAll(glucoseRing);
        Atom oxy1 = ChemUtils.findSingleBondAtom(glucoseRing.get(1), otherAtoms, AtomicElement.OXYGEN);
        cpSnap.setAnoAngle1(ChemUtils.calcDihedralAngle(glucoseRing.get(5), glucoseRing.get(0), glucoseRing.get(1), oxy1));
        cpSnap.setAnoAngle2(ChemUtils.calcDihedralAngle(glucoseRing.get(3), glucoseRing.get(2), glucoseRing.get(1), oxy1));
    }
}

