/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.loader.gaussian;

import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.model.Atom;
import com.cmayes.common.model.impl.DefaultAtom;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.cmayes.hartree.loader.Loader;
import org.cmayes.hartree.loader.ParseException;
import org.cmayes.hartree.loader.gaussian.BaseGaussianLoader;
import org.cmayes.hartree.model.LowestEnergyMapper;
import org.cmayes.hartree.parser.gaussian.antlr.SnapshotLexer;
import org.cmayes.hartree.parser.gaussian.antlr.SnapshotParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowestEnergyLoader
extends BaseGaussianLoader
implements Loader<LowestEnergyMapper> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public LowestEnergyMapper load(String srcName, Reader reader) {
        return this.extractSnapshotData(srcName, this.extractAst(srcName, reader));
    }

    private LowestEnergyMapper extractSnapshotData(String srcName, CommonTree ast) {
        LowestEnergyMapper result = new LowestEnergyMapper(srcName);
        int atomColCount = 0;
        DefaultAtom curAtom = new DefaultAtom();
        ArrayList<Atom> curAtomList = new ArrayList<Atom>();
        List<? extends Object> eventList = ast.getChildren();
        if (eventList == null) {
            this.logger.error("Parse failed: no AST children found for source " + srcName);
            return result;
        }
        block5: for (CommonTree commonTree : eventList) {
            switch (commonTree.getType()) {
                case -1: {
                    continue block5;
                }
                case 58: 
                case 59: {
                    this.handleAtom(commonTree.getText(), curAtom, atomColCount);
                    if (++atomColCount % 6 != 0) continue block5;
                    curAtomList.add(curAtom);
                    curAtom = new DefaultAtom();
                    continue block5;
                }
                case 24: {
                    result.add(this.toDouble(commonTree.getText()), curAtomList);
                    curAtomList = new ArrayList();
                    continue block5;
                }
            }
            this.logger.debug(String.format("Stuff not used in lowest energy fills %s %s", commonTree.getType(), commonTree.getText()));
        }
        return result;
    }

    protected CommonTree extractAst(String srcName, Reader reader) {
        try {
            SnapshotLexer lexer = new SnapshotLexer(new ANTLRReaderStream(reader));
            SnapshotParser parser = new SnapshotParser(new CommonTokenStream(lexer));
            return (CommonTree)parser.script().getTree();
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems reading from " + srcName, (Throwable)e, new Object[0]);
        }
        catch (RecognitionException e) {
            throw new ParseException("Problems parsing data from " + srcName, e);
        }
    }
}

