/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.model.def;

import com.cmayes.common.exception.ExceptionUtils;
import com.cmayes.common.model.Atom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cmayes.hartree.model.BaseResult;
import org.joda.time.Duration;

public class DefaultBaseResult
implements BaseResult {
    private Map<Integer, Atom> atomMap = new TreeMap<Integer, Atom>();
    private List<Date> terminationDates = new ArrayList<Date>();
    private List<Duration> cpuTimes = new ArrayList<Duration>();
    private Double transPart;
    private Double rotPart;
    private Integer mult;
    private Integer charge;
    private List<Double> frequencyValues = new ArrayList<Double>();
    private boolean isSymmetric = true;
    private String sourceName;
    private String functional;
    private String basisSet;
    private String solvent;
    private String stoichiometry;
    private Double zpeCorrection;
    private Double dipoleMomentTotal;
    private Double gibbs298;
    private Double enthalpy298;
    private Double elecEn;
    private Integer atomCount;
    private Double bsse;

    public DefaultBaseResult() {
    }

    public DefaultBaseResult(String srcName) {
        this.sourceName = srcName;
    }

    public DefaultBaseResult(BaseResult baseResult) {
        this.atomCount = baseResult.getAtomCount();
        this.atomMap = new TreeMap<Integer, Atom>(baseResult.getAtomMap());
        this.basisSet = baseResult.getBasisSet();
        this.charge = baseResult.getCharge();
        this.cpuTimes = baseResult.getCpuTimes();
        this.dipoleMomentTotal = baseResult.getDipoleMomentTotal();
        this.elecEn = baseResult.getElecEn();
        this.sourceName = baseResult.getSourceName();
        this.frequencyValues = baseResult.getFrequencyValues();
        this.functional = baseResult.getFunctional();
        this.gibbs298 = baseResult.getGibbs298();
        this.enthalpy298 = baseResult.getEnthalpy298();
        this.isSymmetric = baseResult.isSymmetricTop();
        this.mult = baseResult.getMult();
        this.rotPart = baseResult.getRotPart();
        this.solvent = baseResult.getSolvent();
        this.stoichiometry = baseResult.getStoichiometry();
        this.terminationDates = baseResult.getTerminationDates();
        this.transPart = baseResult.getTransPart();
        this.zpeCorrection = baseResult.getZpeCorrection();
    }

    @Override
    public Map<Integer, Atom> getAtomMap() {
        return this.atomMap;
    }

    @Override
    public void setAtomMap(Map<Integer, Atom> atoms) {
        this.atomMap = new TreeMap<Integer, Atom>(atoms);
    }

    @Override
    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(this.atomMap.values());
    }

    @Override
    public void addAtom(Atom addMe) {
        this.atomMap.put(ExceptionUtils.asNotNull(addMe, "Atom is null", new Object[0]).getId(), addMe);
    }

    @Override
    public String getSolvent() {
        return this.solvent;
    }

    @Override
    public void setSolvent(String solv) {
        this.solvent = solv;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(String fName) {
        this.sourceName = fName;
    }

    @Override
    public Atom getAtomById(int id) {
        Atom atom = this.atomMap.get(id);
        if (atom == null) {
            throw new IllegalArgumentException("No atom with ID " + id);
        }
        return atom;
    }

    @Override
    public Integer getMult() {
        return this.mult;
    }

    @Override
    public void setMult(Integer multVal) {
        this.mult = multVal;
    }

    @Override
    public Double getRotPart() {
        return this.rotPart;
    }

    @Override
    public void setRotPart(Double rotationalPart) {
        this.rotPart = rotationalPart;
    }

    @Override
    public Double getTransPart() {
        return this.transPart;
    }

    @Override
    public void setTransPart(Double translationalPart) {
        this.transPart = translationalPart;
    }

    @Override
    public List<Double> getFrequencyValues() {
        return this.frequencyValues;
    }

    @Override
    public void setFrequencyValues(List<Double> freqValues) {
        this.frequencyValues = freqValues;
    }

    @Override
    public List<Date> getTerminationDates() {
        return this.terminationDates;
    }

    @Override
    public void setTerminationDates(List<Date> termDates) {
        this.terminationDates = termDates;
    }

    @Override
    public List<Duration> getCpuTimes() {
        return this.cpuTimes;
    }

    @Override
    public void setCpuTimes(List<Duration> durations) {
        this.cpuTimes = durations;
    }

    @Override
    public boolean isSymmetricTop() {
        return this.isSymmetric;
    }

    @Override
    public void setSymmetricTop(boolean isSymTop) {
        this.isSymmetric = isSymTop;
    }

    @Override
    public String getFunctional() {
        return this.functional;
    }

    @Override
    public void setFunctional(String func) {
        this.functional = func;
    }

    @Override
    public String getBasisSet() {
        return this.basisSet;
    }

    @Override
    public void setBasisSet(String bSet) {
        this.basisSet = bSet;
    }

    @Override
    public Double getZpeCorrection() {
        return this.zpeCorrection;
    }

    @Override
    public void setZpeCorrection(Double zpeCorr) {
        this.zpeCorrection = zpeCorr;
    }

    @Override
    public Integer getCharge() {
        return this.charge;
    }

    @Override
    public void setCharge(Integer chg) {
        this.charge = chg;
    }

    @Override
    public String getStoichiometry() {
        return this.stoichiometry;
    }

    @Override
    public void setStoichiometry(String stoi) {
        this.stoichiometry = stoi;
    }

    @Override
    public Double getDipoleMomentTotal() {
        return this.dipoleMomentTotal;
    }

    @Override
    public void setDipoleMomentTotal(Double dmTotal) {
        this.dipoleMomentTotal = dmTotal;
    }

    @Override
    public Double getGibbs298() {
        return this.gibbs298;
    }

    @Override
    public void setGibbs298(Double g298) {
        this.gibbs298 = g298;
    }

    @Override
    public Double getElecEn() {
        return this.elecEn;
    }

    @Override
    public void setElecEn(Double energies) {
        this.elecEn = energies;
    }

    @Override
    public Integer getAtomCount() {
        return this.atomCount;
    }

    @Override
    public void setAtomCount(Integer count) {
        this.atomCount = count;
    }

    @Override
    public Double getEnthalpy298() {
        return this.enthalpy298;
    }

    @Override
    public void setEnthalpy298(Double enthalpy) {
        this.enthalpy298 = enthalpy;
    }

    @Override
    public Double getBsse() {
        return this.bsse;
    }

    @Override
    public void setBsse(Double bsse) {
        this.bsse = bsse;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultBaseResult)) {
            return false;
        }
        DefaultBaseResult rhs = (DefaultBaseResult)object;
        return new EqualsBuilder().append(this.basisSet, rhs.basisSet).append(this.mult, rhs.mult).append(this.atomCount, rhs.atomCount).append(this.cpuTimes, rhs.cpuTimes).append(this.frequencyValues, rhs.frequencyValues).append(this.isSymmetric, rhs.isSymmetric).append(this.solvent, rhs.solvent).append(this.functional, rhs.functional).append(this.elecEn, rhs.elecEn).append(this.transPart, rhs.transPart).append(this.gibbs298, rhs.gibbs298).append(this.enthalpy298, rhs.enthalpy298).append(this.atomMap, rhs.atomMap).append(this.charge, rhs.charge).append(this.rotPart, rhs.rotPart).append(this.zpeCorrection, rhs.zpeCorrection).append(this.dipoleMomentTotal, rhs.dipoleMomentTotal).append(this.sourceName, rhs.sourceName).append(this.terminationDates, rhs.terminationDates).append(this.stoichiometry, rhs.stoichiometry).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-2069282171, -1063907465).append(this.basisSet).append(this.mult).append(this.atomCount).append(this.cpuTimes).append(this.frequencyValues).append(this.isSymmetric).append(this.solvent).append(this.functional).append(this.elecEn).append(this.transPart).append(this.gibbs298).append(this.enthalpy298).append(this.atomMap).append(this.charge).append(this.rotPart).append(this.zpeCorrection).append(this.dipoleMomentTotal).append(this.sourceName).append(this.terminationDates).append(this.stoichiometry).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("elecEn", this.elecEn).append("functional", this.functional).append("charge", this.charge).append("atoms", this.getAtoms()).append("frequencyValues", this.frequencyValues).append("cpuTimes", this.cpuTimes).append("mult", this.mult).append("atomCount", this.atomCount).append("rotPart", this.rotPart).append("transPart", this.transPart).append("symmetricTop", this.isSymmetricTop()).append("gibbs298", this.gibbs298).append("enthalpy298", this.enthalpy298).append("zpeCorrection", this.zpeCorrection).append("stoichiometry", this.stoichiometry).append("basisSet", this.basisSet).append("fileName", this.sourceName).append("dipoleMomentTotal", this.dipoleMomentTotal).append("solvent", this.solvent).append("terminationDates", this.terminationDates).append("atomMap", this.atomMap).toString();
    }
}

