# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseReadReplicaArgs', 'DatabaseReadReplica']

@pulumi.input_type
class DatabaseReadReplicaArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 direct_access: Optional[pulumi.Input['DatabaseReadReplicaDirectAccessArgs']] = None,
                 private_network: Optional[pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseReadReplica resource.
        :param pulumi.Input[str] instance_id: Id of the rdb instance to replicate.
        :param pulumi.Input['DatabaseReadReplicaDirectAccessArgs'] direct_access: Creates a direct access endpoint to rdb replica.
        :param pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs'] private_network: Create an endpoint in a private network.
        :param pulumi.Input[str] region: `region`) The region in which the Database read replica should be created.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if direct_access is not None:
            pulumi.set(__self__, "direct_access", direct_access)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Id of the rdb instance to replicate.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="directAccess")
    def direct_access(self) -> Optional[pulumi.Input['DatabaseReadReplicaDirectAccessArgs']]:
        """
        Creates a direct access endpoint to rdb replica.
        """
        return pulumi.get(self, "direct_access")

    @direct_access.setter
    def direct_access(self, value: Optional[pulumi.Input['DatabaseReadReplicaDirectAccessArgs']]):
        pulumi.set(self, "direct_access", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs']]:
        """
        Create an endpoint in a private network.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the Database read replica should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DatabaseReadReplicaState:
    def __init__(__self__, *,
                 direct_access: Optional[pulumi.Input['DatabaseReadReplicaDirectAccessArgs']] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DatabaseReadReplica resources.
        :param pulumi.Input['DatabaseReadReplicaDirectAccessArgs'] direct_access: Creates a direct access endpoint to rdb replica.
        :param pulumi.Input[str] instance_id: Id of the rdb instance to replicate.
        :param pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs'] private_network: Create an endpoint in a private network.
        :param pulumi.Input[str] region: `region`) The region in which the Database read replica should be created.
        """
        if direct_access is not None:
            pulumi.set(__self__, "direct_access", direct_access)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="directAccess")
    def direct_access(self) -> Optional[pulumi.Input['DatabaseReadReplicaDirectAccessArgs']]:
        """
        Creates a direct access endpoint to rdb replica.
        """
        return pulumi.get(self, "direct_access")

    @direct_access.setter
    def direct_access(self, value: Optional[pulumi.Input['DatabaseReadReplicaDirectAccessArgs']]):
        pulumi.set(self, "direct_access", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the rdb instance to replicate.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs']]:
        """
        Create an endpoint in a private network.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['DatabaseReadReplicaPrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the Database read replica should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class DatabaseReadReplica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 direct_access: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaDirectAccessArgs']]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaPrivateNetworkArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Database read replicas.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/rdb/api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        instance = scaleway.DatabaseInstance("instance",
            node_type="db-dev-s",
            engine="PostgreSQL-14",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "terraform-test",
                "scaleway_rdb_read_replica",
                "minimal",
            ])
        replica = scaleway.DatabaseReadReplica("replica",
            instance_id=instance.id,
            direct_access=scaleway.DatabaseReadReplicaDirectAccessArgs())
        ```

        ### Private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        instance = scaleway.DatabaseInstance("instance",
            node_type="db-dev-s",
            engine="PostgreSQL-14",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        pn = scaleway.VpcPrivateNetwork("pn")
        replica = scaleway.DatabaseReadReplica("replica",
            instance_id=instance.id,
            private_network=scaleway.DatabaseReadReplicaPrivateNetworkArgs(
                private_network_id=pn.id,
                service_ip="192.168.1.254/24",
            ))
        ```

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/databaseReadReplica:DatabaseReadReplica rr fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseReadReplicaDirectAccessArgs']] direct_access: Creates a direct access endpoint to rdb replica.
        :param pulumi.Input[str] instance_id: Id of the rdb instance to replicate.
        :param pulumi.Input[pulumi.InputType['DatabaseReadReplicaPrivateNetworkArgs']] private_network: Create an endpoint in a private network.
        :param pulumi.Input[str] region: `region`) The region in which the Database read replica should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseReadReplicaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Database read replicas.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/rdb/api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        instance = scaleway.DatabaseInstance("instance",
            node_type="db-dev-s",
            engine="PostgreSQL-14",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "terraform-test",
                "scaleway_rdb_read_replica",
                "minimal",
            ])
        replica = scaleway.DatabaseReadReplica("replica",
            instance_id=instance.id,
            direct_access=scaleway.DatabaseReadReplicaDirectAccessArgs())
        ```

        ### Private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        instance = scaleway.DatabaseInstance("instance",
            node_type="db-dev-s",
            engine="PostgreSQL-14",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        pn = scaleway.VpcPrivateNetwork("pn")
        replica = scaleway.DatabaseReadReplica("replica",
            instance_id=instance.id,
            private_network=scaleway.DatabaseReadReplicaPrivateNetworkArgs(
                private_network_id=pn.id,
                service_ip="192.168.1.254/24",
            ))
        ```

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/databaseReadReplica:DatabaseReadReplica rr fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseReadReplicaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseReadReplicaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 direct_access: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaDirectAccessArgs']]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaPrivateNetworkArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseReadReplicaArgs.__new__(DatabaseReadReplicaArgs)

            __props__.__dict__["direct_access"] = direct_access
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["private_network"] = private_network
            __props__.__dict__["region"] = region
        super(DatabaseReadReplica, __self__).__init__(
            'scaleway:index/databaseReadReplica:DatabaseReadReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            direct_access: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaDirectAccessArgs']]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            private_network: Optional[pulumi.Input[pulumi.InputType['DatabaseReadReplicaPrivateNetworkArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'DatabaseReadReplica':
        """
        Get an existing DatabaseReadReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseReadReplicaDirectAccessArgs']] direct_access: Creates a direct access endpoint to rdb replica.
        :param pulumi.Input[str] instance_id: Id of the rdb instance to replicate.
        :param pulumi.Input[pulumi.InputType['DatabaseReadReplicaPrivateNetworkArgs']] private_network: Create an endpoint in a private network.
        :param pulumi.Input[str] region: `region`) The region in which the Database read replica should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseReadReplicaState.__new__(_DatabaseReadReplicaState)

        __props__.__dict__["direct_access"] = direct_access
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["private_network"] = private_network
        __props__.__dict__["region"] = region
        return DatabaseReadReplica(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="directAccess")
    def direct_access(self) -> pulumi.Output[Optional['outputs.DatabaseReadReplicaDirectAccess']]:
        """
        Creates a direct access endpoint to rdb replica.
        """
        return pulumi.get(self, "direct_access")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Id of the rdb instance to replicate.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> pulumi.Output[Optional['outputs.DatabaseReadReplicaPrivateNetwork']]:
        """
        Create an endpoint in a private network.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        `region`) The region in which the Database read replica should be created.
        """
        return pulumi.get(self, "region")

