# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceServerArgs', 'InstanceServer']

@pulumi.input_type
class InstanceServerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 boot_type: Optional[pulumi.Input[str]] = None,
                 bootscript_id: Optional[pulumi.Input[str]] = None,
                 cloud_init: Optional[pulumi.Input[str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input['InstanceServerRootVolumeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InstanceServer resource.
        :param pulumi.Input[str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will recreate a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_volume_ids: The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
               attached to the server. Updates to this field will trigger a stop/start of the server.
        :param pulumi.Input[str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[str] bootscript_id: The ID of the bootscript to use  (set boot_type to `bootscript`).
        :param pulumi.Input[str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[bool] enable_ipv6: Determines if IPv6 is enabled for the server.
        :param pulumi.Input[str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        :param pulumi.Input[str] ip_id: = (Optional) The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input['InstanceServerRootVolumeArgs'] root_volume: Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        :param pulumi.Input[str] security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param pulumi.Input[str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_data: The user data associated with the server
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "type", type)
        if additional_volume_ids is not None:
            pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if boot_type is not None:
            pulumi.set(__self__, "boot_type", boot_type)
        if bootscript_id is not None:
            pulumi.set(__self__, "bootscript_id", bootscript_id)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if enable_dynamic_ip is not None:
            pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
        attached to the server. Updates to this field will trigger a stop/start of the server.
        """
        return pulumi.get(self, "additional_volume_ids")

    @additional_volume_ids.setter
    def additional_volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_volume_ids", value)

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> Optional[pulumi.Input[str]]:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @boot_type.setter
    def boot_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_type", value)

    @property
    @pulumi.getter(name="bootscriptId")
    def bootscript_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the bootscript to use  (set boot_type to `bootscript`).
        """
        return pulumi.get(self, "bootscript_id")

    @bootscript_id.setter
    def bootscript_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootscript_id", value)

    @property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud init script associated with this server
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_init", value)

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @enable_dynamic_ip.setter
    def enable_dynamic_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic_ip", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if IPv6 is enabled for the server.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
        to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        = (Optional) The ID of the reserved IP that is attached to the server.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]:
        """
        The private network associated with the server.
        Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['InstanceServerRootVolumeArgs']]:
        """
        Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['InstanceServerRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The user data associated with the server
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceServerState:
    def __init__(__self__, *,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 boot_type: Optional[pulumi.Input[str]] = None,
                 bootscript_id: Optional[pulumi.Input[str]] = None,
                 cloud_init: Optional[pulumi.Input[str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_gateway: Optional[pulumi.Input[str]] = None,
                 ipv6_prefix_length: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 placement_group_policy_respected: Optional[pulumi.Input[bool]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input['InstanceServerRootVolumeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstanceServer resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_volume_ids: The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
               attached to the server. Updates to this field will trigger a stop/start of the server.
        :param pulumi.Input[str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[str] bootscript_id: The ID of the bootscript to use  (set boot_type to `bootscript`).
        :param pulumi.Input[str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[bool] enable_ipv6: Determines if IPv6 is enabled for the server.
        :param pulumi.Input[str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        :param pulumi.Input[str] ip_id: = (Optional) The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[str] ipv6_address: The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        :param pulumi.Input[str] ipv6_gateway: The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        :param pulumi.Input[int] ipv6_prefix_length: The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param pulumi.Input[bool] placement_group_policy_respected: True when the placement group policy is respected.
               - `root_volume`
        :param pulumi.Input[str] private_ip: The Scaleway internal IP address of the server.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[str] public_ip: The public IPv4 address of the server.
        :param pulumi.Input['InstanceServerRootVolumeArgs'] root_volume: Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        :param pulumi.Input[str] security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param pulumi.Input[str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will recreate a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_data: The user data associated with the server
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        if additional_volume_ids is not None:
            pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if boot_type is not None:
            pulumi.set(__self__, "boot_type", boot_type)
        if bootscript_id is not None:
            pulumi.set(__self__, "bootscript_id", bootscript_id)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if enable_dynamic_ip is not None:
            pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_prefix_length is not None:
            pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if placement_group_policy_respected is not None:
            pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
        attached to the server. Updates to this field will trigger a stop/start of the server.
        """
        return pulumi.get(self, "additional_volume_ids")

    @additional_volume_ids.setter
    def additional_volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_volume_ids", value)

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> Optional[pulumi.Input[str]]:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @boot_type.setter
    def boot_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_type", value)

    @property
    @pulumi.getter(name="bootscriptId")
    def bootscript_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the bootscript to use  (set boot_type to `bootscript`).
        """
        return pulumi.get(self, "bootscript_id")

    @bootscript_id.setter
    def bootscript_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootscript_id", value)

    @property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud init script associated with this server
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_init", value)

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @enable_dynamic_ip.setter
    def enable_dynamic_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic_ip", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if IPv6 is enabled for the server.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
        to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        = (Optional) The ID of the reserved IP that is attached to the server.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @ipv6_prefix_length.setter
    def ipv6_prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_prefix_length", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> Optional[pulumi.Input[bool]]:
        """
        True when the placement group policy is respected.
        - `root_volume`
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @placement_group_policy_respected.setter
    def placement_group_policy_respected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "placement_group_policy_respected", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Scaleway internal IP address of the server.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]:
        """
        The private network associated with the server.
        Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The public IPv4 address of the server.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['InstanceServerRootVolumeArgs']]:
        """
        Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['InstanceServerRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The user data associated with the server
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class InstanceServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 boot_type: Optional[pulumi.Input[str]] = None,
                 bootscript_id: Optional[pulumi.Input[str]] = None,
                 cloud_init: Optional[pulumi.Input[str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['InstanceServerRootVolumeArgs']]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Compute Instance servers. For more information, see [the documentation](https://developers.scaleway.com/en/products/instance/api/#servers-8bf7d7).

        Please check our [FAQ - Instances](https://www.scaleway.com/en/docs/faq/instances).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        public_ip = scaleway.InstanceIp("publicIp")
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            ip_id=public_ip.id)
        ```

        ### With additional volumes and tags

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        data = scaleway.InstanceVolume("data",
            size_in_gb=100,
            type="b_ssd")
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            tags=[
                "hello",
                "public",
            ],
            root_volume=scaleway.InstanceServerRootVolumeArgs(
                delete_on_termination=False,
            ),
            additional_volume_ids=[data.id])
        ```

        ### With a reserved IP

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        ip = scaleway.InstanceIp("ip")
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="f974feac-abae-4365-b988-8ec7d1cec10d",
            tags=[
                "hello",
                "public",
            ],
            ip_id=ip.id)
        ```

        ### With security group

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        www = scaleway.InstanceSecurityGroup("www",
            inbound_default_policy="drop",
            outbound_default_policy="accept",
            inbound_rules=[
                scaleway.InstanceSecurityGroupInboundRuleArgs(
                    action="accept",
                    port=22,
                    ip="212.47.225.64",
                ),
                scaleway.InstanceSecurityGroupInboundRuleArgs(
                    action="accept",
                    port=80,
                ),
                scaleway.InstanceSecurityGroupInboundRuleArgs(
                    action="accept",
                    port=443,
                ),
            ],
            outbound_rules=[scaleway.InstanceSecurityGroupOutboundRuleArgs(
                action="drop",
                ip_range="10.20.0.0/24",
            )])
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            security_group_id=www.id)
        ```

        ### With user data and cloud-init

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            user_data={
                "foo": "bar",
                "cloud-init": (lambda path: open(path).read())(f"{path['module']}/cloud-init.yml"),
            })
        ```

        ### With private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.VpcPrivateNetwork("pn01")
        base = scaleway.InstanceServer("base",
            image="ubuntu_focal",
            type="DEV1-S",
            private_networks=[scaleway.InstanceServerPrivateNetworkArgs(
                pn_id=pn01.id,
            )])
        ```

        ## Private Network

        > **Important:** Updates to `private_network` will recreate a new private network interface.

        - `pn_id` - (Required) The private network ID where to connect.
        - `mac_address` The private NIC MAC address.
        - `status` The private NIC state.
        - `zone` - (Defaults to provider `zone`) The zone in which the server must be created.

        > **Important:**

        - You can only attach an instance in the same zone as a private network.
        - Instance supports maximum 8 different private networks.

        ## Import

        Instance servers can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/instanceServer:InstanceServer web fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_volume_ids: The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
               attached to the server. Updates to this field will trigger a stop/start of the server.
        :param pulumi.Input[str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[str] bootscript_id: The ID of the bootscript to use  (set boot_type to `bootscript`).
        :param pulumi.Input[str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[bool] enable_ipv6: Determines if IPv6 is enabled for the server.
        :param pulumi.Input[str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        :param pulumi.Input[str] ip_id: = (Optional) The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerPrivateNetworkArgs']]]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[pulumi.InputType['InstanceServerRootVolumeArgs']] root_volume: Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        :param pulumi.Input[str] security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param pulumi.Input[str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will recreate a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_data: The user data associated with the server
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Compute Instance servers. For more information, see [the documentation](https://developers.scaleway.com/en/products/instance/api/#servers-8bf7d7).

        Please check our [FAQ - Instances](https://www.scaleway.com/en/docs/faq/instances).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        public_ip = scaleway.InstanceIp("publicIp")
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            ip_id=public_ip.id)
        ```

        ### With additional volumes and tags

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        data = scaleway.InstanceVolume("data",
            size_in_gb=100,
            type="b_ssd")
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            tags=[
                "hello",
                "public",
            ],
            root_volume=scaleway.InstanceServerRootVolumeArgs(
                delete_on_termination=False,
            ),
            additional_volume_ids=[data.id])
        ```

        ### With a reserved IP

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        ip = scaleway.InstanceIp("ip")
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="f974feac-abae-4365-b988-8ec7d1cec10d",
            tags=[
                "hello",
                "public",
            ],
            ip_id=ip.id)
        ```

        ### With security group

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        www = scaleway.InstanceSecurityGroup("www",
            inbound_default_policy="drop",
            outbound_default_policy="accept",
            inbound_rules=[
                scaleway.InstanceSecurityGroupInboundRuleArgs(
                    action="accept",
                    port=22,
                    ip="212.47.225.64",
                ),
                scaleway.InstanceSecurityGroupInboundRuleArgs(
                    action="accept",
                    port=80,
                ),
                scaleway.InstanceSecurityGroupInboundRuleArgs(
                    action="accept",
                    port=443,
                ),
            ],
            outbound_rules=[scaleway.InstanceSecurityGroupOutboundRuleArgs(
                action="drop",
                ip_range="10.20.0.0/24",
            )])
        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            security_group_id=www.id)
        ```

        ### With user data and cloud-init

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        web = scaleway.InstanceServer("web",
            type="DEV1-S",
            image="ubuntu_focal",
            user_data={
                "foo": "bar",
                "cloud-init": (lambda path: open(path).read())(f"{path['module']}/cloud-init.yml"),
            })
        ```

        ### With private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.VpcPrivateNetwork("pn01")
        base = scaleway.InstanceServer("base",
            image="ubuntu_focal",
            type="DEV1-S",
            private_networks=[scaleway.InstanceServerPrivateNetworkArgs(
                pn_id=pn01.id,
            )])
        ```

        ## Private Network

        > **Important:** Updates to `private_network` will recreate a new private network interface.

        - `pn_id` - (Required) The private network ID where to connect.
        - `mac_address` The private NIC MAC address.
        - `status` The private NIC state.
        - `zone` - (Defaults to provider `zone`) The zone in which the server must be created.

        > **Important:**

        - You can only attach an instance in the same zone as a private network.
        - Instance supports maximum 8 different private networks.

        ## Import

        Instance servers can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/instanceServer:InstanceServer web fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstanceServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 boot_type: Optional[pulumi.Input[str]] = None,
                 bootscript_id: Optional[pulumi.Input[str]] = None,
                 cloud_init: Optional[pulumi.Input[str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['InstanceServerRootVolumeArgs']]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceServerArgs.__new__(InstanceServerArgs)

            __props__.__dict__["additional_volume_ids"] = additional_volume_ids
            __props__.__dict__["boot_type"] = boot_type
            __props__.__dict__["bootscript_id"] = bootscript_id
            __props__.__dict__["cloud_init"] = cloud_init
            __props__.__dict__["enable_dynamic_ip"] = enable_dynamic_ip
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["image"] = image
            __props__.__dict__["ip_id"] = ip_id
            __props__.__dict__["name"] = name
            __props__.__dict__["placement_group_id"] = placement_group_id
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["root_volume"] = root_volume
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["zone"] = zone
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["ipv6_gateway"] = None
            __props__.__dict__["ipv6_prefix_length"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["placement_group_policy_respected"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
        super(InstanceServer, __self__).__init__(
            'scaleway:index/instanceServer:InstanceServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            boot_type: Optional[pulumi.Input[str]] = None,
            bootscript_id: Optional[pulumi.Input[str]] = None,
            cloud_init: Optional[pulumi.Input[str]] = None,
            enable_dynamic_ip: Optional[pulumi.Input[bool]] = None,
            enable_ipv6: Optional[pulumi.Input[bool]] = None,
            image: Optional[pulumi.Input[str]] = None,
            ip_id: Optional[pulumi.Input[str]] = None,
            ipv6_address: Optional[pulumi.Input[str]] = None,
            ipv6_gateway: Optional[pulumi.Input[str]] = None,
            ipv6_prefix_length: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            placement_group_id: Optional[pulumi.Input[str]] = None,
            placement_group_policy_respected: Optional[pulumi.Input[bool]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerPrivateNetworkArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            root_volume: Optional[pulumi.Input[pulumi.InputType['InstanceServerRootVolumeArgs']]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'InstanceServer':
        """
        Get an existing InstanceServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_volume_ids: The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
               attached to the server. Updates to this field will trigger a stop/start of the server.
        :param pulumi.Input[str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[str] bootscript_id: The ID of the bootscript to use  (set boot_type to `bootscript`).
        :param pulumi.Input[str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[bool] enable_ipv6: Determines if IPv6 is enabled for the server.
        :param pulumi.Input[str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        :param pulumi.Input[str] ip_id: = (Optional) The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[str] ipv6_address: The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        :param pulumi.Input[str] ipv6_gateway: The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        :param pulumi.Input[int] ipv6_prefix_length: The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param pulumi.Input[bool] placement_group_policy_respected: True when the placement group policy is respected.
               - `root_volume`
        :param pulumi.Input[str] private_ip: The Scaleway internal IP address of the server.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerPrivateNetworkArgs']]]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[str] public_ip: The public IPv4 address of the server.
        :param pulumi.Input[pulumi.InputType['InstanceServerRootVolumeArgs']] root_volume: Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        :param pulumi.Input[str] security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param pulumi.Input[str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will recreate a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_data: The user data associated with the server
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceServerState.__new__(_InstanceServerState)

        __props__.__dict__["additional_volume_ids"] = additional_volume_ids
        __props__.__dict__["boot_type"] = boot_type
        __props__.__dict__["bootscript_id"] = bootscript_id
        __props__.__dict__["cloud_init"] = cloud_init
        __props__.__dict__["enable_dynamic_ip"] = enable_dynamic_ip
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["image"] = image
        __props__.__dict__["ip_id"] = ip_id
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_gateway"] = ipv6_gateway
        __props__.__dict__["ipv6_prefix_length"] = ipv6_prefix_length
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["placement_group_id"] = placement_group_id
        __props__.__dict__["placement_group_policy_respected"] = placement_group_policy_respected
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["root_volume"] = root_volume
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["zone"] = zone
        return InstanceServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
        attached to the server. Updates to this field will trigger a stop/start of the server.
        """
        return pulumi.get(self, "additional_volume_ids")

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> pulumi.Output[Optional[str]]:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @property
    @pulumi.getter(name="bootscriptId")
    def bootscript_id(self) -> pulumi.Output[str]:
        """
        The ID of the bootscript to use  (set boot_type to `bootscript`).
        """
        return pulumi.get(self, "bootscript_id")

    @property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> pulumi.Output[Optional[str]]:
        """
        The cloud init script associated with this server
        """
        return pulumi.get(self, "cloud_init")

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if IPv6 is enabled for the server.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[str]]:
        """
        The UUID or the label of the base image used by the server. You can use [this endpoint](https://api-marketplace.scaleway.com/images?page=1&per_page=100)
        to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> pulumi.Output[Optional[str]]:
        """
        = (Optional) The ID of the reserved IP that is attached to the server.
        """
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[str]:
        """
        The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> pulumi.Output[str]:
        """
        The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> pulumi.Output[int]:
        """
        The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> pulumi.Output[bool]:
        """
        True when the placement group policy is respected.
        - `root_volume`
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The Scaleway internal IP address of the server.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceServerPrivateNetwork']]]:
        """
        The private network associated with the server.
        Use the `pn_id` key to attach a [private_network](https://developers.scaleway.com/en/products/instance/api/#private-nics-a42eea) on your instance.
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The public IPv4 address of the server.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Output['outputs.InstanceServerRootVolume']:
        """
        Root [volume](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39) attached to the server on creation.
        """
        return pulumi.get(self, "root_volume")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The user data associated with the server
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

