(self["webpackChunk_quetz_frontend_app"] = self["webpackChunk_quetz_frontend_app"] || []).push([["vendors-node_modules_jupyterlab_application_lib_index_js"],{

/***/ "../../node_modules/@jupyterlab/application/lib/connectionlost.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/connectionlost.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConnectionLost": () => (/* binding */ ConnectionLost)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ "webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * A default connection lost handler, which brings up an error dialog.
 */
const ConnectionLost = async function (manager, err, translator) {
    translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;
    const trans = translator.load('jupyterlab');
    const title = trans.__('Server Connection Error');
    const networkMsg = trans.__('A connection to the Jupyter server could not be established.\n' +
        'JupyterLab will continue trying to reconnect.\n' +
        'Check your network connection or Jupyter server configuration.\n');
    return (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(title, { message: networkMsg });
};
//# sourceMappingURL=connectionlost.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/frontend.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/frontend.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JupyterFrontEnd": () => (/* binding */ JupyterFrontEnd),
/* harmony export */   "JupyterFrontEndContextMenu": () => (/* binding */ JupyterFrontEndContextMenu)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/docregistry */ "webpack/sharing/consume/default/@jupyterlab/docregistry/@jupyterlab/docregistry");
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services/@jupyterlab/services");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _lumino_application__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/application */ "../../node_modules/@lumino/application/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/signaling */ "../../node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







/**
 * The base Jupyter front-end application class.
 *
 * @typeparam `T` - The `shell` type. Defaults to `JupyterFrontEnd.IShell`.
 *
 * @typeparam `U` - The type for supported format names. Defaults to `string`.
 *
 * #### Notes
 * This type is useful as a generic application against which front-end plugins
 * can be authored. It inherits from the Lumino `Application`.
 */
class JupyterFrontEnd extends _lumino_application__WEBPACK_IMPORTED_MODULE_4__.Application {
    /**
     * Construct a new JupyterFrontEnd object.
     */
    constructor(options) {
        super(options);
        this._formatChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);
        // render context menu/submenus with inline svg icon tweaks
        this.contextMenu = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.ContextMenuSvg({
            commands: this.commands,
            renderer: options.contextMenuRenderer
        });
        // The default restored promise if one does not exist in the options.
        const restored = new Promise(resolve => {
            requestAnimationFrame(() => {
                resolve();
            });
        });
        this.commandLinker =
            options.commandLinker || new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.CommandLinker({ commands: this.commands });
        this.docRegistry = options.docRegistry || new _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__.DocumentRegistry();
        this.restored =
            options.restored ||
                this.started.then(() => restored).catch(() => restored);
        this.serviceManager = options.serviceManager || new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServiceManager();
    }
    /**
     * The application form factor, e.g., `desktop` or `mobile`.
     */
    get format() {
        return this._format;
    }
    set format(format) {
        if (this._format !== format) {
            this._format = format;
            document.body.dataset['format'] = format;
            this._formatChanged.emit(format);
        }
    }
    /**
     * A signal that emits when the application form factor changes.
     */
    get formatChanged() {
        return this._formatChanged;
    }
    /**
     * Walks up the DOM hierarchy of the target of the active `contextmenu`
     * event, testing each HTMLElement ancestor for a user-supplied funcion. This can
     * be used to find an HTMLElement on which to operate, given a context menu click.
     *
     * @param fn - a function that takes an `HTMLElement` and returns a
     *   boolean for whether it is the element the requester is seeking.
     *
     * @returns an HTMLElement or undefined, if none is found.
     */
    contextMenuHitTest(fn) {
        if (!this._contextMenuEvent ||
            !(this._contextMenuEvent.target instanceof Node)) {
            return undefined;
        }
        let node = this._contextMenuEvent.target;
        do {
            if (node instanceof HTMLElement && fn(node)) {
                return node;
            }
            node = node.parentNode;
        } while (node && node.parentNode && node !== node.parentNode);
        return undefined;
        // TODO: we should be able to use .composedPath() to simplify this function
        // down to something like the below, but it seems like composedPath is
        // sometimes returning an empty list.
        /*
        if (this._contextMenuEvent) {
          this._contextMenuEvent
            .composedPath()
            .filter(x => x instanceof HTMLElement)
            .find(test);
        }
        return undefined;
        */
    }
    /**
     * A method invoked on a document `'contextmenu'` event.
     */
    evtContextMenu(event) {
        this._contextMenuEvent = event;
        if (event.shiftKey ||
            Private.suppressContextMenu(event.target)) {
            return;
        }
        const opened = this.contextMenu.open(event);
        if (opened) {
            const items = this.contextMenu.menu.items;
            // If only the context menu information will be shown,
            // with no real commands, close the context menu and
            // allow the native one to open.
            if (items.length === 1 &&
                items[0].command === JupyterFrontEndContextMenu.contextMenu) {
                this.contextMenu.menu.close();
                return;
            }
            // Stop propagation and allow the application context menu to show.
            event.preventDefault();
            event.stopPropagation();
        }
    }
}
/**
 * The namespace for `JupyterFrontEnd` class statics.
 */
(function (JupyterFrontEnd) {
    /**
     * Is JupyterLab in document mode?
     *
     * @param path - Full URL of JupyterLab
     * @param paths - The current IPaths object hydrated from PageConfig.
     */
    function inDocMode(path, paths) {
        const docPattern = new RegExp(`^${paths.urls.doc}`);
        const match = path.match(docPattern);
        if (match) {
            return true;
        }
        else {
            return false;
        }
    }
    JupyterFrontEnd.inDocMode = inDocMode;
    /**
     * The application paths dictionary token.
     */
    JupyterFrontEnd.IPaths = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.Token('@jupyterlab/application:IPaths');
    /**
     * The application tree resolver token.
     *
     * #### Notes
     * Not all Jupyter front-end applications will have a tree resolver
     * implemented on the client-side. This token should not be required as a
     * dependency if it is possible to make it an optional dependency.
     */
    JupyterFrontEnd.ITreeResolver = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.Token('@jupyterlab/application:ITreeResolver');
})(JupyterFrontEnd || (JupyterFrontEnd = {}));
/**
 * A namespace for module-private functionality.
 */
var Private;
(function (Private) {
    /**
     * Returns whether the element is itself, or a child of, an element with the `jp-suppress-context-menu` data attribute.
     */
    function suppressContextMenu(element) {
        return element.closest('[data-jp-suppress-context-menu]') !== null;
    }
    Private.suppressContextMenu = suppressContextMenu;
})(Private || (Private = {}));
/**
 * A namespace for the context menu override.
 */
var JupyterFrontEndContextMenu;
(function (JupyterFrontEndContextMenu) {
    /**
     * An id for a private context-menu-info ersatz command.
     */
    JupyterFrontEndContextMenu.contextMenu = '__internal:context-menu-info';
})(JupyterFrontEndContextMenu || (JupyterFrontEndContextMenu = {}));
//# sourceMappingURL=frontend.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/index.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConnectionLost": () => (/* reexport safe */ _connectionlost__WEBPACK_IMPORTED_MODULE_0__.ConnectionLost),
/* harmony export */   "JupyterFrontEnd": () => (/* reexport safe */ _frontend__WEBPACK_IMPORTED_MODULE_1__.JupyterFrontEnd),
/* harmony export */   "JupyterFrontEndContextMenu": () => (/* reexport safe */ _frontend__WEBPACK_IMPORTED_MODULE_1__.JupyterFrontEndContextMenu),
/* harmony export */   "JupyterLab": () => (/* reexport safe */ _lab__WEBPACK_IMPORTED_MODULE_2__.JupyterLab),
/* harmony export */   "ILayoutRestorer": () => (/* reexport safe */ _layoutrestorer__WEBPACK_IMPORTED_MODULE_3__.ILayoutRestorer),
/* harmony export */   "LayoutRestorer": () => (/* reexport safe */ _layoutrestorer__WEBPACK_IMPORTED_MODULE_3__.LayoutRestorer),
/* harmony export */   "IMimeDocumentTracker": () => (/* reexport safe */ _mimerenderers__WEBPACK_IMPORTED_MODULE_4__.IMimeDocumentTracker),
/* harmony export */   "Router": () => (/* reexport safe */ _router__WEBPACK_IMPORTED_MODULE_5__.Router),
/* harmony export */   "ILabShell": () => (/* reexport safe */ _shell__WEBPACK_IMPORTED_MODULE_6__.ILabShell),
/* harmony export */   "LabShell": () => (/* reexport safe */ _shell__WEBPACK_IMPORTED_MODULE_6__.LabShell),
/* harmony export */   "ILabStatus": () => (/* reexport safe */ _status__WEBPACK_IMPORTED_MODULE_7__.ILabStatus),
/* harmony export */   "ITreePathUpdater": () => (/* reexport safe */ _treepathupdater__WEBPACK_IMPORTED_MODULE_8__.ITreePathUpdater),
/* harmony export */   "IConnectionLost": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_9__.IConnectionLost),
/* harmony export */   "IRouter": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_9__.IRouter)
/* harmony export */ });
/* harmony import */ var _connectionlost__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./connectionlost */ "../../node_modules/@jupyterlab/application/lib/connectionlost.js");
/* harmony import */ var _frontend__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./frontend */ "../../node_modules/@jupyterlab/application/lib/frontend.js");
/* harmony import */ var _lab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lab */ "../../node_modules/@jupyterlab/application/lib/lab.js");
/* harmony import */ var _layoutrestorer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./layoutrestorer */ "../../node_modules/@jupyterlab/application/lib/layoutrestorer.js");
/* harmony import */ var _mimerenderers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./mimerenderers */ "../../node_modules/@jupyterlab/application/lib/mimerenderers.js");
/* harmony import */ var _router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./router */ "../../node_modules/@jupyterlab/application/lib/router.js");
/* harmony import */ var _shell__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./shell */ "../../node_modules/@jupyterlab/application/lib/shell.js");
/* harmony import */ var _status__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./status */ "../../node_modules/@jupyterlab/application/lib/status.js");
/* harmony import */ var _treepathupdater__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./treepathupdater */ "../../node_modules/@jupyterlab/application/lib/treepathupdater.js");
/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./tokens */ "../../node_modules/@jupyterlab/application/lib/tokens.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module application
 */










//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/lab.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/lab.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JupyterLab": () => (/* binding */ JupyterLab)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/docregistry */ "webpack/sharing/consume/default/@jupyterlab/docregistry/@jupyterlab/docregistry");
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _frontend__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./frontend */ "../../node_modules/@jupyterlab/application/lib/frontend.js");
/* harmony import */ var _mimerenderers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./mimerenderers */ "../../node_modules/@jupyterlab/application/lib/mimerenderers.js");
/* harmony import */ var _shell__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./shell */ "../../node_modules/@jupyterlab/application/lib/shell.js");
/* harmony import */ var _status__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./status */ "../../node_modules/@jupyterlab/application/lib/status.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







/**
 * JupyterLab is the main application class. It is instantiated once and shared.
 */
class JupyterLab extends _frontend__WEBPACK_IMPORTED_MODULE_3__.JupyterFrontEnd {
    /**
     * Construct a new JupyterLab object.
     */
    constructor(options = { shell: new _shell__WEBPACK_IMPORTED_MODULE_4__.LabShell() }) {
        super(Object.assign(Object.assign({}, options), { shell: options.shell || new _shell__WEBPACK_IMPORTED_MODULE_4__.LabShell() }));
        /**
         * The name of the JupyterLab application.
         */
        this.name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('appName') || 'JupyterLab';
        /**
         * A namespace/prefix plugins may use to denote their provenance.
         */
        this.namespace = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('appNamespace') || this.name;
        /**
         * A list of all errors encountered when registering plugins.
         */
        this.registerPluginErrors = [];
        /**
         * The application busy and dirty status signals and flags.
         */
        this.status = new _status__WEBPACK_IMPORTED_MODULE_5__.LabStatus(this);
        /**
         * The version of the JupyterLab application.
         */
        this.version = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('appVersion') || 'unknown';
        this.restored = this.shell.restored
            .then(() => undefined)
            .catch(() => undefined);
        // Create an IInfo dictionary from the options to override the defaults.
        const info = Object.keys(JupyterLab.defaultInfo).reduce((acc, val) => {
            if (val in options) {
                acc[val] = JSON.parse(JSON.stringify(options[val]));
            }
            return acc;
        }, {});
        // Populate application info.
        this._info = Object.assign(Object.assign({}, JupyterLab.defaultInfo), info);
        // Populate application paths override the defaults if necessary.
        const defaultURLs = JupyterLab.defaultPaths.urls;
        const defaultDirs = JupyterLab.defaultPaths.directories;
        const optionURLs = (options.paths && options.paths.urls) || {};
        const optionDirs = (options.paths && options.paths.directories) || {};
        this._paths = {
            urls: Object.keys(defaultURLs).reduce((acc, key) => {
                if (key in optionURLs) {
                    const value = optionURLs[key];
                    acc[key] = value;
                }
                else {
                    acc[key] = defaultURLs[key];
                }
                return acc;
            }, {}),
            directories: Object.keys(JupyterLab.defaultPaths.directories).reduce((acc, key) => {
                if (key in optionDirs) {
                    const value = optionDirs[key];
                    acc[key] = value;
                }
                else {
                    acc[key] = defaultDirs[key];
                }
                return acc;
            }, {})
        };
        if (this._info.devMode) {
            this.shell.addClass('jp-mod-devMode');
        }
        // Add initial model factory.
        this.docRegistry.addModelFactory(new _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__.Base64ModelFactory());
        if (options.mimeExtensions) {
            for (const plugin of (0,_mimerenderers__WEBPACK_IMPORTED_MODULE_6__.createRendermimePlugins)(options.mimeExtensions)) {
                this.registerPlugin(plugin);
            }
        }
    }
    /**
     * The JupyterLab application information dictionary.
     */
    get info() {
        return this._info;
    }
    /**
     * The JupyterLab application paths dictionary.
     */
    get paths() {
        return this._paths;
    }
    /**
     * Register plugins from a plugin module.
     *
     * @param mod - The plugin module to register.
     */
    registerPluginModule(mod) {
        let data = mod.default;
        // Handle commonjs exports.
        if (!mod.hasOwnProperty('__esModule')) {
            data = mod;
        }
        if (!Array.isArray(data)) {
            data = [data];
        }
        data.forEach(item => {
            try {
                this.registerPlugin(item);
            }
            catch (error) {
                this.registerPluginErrors.push(error);
            }
        });
    }
    /**
     * Register the plugins from multiple plugin modules.
     *
     * @param mods - The plugin modules to register.
     */
    registerPluginModules(mods) {
        mods.forEach(mod => {
            this.registerPluginModule(mod);
        });
    }
}
/**
 * The namespace for `JupyterLab` class statics.
 */
(function (JupyterLab) {
    /**
     * The layout restorer token.
     */
    JupyterLab.IInfo = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.Token('@jupyterlab/application:IInfo');
    /**
     * The default JupyterLab application info.
     */
    JupyterLab.defaultInfo = {
        devMode: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('devMode').toLowerCase() === 'true',
        deferred: { patterns: [], matches: [] },
        disabled: { patterns: [], matches: [] },
        mimeExtensions: [],
        filesCached: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('cacheFiles').toLowerCase() === 'true'
    };
    /**
     * The default JupyterLab application paths.
     */
    JupyterLab.defaultPaths = {
        urls: {
            base: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('baseUrl'),
            notFound: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('notFoundUrl'),
            app: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('appUrl'),
            doc: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('docUrl'),
            static: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('staticUrl'),
            settings: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('settingsUrl'),
            themes: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('themesUrl'),
            translations: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('translationsApiUrl'),
            hubHost: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('hubHost') || undefined,
            hubPrefix: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('hubPrefix') || undefined,
            hubUser: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('hubUser') || undefined,
            hubServerName: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('hubServerName') || undefined
        },
        directories: {
            appSettings: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('appSettingsDir'),
            schemas: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('schemasDir'),
            static: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('staticDir'),
            templates: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('templatesDir'),
            themes: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('themesDir'),
            userSettings: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('userSettingsDir'),
            serverRoot: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('serverRoot'),
            workspaces: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('workspacesDir')
        }
    };
})(JupyterLab || (JupyterLab = {}));
//# sourceMappingURL=lab.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/layoutrestorer.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/layoutrestorer.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ILayoutRestorer": () => (/* binding */ ILayoutRestorer),
/* harmony export */   "LayoutRestorer": () => (/* binding */ LayoutRestorer)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/properties */ "../../node_modules/@lumino/properties/dist/index.es6.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/


/**
 * The layout restorer token.
 */
const ILayoutRestorer = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/application:ILayoutRestorer');
/**
 * The data connector key for restorer data.
 */
const KEY = 'layout-restorer:data';
/**
 * The default implementation of a layout restorer.
 *
 * #### Notes
 * The lifecycle for state restoration is subtle. The sequence of events is:
 *
 * 1. The layout restorer plugin is instantiated and makes a `fetch` call to
 *    the data connector that stores the layout restoration data. The `fetch`
 *    call returns a promise that resolves in step 6, below.
 *
 * 2. Other plugins that care about state restoration require the layout
 *    restorer as a dependency.
 *
 * 3. As each load-time plugin initializes (which happens before the front-end
 *    application has `started`), it instructs the layout restorer whether
 *    the restorer ought to `restore` its widgets by passing in its widget
 *    tracker.
 *    Alternatively, a plugin that does not require its own widget tracker
 *    (because perhaps it only creates a single widget, like a command palette),
 *    can simply `add` its widget along with a persistent unique name to the
 *    layout restorer so that its layout state can be restored when the lab
 *    application restores.
 *
 * 4. After all the load-time plugins have finished initializing, the front-end
 *    application `started` promise will resolve. This is the `first`
 *    promise that the layout restorer waits for. By this point, all of the
 *    plugins that care about restoration will have instructed the layout
 *    restorer to `restore` their widget trackers.
 *
 * 5. The layout restorer will then instruct each plugin's widget tracker
 *    to restore its state and reinstantiate whichever widgets it wants. The
 *    tracker returns a promise to the layout restorer that resolves when it
 *    has completed restoring the tracked widgets it cares about.
 *
 * 6. As each widget tracker finishes restoring the widget instances it cares
 *    about, it resolves the promise that was returned to the layout restorer
 *    (in step 5). After all of the promises that the restorer is awaiting have
 *    settled, the restorer then resolves the outstanding `fetch` promise
 *    (from step 1) and hands off a layout state object to the application
 *    shell's `restoreLayout` method for restoration.
 *
 * 7. Once the application shell has finished restoring the layout, the
 *    JupyterLab application's `restored` promise is resolved.
 *
 * Of particular note are steps 5 and 6: since data restoration of plugins
 * is accomplished by executing commands, the command that is used to restore
 * the data of each plugin must return a promise that only resolves when the
 * widget has been created and added to the plugin's widget tracker.
 */
class LayoutRestorer {
    /**
     * Create a layout restorer.
     */
    constructor(options) {
        this._firstDone = false;
        this._promisesDone = false;
        this._promises = [];
        this._restored = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        this._trackers = new Set();
        this._widgets = new Map();
        this._connector = options.connector;
        this._first = options.first;
        this._registry = options.registry;
        void this._first
            .then(() => {
            this._firstDone = true;
        })
            .then(() => Promise.all(this._promises))
            .then(() => {
            this._promisesDone = true;
            // Release the tracker set.
            this._trackers.clear();
        })
            .then(() => {
            this._restored.resolve(void 0);
        });
    }
    /**
     * A promise resolved when the layout restorer is ready to receive signals.
     */
    get restored() {
        return this._restored.promise;
    }
    /**
     * Add a widget to be tracked by the layout restorer.
     */
    add(widget, name) {
        Private.nameProperty.set(widget, name);
        this._widgets.set(name, widget);
        widget.disposed.connect(this._onWidgetDisposed, this);
    }
    /**
     * Fetch the layout state for the application.
     *
     * #### Notes
     * Fetching the layout relies on all widget restoration to be complete, so
     * calls to `fetch` are guaranteed to return after restoration is complete.
     */
    async fetch() {
        const blank = {
            fresh: true,
            mainArea: null,
            leftArea: null,
            rightArea: null
        };
        const layout = this._connector.fetch(KEY);
        try {
            const [data] = await Promise.all([layout, this.restored]);
            if (!data) {
                return blank;
            }
            const { main, left, right } = data;
            // If any data exists, then this is not a fresh session.
            const fresh = false;
            // Rehydrate main area.
            const mainArea = this._rehydrateMainArea(main);
            // Rehydrate left area.
            const leftArea = this._rehydrateSideArea(left);
            // Rehydrate right area.
            const rightArea = this._rehydrateSideArea(right);
            return { fresh, mainArea, leftArea, rightArea };
        }
        catch (error) {
            return blank;
        }
    }
    /**
     * Restore the widgets of a particular widget tracker.
     *
     * @param tracker - The widget tracker whose widgets will be restored.
     *
     * @param options - The restoration options.
     */
    restore(tracker, options) {
        const warning = 'restore() can only be called before `first` has resolved.';
        if (this._firstDone) {
            console.warn(warning);
            return Promise.reject(warning);
        }
        const { namespace } = tracker;
        if (this._trackers.has(namespace)) {
            const warning = `A tracker namespaced ${namespace} was already restored.`;
            console.warn(warning);
            return Promise.reject(warning);
        }
        const { args, command, name, when } = options;
        // Add the tracker to the private trackers collection.
        this._trackers.add(namespace);
        // Whenever a new widget is added to the tracker, record its name.
        tracker.widgetAdded.connect((_, widget) => {
            const widgetName = name(widget);
            if (widgetName) {
                this.add(widget, `${namespace}:${widgetName}`);
            }
        }, this);
        // Whenever a widget is updated, get its new name.
        tracker.widgetUpdated.connect((_, widget) => {
            const widgetName = name(widget);
            if (widgetName) {
                const name = `${namespace}:${widgetName}`;
                Private.nameProperty.set(widget, name);
                this._widgets.set(name, widget);
            }
        });
        const first = this._first;
        const promise = tracker
            .restore({
            args: args || (() => _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.emptyObject),
            command,
            connector: this._connector,
            name,
            registry: this._registry,
            when: when ? [first].concat(when) : first
        })
            .catch(error => {
            console.error(error);
        });
        this._promises.push(promise);
        return promise;
    }
    /**
     * Save the layout state for the application.
     */
    save(data) {
        // If there are promises that are unresolved, bail.
        if (!this._promisesDone) {
            const warning = 'save() was called prematurely.';
            console.warn(warning);
            return Promise.reject(warning);
        }
        const dehydrated = {};
        dehydrated.main = this._dehydrateMainArea(data.mainArea);
        dehydrated.left = this._dehydrateSideArea(data.leftArea);
        dehydrated.right = this._dehydrateSideArea(data.rightArea);
        return this._connector.save(KEY, dehydrated);
    }
    /**
     * Dehydrate a main area description into a serializable object.
     */
    _dehydrateMainArea(area) {
        if (!area) {
            return null;
        }
        return Private.serializeMain(area);
    }
    /**
     * Reydrate a serialized main area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateMainArea(area) {
        if (!area) {
            return null;
        }
        return Private.deserializeMain(area, this._widgets);
    }
    /**
     * Dehydrate a side area description into a serializable object.
     */
    _dehydrateSideArea(area) {
        if (!area) {
            return null;
        }
        const dehydrated = { collapsed: area.collapsed };
        if (area.currentWidget) {
            const current = Private.nameProperty.get(area.currentWidget);
            if (current) {
                dehydrated.current = current;
            }
        }
        if (area.widgets) {
            dehydrated.widgets = area.widgets
                .map(widget => Private.nameProperty.get(widget))
                .filter(name => !!name);
        }
        return dehydrated;
    }
    /**
     * Reydrate a serialized side area description object.
     *
     * #### Notes
     * This function consumes data that can become corrupted, so it uses type
     * coercion to guarantee the dehydrated object is safely processed.
     */
    _rehydrateSideArea(area) {
        var _a;
        if (!area) {
            return { collapsed: true, currentWidget: null, widgets: null };
        }
        const internal = this._widgets;
        const collapsed = (_a = area.collapsed) !== null && _a !== void 0 ? _a : false;
        const currentWidget = area.current && internal.has(`${area.current}`)
            ? internal.get(`${area.current}`)
            : null;
        const widgets = !Array.isArray(area.widgets)
            ? null
            : area.widgets
                .map(name => internal.has(`${name}`) ? internal.get(`${name}`) : null)
                .filter(widget => !!widget);
        return {
            collapsed,
            currentWidget: currentWidget,
            widgets: widgets
        };
    }
    /**
     * Handle a widget disposal.
     */
    _onWidgetDisposed(widget) {
        const name = Private.nameProperty.get(widget);
        this._widgets.delete(name);
    }
}
/*
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * An attached property for a widget's ID in the serialized restore data.
     */
    Private.nameProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_1__.AttachedProperty({
        name: 'name',
        create: owner => ''
    });
    /**
     * Serialize individual areas within the main area.
     */
    function serializeArea(area) {
        if (!area || !area.type) {
            return null;
        }
        if (area.type === 'tab-area') {
            return {
                type: 'tab-area',
                currentIndex: area.currentIndex,
                widgets: area.widgets
                    .map(widget => Private.nameProperty.get(widget))
                    .filter(name => !!name)
            };
        }
        return {
            type: 'split-area',
            orientation: area.orientation,
            sizes: area.sizes,
            children: area.children
                .map(serializeArea)
                .filter(area => !!area)
        };
    }
    /**
     * Return a dehydrated, serializable version of the main dock panel.
     */
    function serializeMain(area) {
        const dehydrated = {
            dock: (area && area.dock && serializeArea(area.dock.main)) || null
        };
        if (area) {
            if (area.currentWidget) {
                const current = Private.nameProperty.get(area.currentWidget);
                if (current) {
                    dehydrated.current = current;
                }
            }
        }
        return dehydrated;
    }
    Private.serializeMain = serializeMain;
    /**
     * Deserialize individual areas within the main area.
     *
     * #### Notes
     * Because this data comes from a potentially unreliable foreign source, it is
     * typed as a `JSONObject`; but the actual expected type is:
     * `ITabArea | ISplitArea`.
     *
     * For fault tolerance, types are manually checked in deserialization.
     */
    function deserializeArea(area, names) {
        if (!area) {
            return null;
        }
        // Because this data is saved to a foreign data source, its type safety is
        // not guaranteed when it is retrieved, so exhaustive checks are necessary.
        const type = area.type || 'unknown';
        if (type === 'unknown' || (type !== 'tab-area' && type !== 'split-area')) {
            console.warn(`Attempted to deserialize unknown type: ${type}`);
            return null;
        }
        if (type === 'tab-area') {
            const { currentIndex, widgets } = area;
            const hydrated = {
                type: 'tab-area',
                currentIndex: currentIndex || 0,
                widgets: (widgets &&
                    widgets
                        .map(widget => names.get(widget))
                        .filter(widget => !!widget)) ||
                    []
            };
            // Make sure the current index is within bounds.
            if (hydrated.currentIndex > hydrated.widgets.length - 1) {
                hydrated.currentIndex = 0;
            }
            return hydrated;
        }
        const { orientation, sizes, children } = area;
        const hydrated = {
            type: 'split-area',
            orientation: orientation,
            sizes: sizes || [],
            children: (children &&
                children
                    .map(child => deserializeArea(child, names))
                    .filter(widget => !!widget)) ||
                []
        };
        return hydrated;
    }
    /**
     * Return the hydrated version of the main dock panel, ready to restore.
     *
     * #### Notes
     * Because this data comes from a potentially unreliable foreign source, it is
     * typed as a `JSONObject`; but the actual expected type is: `IMainArea`.
     *
     * For fault tolerance, types are manually checked in deserialization.
     */
    function deserializeMain(area, names) {
        if (!area) {
            return null;
        }
        const name = area.current || null;
        const dock = area.dock || null;
        return {
            currentWidget: (name && names.has(name) && names.get(name)) || null,
            dock: dock ? { main: deserializeArea(dock, names) } : null
        };
    }
    Private.deserializeMain = deserializeMain;
})(Private || (Private = {}));
//# sourceMappingURL=layoutrestorer.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/mimerenderers.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/mimerenderers.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IMimeDocumentTracker": () => (/* binding */ IMimeDocumentTracker),
/* harmony export */   "createRendermimePlugins": () => (/* binding */ createRendermimePlugins),
/* harmony export */   "createRendermimePlugin": () => (/* binding */ createRendermimePlugin)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/docregistry */ "webpack/sharing/consume/default/@jupyterlab/docregistry/@jupyterlab/docregistry");
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/rendermime */ "../../node_modules/@jupyterlab/rendermime/lib/tokens.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/properties */ "../../node_modules/@lumino/properties/dist/index.es6.js");
/* harmony import */ var _layoutrestorer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./layoutrestorer */ "../../node_modules/@jupyterlab/application/lib/layoutrestorer.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/translation */ "webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_5__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The mime document tracker token.
 */
const IMimeDocumentTracker = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.Token('@jupyterlab/application:IMimeDocumentTracker');
/**
 * Create rendermime plugins for rendermime extension modules.
 */
function createRendermimePlugins(extensions) {
    const plugins = [];
    const namespace = 'application-mimedocuments';
    const tracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.WidgetTracker({ namespace });
    extensions.forEach(mod => {
        let data = mod.default;
        // Handle CommonJS exports.
        if (!mod.hasOwnProperty('__esModule')) {
            data = mod;
        }
        if (!Array.isArray(data)) {
            data = [data];
        }
        data.forEach(item => {
            plugins.push(createRendermimePlugin(tracker, item));
        });
    });
    // Also add a meta-plugin handling state restoration
    // and exposing the mime document widget tracker.
    plugins.push({
        id: '@jupyterlab/application:mimedocument',
        optional: [_layoutrestorer__WEBPACK_IMPORTED_MODULE_6__.ILayoutRestorer],
        provides: IMimeDocumentTracker,
        autoStart: true,
        activate: (app, restorer) => {
            if (restorer) {
                void restorer.restore(tracker, {
                    command: 'docmanager:open',
                    args: widget => ({
                        path: widget.context.path,
                        factory: Private.factoryNameProperty.get(widget)
                    }),
                    name: widget => `${widget.context.path}:${Private.factoryNameProperty.get(widget)}`
                });
            }
            return tracker;
        }
    });
    return plugins;
}
/**
 * Create rendermime plugins for rendermime extension modules.
 */
function createRendermimePlugin(tracker, item) {
    return {
        id: item.id,
        requires: [_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_7__.IRenderMimeRegistry, _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_5__.ITranslator],
        autoStart: true,
        activate: (app, rendermime, translator) => {
            // Add the mime renderer.
            if (item.rank !== undefined) {
                rendermime.addFactory(item.rendererFactory, item.rank);
            }
            else {
                rendermime.addFactory(item.rendererFactory);
            }
            // Handle the widget factory.
            if (!item.documentWidgetFactoryOptions) {
                return;
            }
            const registry = app.docRegistry;
            let options = [];
            if (Array.isArray(item.documentWidgetFactoryOptions)) {
                options = item.documentWidgetFactoryOptions;
            }
            else {
                options = [
                    item.documentWidgetFactoryOptions
                ];
            }
            if (item.fileTypes) {
                item.fileTypes.forEach(ft => {
                    if (ft.icon) {
                        // upconvert the contents of the icon field to a proper LabIcon
                        ft = Object.assign(Object.assign({}, ft), { icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.LabIcon.resolve({ icon: ft.icon }) });
                    }
                    app.docRegistry.addFileType(ft);
                });
            }
            options.forEach(option => {
                const toolbarFactory = option.toolbarFactory
                    ? (w) => option.toolbarFactory(w.content.renderer)
                    : undefined;
                const factory = new _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_1__.MimeDocumentFactory({
                    renderTimeout: item.renderTimeout,
                    dataType: item.dataType,
                    rendermime,
                    modelName: option.modelName,
                    name: option.name,
                    primaryFileType: registry.getFileType(option.primaryFileType),
                    fileTypes: option.fileTypes,
                    defaultFor: option.defaultFor,
                    defaultRendered: option.defaultRendered,
                    toolbarFactory,
                    translator,
                    factory: item.rendererFactory
                });
                registry.addWidgetFactory(factory);
                factory.widgetCreated.connect((sender, widget) => {
                    Private.factoryNameProperty.set(widget, factory.name);
                    // Notify the widget tracker if restore data needs to update.
                    widget.context.pathChanged.connect(() => {
                        void tracker.save(widget);
                    });
                    void tracker.add(widget);
                });
            });
        }
    };
}
/**
 * Private namespace for the module.
 */
var Private;
(function (Private) {
    /**
     * An attached property for keeping the factory name
     * that was used to create a mimedocument.
     */
    Private.factoryNameProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_4__.AttachedProperty({
        name: 'factoryName',
        create: () => undefined
    });
})(Private || (Private = {}));
//# sourceMappingURL=mimerenderers.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/router.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/router.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Router": () => (/* binding */ Router)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/disposable */ "webpack/sharing/consume/default/@lumino/disposable/@lumino/disposable");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ "../../node_modules/@lumino/signaling/dist/index.es6.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/




/**
 * A static class that routes URLs within the application.
 */
class Router {
    /**
     * Create a URL router.
     */
    constructor(options) {
        /**
         * If a matching rule's command resolves with the `stop` token during routing,
         * no further matches will execute.
         */
        this.stop = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.Token('@jupyterlab/application:Router#stop');
        this._routed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._rules = new Map();
        this.base = options.base;
        this.commands = options.commands;
    }
    /**
     * Returns the parsed current URL of the application.
     */
    get current() {
        var _a, _b;
        const { base } = this;
        const parsed = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.parse(window.location.href);
        const { search, hash } = parsed;
        const path = (_b = (_a = parsed.pathname) === null || _a === void 0 ? void 0 : _a.replace(base, '/')) !== null && _b !== void 0 ? _b : '';
        const request = path + search + hash;
        return { hash, path, request, search };
    }
    /**
     * A signal emitted when the router routes a route.
     */
    get routed() {
        return this._routed;
    }
    /**
     * Navigate to a new path within the application.
     *
     * @param path - The new path or empty string if redirecting to root.
     *
     * @param options - The navigation options.
     */
    navigate(path, options = {}) {
        const { base } = this;
        const { history } = window;
        const { hard } = options;
        const old = document.location.href;
        const url = path && path.indexOf(base) === 0 ? path : _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(base, path);
        if (url === old) {
            return hard ? this.reload() : undefined;
        }
        history.pushState({}, '', url);
        if (hard) {
            return this.reload();
        }
        if (!options.skipRouting) {
            // Because a `route()` call may still be in the stack after having received
            // a `stop` token, wait for the next stack frame before calling `route()`.
            requestAnimationFrame(() => {
                void this.route();
            });
        }
    }
    /**
     * Register to route a path pattern to a command.
     *
     * @param options - The route registration options.
     *
     * @returns A disposable that removes the registered rule from the router.
     */
    register(options) {
        var _a;
        const { command, pattern } = options;
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : 100;
        const rules = this._rules;
        rules.set(pattern, { command, rank });
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__.DisposableDelegate(() => {
            rules.delete(pattern);
        });
    }
    /**
     * Cause a hard reload of the document.
     */
    reload() {
        window.location.reload();
    }
    /**
     * Route a specific path to an action.
     *
     * #### Notes
     * If a pattern is matched, its command will be invoked with arguments that
     * match the `IRouter.ILocation` interface.
     */
    route() {
        const { commands, current, stop } = this;
        const { request } = current;
        const routed = this._routed;
        const rules = this._rules;
        const matches = [];
        // Collect all rules that match the URL.
        rules.forEach((rule, pattern) => {
            if (request === null || request === void 0 ? void 0 : request.match(pattern)) {
                matches.push(rule);
            }
        });
        // Order the matching rules by rank and enqueue them.
        const queue = matches.sort((a, b) => b.rank - a.rank);
        const done = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
        // Process each enqueued command sequentially and short-circuit if a promise
        // resolves with the `stop` token.
        const next = async () => {
            if (!queue.length) {
                routed.emit(current);
                done.resolve(undefined);
                return;
            }
            const { command } = queue.pop();
            try {
                const request = this.current.request;
                const result = await commands.execute(command, current);
                if (result === stop) {
                    queue.length = 0;
                    console.debug(`Routing ${request} was short-circuited by ${command}`);
                }
            }
            catch (reason) {
                console.warn(`Routing ${request} to ${command} failed`, reason);
            }
            void next();
        };
        void next();
        return done.promise;
    }
}
//# sourceMappingURL=router.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/shell.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/shell.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ILabShell": () => (/* binding */ ILabShell),
/* harmony export */   "LabShell": () => (/* binding */ LabShell)
/* harmony export */ });
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/docregistry */ "webpack/sharing/consume/default/@jupyterlab/docregistry/@jupyterlab/docregistry");
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/algorithm */ "webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/messaging */ "webpack/sharing/consume/default/@lumino/messaging/@lumino/messaging");
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_messaging__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/polling */ "webpack/sharing/consume/default/@lumino/polling/@lumino/polling");
/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_polling__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/signaling */ "../../node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_7__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The class name added to AppShell instances.
 */
const APPLICATION_SHELL_CLASS = 'jp-LabShell';
/**
 * The class name added to side bar instances.
 */
const SIDEBAR_CLASS = 'jp-SideBar';
/**
 * The class name added to the current widget's title.
 */
const CURRENT_CLASS = 'jp-mod-current';
/**
 * The class name added to the active widget's title.
 */
const ACTIVE_CLASS = 'jp-mod-active';
/**
 * The default rank of items added to a sidebar.
 */
const DEFAULT_RANK = 900;
const ACTIVITY_CLASS = 'jp-Activity';
/**
 * The JupyterLab application shell token.
 */
const ILabShell = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.Token('@jupyterlab/application:ILabShell');
/**
 * The application shell for JupyterLab.
 */
class LabShell extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.Widget {
    /**
     * Construct a new application shell.
     */
    constructor() {
        super();
        /**
         * A message hook for child add/remove messages on the main area dock panel.
         */
        this._dockChildHook = (handler, msg) => {
            switch (msg.type) {
                case 'child-added':
                    msg.child.addClass(ACTIVITY_CLASS);
                    this._tracker.add(msg.child);
                    break;
                case 'child-removed':
                    msg.child.removeClass(ACTIVITY_CLASS);
                    this._tracker.remove(msg.child);
                    break;
                default:
                    break;
            }
            return true;
        };
        this._activeChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);
        this._cachedLayout = null;
        this._currentChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);
        this._currentPath = '';
        this._currentPathChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);
        this._modeChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);
        this._isRestored = false;
        this._layoutModified = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);
        this._layoutDebouncer = new _lumino_polling__WEBPACK_IMPORTED_MODULE_5__.Debouncer(() => {
            this._layoutModified.emit(undefined);
        }, 0);
        this._restored = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_3__.PromiseDelegate();
        this._tracker = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.FocusTracker();
        this._mainOptionsCache = new Map();
        this._sideOptionsCache = new Map();
        this.addClass(APPLICATION_SHELL_CLASS);
        this.id = 'main';
        const headerPanel = (this._headerPanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxPanel());
        const menuHandler = (this._menuHandler = new Private.PanelHandler());
        const topHandler = (this._topHandler = new Private.PanelHandler());
        const bottomPanel = (this._bottomPanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxPanel());
        const hboxPanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxPanel();
        const dockPanel = (this._dockPanel = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.DockPanelSvg());
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_4__.MessageLoop.installMessageHook(dockPanel, this._dockChildHook);
        const hsplitPanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.SplitPanel();
        const leftHandler = (this._leftHandler = new Private.SideBarHandler());
        const rightHandler = (this._rightHandler = new Private.SideBarHandler());
        const rootLayout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxLayout();
        headerPanel.id = 'jp-header-panel';
        menuHandler.panel.id = 'jp-menu-panel';
        topHandler.panel.id = 'jp-top-panel';
        bottomPanel.id = 'jp-bottom-panel';
        hboxPanel.id = 'jp-main-content-panel';
        dockPanel.id = 'jp-main-dock-panel';
        hsplitPanel.id = 'jp-main-split-panel';
        leftHandler.sideBar.addClass(SIDEBAR_CLASS);
        leftHandler.sideBar.addClass('jp-mod-left');
        leftHandler.stackedPanel.id = 'jp-left-stack';
        rightHandler.sideBar.addClass(SIDEBAR_CLASS);
        rightHandler.sideBar.addClass('jp-mod-right');
        rightHandler.stackedPanel.id = 'jp-right-stack';
        hboxPanel.spacing = 0;
        dockPanel.spacing = 5;
        hsplitPanel.spacing = 1;
        headerPanel.direction = 'top-to-bottom';
        hboxPanel.direction = 'left-to-right';
        hsplitPanel.orientation = 'horizontal';
        bottomPanel.direction = 'bottom-to-top';
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.SplitPanel.setStretch(leftHandler.stackedPanel, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.SplitPanel.setStretch(dockPanel, 1);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.SplitPanel.setStretch(rightHandler.stackedPanel, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxPanel.setStretch(leftHandler.sideBar, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxPanel.setStretch(hsplitPanel, 1);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxPanel.setStretch(rightHandler.sideBar, 0);
        hsplitPanel.addWidget(leftHandler.stackedPanel);
        hsplitPanel.addWidget(dockPanel);
        hsplitPanel.addWidget(rightHandler.stackedPanel);
        hboxPanel.addWidget(leftHandler.sideBar);
        hboxPanel.addWidget(hsplitPanel);
        hboxPanel.addWidget(rightHandler.sideBar);
        rootLayout.direction = 'top-to-bottom';
        rootLayout.spacing = 0; // TODO make this configurable?
        // Use relative sizing to set the width of the side panels.
        // This will still respect the min-size of children widget in the stacked
        // panel.
        hsplitPanel.setRelativeSizes([1, 2.5, 1]);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxLayout.setStretch(headerPanel, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxLayout.setStretch(menuHandler.panel, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxLayout.setStretch(topHandler.panel, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxLayout.setStretch(hboxPanel, 1);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.BoxLayout.setStretch(bottomPanel, 0);
        rootLayout.addWidget(headerPanel);
        rootLayout.addWidget(topHandler.panel);
        rootLayout.addWidget(hboxPanel);
        rootLayout.addWidget(bottomPanel);
        // initially hiding header and bottom panel when no elements inside,
        this._headerPanel.hide();
        this._bottomPanel.hide();
        this.layout = rootLayout;
        // Connect change listeners.
        this._tracker.currentChanged.connect(this._onCurrentChanged, this);
        this._tracker.activeChanged.connect(this._onActiveChanged, this);
        // Connect main layout change listener.
        this._dockPanel.layoutModified.connect(this._onLayoutModified, this);
        // Catch current changed events on the side handlers.
        this._leftHandler.sideBar.currentChanged.connect(this._onLayoutModified, this);
        this._rightHandler.sideBar.currentChanged.connect(this._onLayoutModified, this);
        // Setup single-document-mode title bar
        const titleWidget = (this._titleWidget = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.Widget());
        titleWidget.id = 'jp-title-panel-title';
        titleWidget.node.appendChild(document.createElement('h1'));
        this.add(titleWidget, 'top', { rank: 100 });
        if (this._dockPanel.mode === 'multiple-document') {
            this._topHandler.addWidget(this._menuHandler.panel, 100);
            titleWidget.hide();
        }
        else {
            rootLayout.insertWidget(2, this._menuHandler.panel);
        }
        // Wire up signals to update the title panel of the simple interface mode to
        // follow the title of this.currentWidget
        this.currentChanged.connect((sender, args) => {
            let newValue = args.newValue;
            let oldValue = args.oldValue;
            // Stop watching the title of the previously current widget
            if (oldValue) {
                oldValue.title.changed.disconnect(this._updateTitlePanelTitle, this);
            }
            // Start watching the title of the new current widget
            if (newValue) {
                newValue.title.changed.connect(this._updateTitlePanelTitle, this);
                this._updateTitlePanelTitle();
            }
            if (newValue && newValue instanceof _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_0__.DocumentWidget) {
                newValue.context.pathChanged.connect(this._updateCurrentPath, this);
            }
            this._updateCurrentPath();
        });
    }
    /**
     * A signal emitted when main area's active focus changes.
     */
    get activeChanged() {
        return this._activeChanged;
    }
    /**
     * The active widget in the shell's main area.
     */
    get activeWidget() {
        return this._tracker.activeWidget;
    }
    /**
     * A signal emitted when main area's current focus changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * A signal emitted when the shell/dock panel change modes (single/mutiple document).
     */
    get modeChanged() {
        return this._modeChanged;
    }
    /**
     * A signal emitted when the path of the current document changes.
     *
     * This also fires when the current document itself changes.
     */
    get currentPathChanged() {
        return this._currentPathChanged;
    }
    /**
     * The current widget in the shell's main area.
     */
    get currentWidget() {
        return this._tracker.currentWidget;
    }
    /**
     * A signal emitted when the main area's layout is modified.
     */
    get layoutModified() {
        return this._layoutModified;
    }
    /**
     * Whether the left area is collapsed.
     */
    get leftCollapsed() {
        return !this._leftHandler.sideBar.currentTitle;
    }
    /**
     * Whether the left area is collapsed.
     */
    get rightCollapsed() {
        return !this._rightHandler.sideBar.currentTitle;
    }
    /**
     * Whether JupyterLab is in presentation mode with the
     * `jp-mod-presentationMode` CSS class.
     */
    get presentationMode() {
        return this.hasClass('jp-mod-presentationMode');
    }
    /**
     * Enable/disable presentation mode (`jp-mod-presentationMode` CSS class) with
     * a boolean.
     */
    set presentationMode(value) {
        this.toggleClass('jp-mod-presentationMode', value);
    }
    /**
     * The main dock area's user interface mode.
     */
    get mode() {
        return this._dockPanel.mode;
    }
    set mode(mode) {
        const dock = this._dockPanel;
        if (mode === dock.mode) {
            return;
        }
        const applicationCurrentWidget = this.currentWidget;
        if (mode === 'single-document') {
            this._cachedLayout = dock.saveLayout();
            dock.mode = mode;
            // In case the active widget in the dock panel is *not* the active widget
            // of the application, defer to the application.
            if (this.currentWidget) {
                dock.activateWidget(this.currentWidget);
            }
            // Set the mode data attribute on the application shell node.
            this.node.dataset.shellMode = mode;
            // Adjust menu and title
            // this.add(this._menuHandler.panel, 'top', {rank: 100});
            this.layout.insertWidget(2, this._menuHandler.panel);
            this._titleWidget.show();
            this._updateTitlePanelTitle();
            this._modeChanged.emit(mode);
            return;
        }
        // Cache a reference to every widget currently in the dock panel.
        const widgets = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.toArray)(dock.widgets());
        // Toggle back to multiple document mode.
        dock.mode = mode;
        // Restore the original layout.
        if (this._cachedLayout) {
            // Remove any disposed widgets in the cached layout and restore.
            Private.normalizeAreaConfig(dock, this._cachedLayout.main);
            dock.restoreLayout(this._cachedLayout);
            this._cachedLayout = null;
        }
        // Add any widgets created during single document mode, which have
        // subsequently been removed from the dock panel after the multiple document
        // layout has been restored. If the widget has add options cached for
        // the widget (i.e., if it has been placed with respect to another widget),
        // then take that into account.
        widgets.forEach(widget => {
            if (!widget.parent) {
                this._addToMainArea(widget, Object.assign(Object.assign({}, this._mainOptionsCache.get(widget)), { activate: false }));
            }
        });
        this._mainOptionsCache.clear();
        // In case the active widget in the dock panel is *not* the active widget
        // of the application, defer to the application.
        if (applicationCurrentWidget) {
            dock.activateWidget(applicationCurrentWidget);
        }
        // Set the mode data attribute on the applications shell node.
        this.node.dataset.shellMode = mode;
        // Adjust menu and title
        this.add(this._menuHandler.panel, 'top', { rank: 100 });
        // this._topHandler.addWidget(this._menuHandler.panel, 100)
        this._titleWidget.hide();
        // Emit the mode changed signal
        this._modeChanged.emit(mode);
    }
    /**
     * Promise that resolves when state is first restored, returning layout
     * description.
     */
    get restored() {
        return this._restored.promise;
    }
    /**
     * Activate a widget in its area.
     */
    activateById(id) {
        if (this._leftHandler.has(id)) {
            this._leftHandler.activate(id);
            return;
        }
        if (this._rightHandler.has(id)) {
            this._rightHandler.activate(id);
            return;
        }
        const dock = this._dockPanel;
        const widget = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.find)(dock.widgets(), value => value.id === id);
        if (widget) {
            dock.activateWidget(widget);
        }
    }
    /*
     * Activate the next Tab in the active TabBar.
     */
    activateNextTab() {
        const current = this._currentTabBar();
        if (!current) {
            return;
        }
        const ci = current.currentIndex;
        if (ci === -1) {
            return;
        }
        if (ci < current.titles.length - 1) {
            current.currentIndex += 1;
            if (current.currentTitle) {
                current.currentTitle.owner.activate();
            }
            return;
        }
        if (ci === current.titles.length - 1) {
            const nextBar = this._adjacentBar('next');
            if (nextBar) {
                nextBar.currentIndex = 0;
                if (nextBar.currentTitle) {
                    nextBar.currentTitle.owner.activate();
                }
            }
        }
    }
    /*
     * Activate the previous Tab in the active TabBar.
     */
    activatePreviousTab() {
        const current = this._currentTabBar();
        if (!current) {
            return;
        }
        const ci = current.currentIndex;
        if (ci === -1) {
            return;
        }
        if (ci > 0) {
            current.currentIndex -= 1;
            if (current.currentTitle) {
                current.currentTitle.owner.activate();
            }
            return;
        }
        if (ci === 0) {
            const prevBar = this._adjacentBar('previous');
            if (prevBar) {
                const len = prevBar.titles.length;
                prevBar.currentIndex = len - 1;
                if (prevBar.currentTitle) {
                    prevBar.currentTitle.owner.activate();
                }
            }
        }
    }
    /*
     * Activate the next TabBar.
     */
    activateNextTabBar() {
        const nextBar = this._adjacentBar('next');
        if (nextBar) {
            if (nextBar.currentTitle) {
                nextBar.currentTitle.owner.activate();
            }
        }
    }
    /*
     * Activate the next TabBar.
     */
    activatePreviousTabBar() {
        const nextBar = this._adjacentBar('previous');
        if (nextBar) {
            if (nextBar.currentTitle) {
                nextBar.currentTitle.owner.activate();
            }
        }
    }
    add(widget, area = 'main', options) {
        switch (area || 'main') {
            case 'main':
                return this._addToMainArea(widget, options);
            case 'left':
                return this._addToLeftArea(widget, options);
            case 'right':
                return this._addToRightArea(widget, options);
            case 'header':
                return this._addToHeaderArea(widget, options);
            case 'top':
                return this._addToTopArea(widget, options);
            case 'menu':
                return this._addToMenuArea(widget, options);
            case 'bottom':
                return this._addToBottomArea(widget, options);
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Collapse the left area.
     */
    collapseLeft() {
        this._leftHandler.collapse();
        this._onLayoutModified();
    }
    /**
     * Collapse the right area.
     */
    collapseRight() {
        this._rightHandler.collapse();
        this._onLayoutModified();
    }
    /**
     * Dispose the shell.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._layoutDebouncer.dispose();
        this._titleWidget.dispose();
        super.dispose();
    }
    /**
     * Expand the left area.
     *
     * #### Notes
     * This will open the most recently used tab,
     * or the first tab if there is no most recently used.
     */
    expandLeft() {
        this._leftHandler.expand();
        this._onLayoutModified();
    }
    /**
     * Expand the right area.
     *
     * #### Notes
     * This will open the most recently used tab,
     * or the first tab if there is no most recently used.
     */
    expandRight() {
        this._rightHandler.expand();
        this._onLayoutModified();
    }
    /**
     * Close all widgets in the main area.
     */
    closeAll() {
        // Make a copy of all the widget in the dock panel (using `toArray()`)
        // before removing them because removing them while iterating through them
        // modifies the underlying data of the iterator.
        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.toArray)(this._dockPanel.widgets()).forEach(widget => widget.close());
    }
    /**
     * True if the given area is empty.
     */
    isEmpty(area) {
        switch (area) {
            case 'left':
                return this._leftHandler.stackedPanel.widgets.length === 0;
            case 'main':
                return this._dockPanel.isEmpty;
            case 'header':
                return this._headerPanel.widgets.length === 0;
            case 'top':
                return this._topHandler.panel.widgets.length === 0;
            case 'menu':
                return this._menuHandler.panel.widgets.length === 0;
            case 'bottom':
                return this._bottomPanel.widgets.length === 0;
            case 'right':
                return this._rightHandler.stackedPanel.widgets.length === 0;
            default:
                return true;
        }
    }
    /**
     * Restore the layout state for the application shell.
     */
    restoreLayout(mode, layout) {
        const { mainArea, leftArea, rightArea } = layout;
        // Rehydrate the main area.
        if (mainArea) {
            const { currentWidget, dock } = mainArea;
            if (dock) {
                this._dockPanel.restoreLayout(dock);
            }
            if (mode) {
                this.mode = mode;
            }
            if (currentWidget) {
                this.activateById(currentWidget.id);
            }
        }
        else {
            // This is needed when loading in an empty workspace in single doc mode
            if (mode) {
                this.mode = mode;
            }
        }
        // Rehydrate the left area.
        if (leftArea) {
            this._leftHandler.rehydrate(leftArea);
        }
        else {
            if (mode === 'single-document') {
                this.collapseLeft();
            }
        }
        // Rehydrate the right area.
        if (rightArea) {
            this._rightHandler.rehydrate(rightArea);
        }
        else {
            if (mode === 'single-document') {
                this.collapseRight();
            }
        }
        if (!this._isRestored) {
            // Make sure all messages in the queue are finished before notifying
            // any extensions that are waiting for the promise that guarantees the
            // application state has been restored.
            _lumino_messaging__WEBPACK_IMPORTED_MODULE_4__.MessageLoop.flush();
            this._restored.resolve(layout);
        }
    }
    /**
     * Save the dehydrated state of the application shell.
     */
    saveLayout() {
        // If the application is in single document mode, use the cached layout if
        // available. Otherwise, default to querying the dock panel for layout.
        const layout = {
            mainArea: {
                currentWidget: this._tracker.currentWidget,
                dock: this.mode === 'single-document'
                    ? this._cachedLayout || this._dockPanel.saveLayout()
                    : this._dockPanel.saveLayout()
            },
            leftArea: this._leftHandler.dehydrate(),
            rightArea: this._rightHandler.dehydrate()
        };
        return layout;
    }
    /**
     * Returns the widgets for an application area.
     */
    widgets(area) {
        switch (area !== null && area !== void 0 ? area : 'main') {
            case 'main':
                return this._dockPanel.widgets();
            case 'left':
                return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.iter)(this._leftHandler.sideBar.titles.map(t => t.owner));
            case 'right':
                return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.iter)(this._rightHandler.sideBar.titles.map(t => t.owner));
            case 'header':
                return this._headerPanel.children();
            case 'top':
                return this._topHandler.panel.children();
            case 'menu':
                return this._menuHandler.panel.children();
            case 'bottom':
                return this._bottomPanel.children();
            default:
                throw new Error(`Invalid area: ${area}`);
        }
    }
    /**
     * Handle `after-attach` messages for the application shell.
     */
    onAfterAttach(msg) {
        this.node.dataset.shellMode = this.mode;
    }
    /**
     * Update the title panel title based on the title of the current widget.
     */
    _updateTitlePanelTitle() {
        let current = this.currentWidget;
        const h1 = this._titleWidget.node.children[0];
        h1.textContent = current ? current.title.label : '';
        h1.title = current ? current.title.caption : '';
    }
    /**
     * The path of the current widget changed, fire the _currentPathChanged signal.
     */
    _updateCurrentPath() {
        let current = this.currentWidget;
        let newValue = '';
        if (current && current instanceof _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_0__.DocumentWidget) {
            newValue = current.context.path;
        }
        this._currentPathChanged.emit({
            newValue: newValue,
            oldValue: this._currentPath
        });
        this._currentPath = newValue;
    }
    /**
     * Add a widget to the left content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToLeftArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || this._sideOptionsCache.get(widget) || {};
        this._sideOptionsCache.set(widget, options);
        const rank = 'rank' in options ? options.rank : DEFAULT_RANK;
        this._leftHandler.addWidget(widget, rank);
        this._onLayoutModified();
    }
    /**
     * Add a widget to the main content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     * All widgets added to the main area should be disposed after removal
     * (disposal before removal will remove the widget automatically).
     *
     * In the options, `ref` defaults to `null`, `mode` defaults to `'tab-after'`,
     * and `activate` defaults to `true`.
     */
    _addToMainArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const dock = this._dockPanel;
        const mode = options.mode || 'tab-after';
        let ref = this.currentWidget;
        if (options.ref) {
            ref = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.find)(dock.widgets(), value => value.id === options.ref) || null;
        }
        const { title } = widget;
        // Add widget ID to tab so that we can get a handle on the tab's widget
        // (for context menu support)
        title.dataset = Object.assign(Object.assign({}, title.dataset), { id: widget.id });
        if (title.icon instanceof _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.LabIcon) {
            // bind an appropriate style to the icon
            title.icon = title.icon.bindprops({
                stylesheet: 'mainAreaTab'
            });
        }
        else if (typeof title.icon === 'string' || !title.icon) {
            // add some classes to help with displaying css background imgs
            title.iconClass = (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.classes)(title.iconClass, 'jp-Icon');
        }
        dock.addWidget(widget, { mode, ref });
        // The dock panel doesn't account for placement information while
        // in single document mode, so upon rehydrating any widgets that were
        // added will not be in the correct place. Cache the placement information
        // here so that we can later rehydrate correctly.
        if (dock.mode === 'single-document') {
            this._mainOptionsCache.set(widget, options);
        }
        if (options.activate !== false) {
            dock.activateWidget(widget);
        }
    }
    /**
     * Add a widget to the right content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToRightArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || this._sideOptionsCache.get(widget) || {};
        const rank = 'rank' in options ? options.rank : DEFAULT_RANK;
        this._sideOptionsCache.set(widget, options);
        this._rightHandler.addWidget(widget, rank);
        this._onLayoutModified();
    }
    /**
     * Add a widget to the top content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToTopArea(widget, options) {
        var _a;
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : DEFAULT_RANK;
        this._topHandler.addWidget(widget, rank);
        this._onLayoutModified();
        if (this._topHandler.panel.isHidden) {
            this._topHandler.panel.show();
        }
    }
    /**
     * Add a widget to the title content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToMenuArea(widget, options) {
        var _a;
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        options = options || {};
        const rank = (_a = options.rank) !== null && _a !== void 0 ? _a : DEFAULT_RANK;
        this._menuHandler.addWidget(widget, rank);
        this._onLayoutModified();
        if (this._menuHandler.panel.isHidden) {
            this._menuHandler.panel.show();
        }
    }
    /**
     * Add a widget to the header content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToHeaderArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        // Temporary: widgets are added to the panel in order of insertion.
        this._headerPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._headerPanel.isHidden) {
            this._headerPanel.show();
        }
    }
    /**
     * Add a widget to the bottom content area.
     *
     * #### Notes
     * Widgets must have a unique `id` property, which will be used as the DOM id.
     */
    _addToBottomArea(widget, options) {
        if (!widget.id) {
            console.error('Widgets added to app shell must have unique id property.');
            return;
        }
        // Temporary: widgets are added to the panel in order of insertion.
        this._bottomPanel.addWidget(widget);
        this._onLayoutModified();
        if (this._bottomPanel.isHidden) {
            this._bottomPanel.show();
        }
    }
    /*
     * Return the tab bar adjacent to the current TabBar or `null`.
     */
    _adjacentBar(direction) {
        const current = this._currentTabBar();
        if (!current) {
            return null;
        }
        const bars = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.toArray)(this._dockPanel.tabBars());
        const len = bars.length;
        const index = bars.indexOf(current);
        if (direction === 'previous') {
            return index > 0 ? bars[index - 1] : index === 0 ? bars[len - 1] : null;
        }
        // Otherwise, direction is 'next'.
        return index < len - 1
            ? bars[index + 1]
            : index === len - 1
                ? bars[0]
                : null;
    }
    /*
     * Return the TabBar that has the currently active Widget or null.
     */
    _currentTabBar() {
        const current = this._tracker.currentWidget;
        if (!current) {
            return null;
        }
        const title = current.title;
        const bars = this._dockPanel.tabBars();
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.find)(bars, bar => bar.titles.indexOf(title) > -1) || null;
    }
    /**
     * Handle a change to the dock area active widget.
     */
    _onActiveChanged(sender, args) {
        if (args.newValue) {
            args.newValue.title.className += ` ${ACTIVE_CLASS}`;
        }
        if (args.oldValue) {
            args.oldValue.title.className = args.oldValue.title.className.replace(ACTIVE_CLASS, '');
        }
        this._activeChanged.emit(args);
    }
    /**
     * Handle a change to the dock area current widget.
     */
    _onCurrentChanged(sender, args) {
        if (args.newValue) {
            args.newValue.title.className += ` ${CURRENT_CLASS}`;
        }
        if (args.oldValue) {
            args.oldValue.title.className = args.oldValue.title.className.replace(CURRENT_CLASS, '');
        }
        this._currentChanged.emit(args);
        this._onLayoutModified();
    }
    /**
     * Handle a change to the layout.
     */
    _onLayoutModified() {
        void this._layoutDebouncer.invoke();
    }
}
var Private;
(function (Private) {
    /**
     * A less-than comparison function for side bar rank items.
     */
    function itemCmp(first, second) {
        return first.rank - second.rank;
    }
    Private.itemCmp = itemCmp;
    /**
     * Removes widgets that have been disposed from an area config, mutates area.
     */
    function normalizeAreaConfig(parent, area) {
        if (!area) {
            return;
        }
        if (area.type === 'tab-area') {
            area.widgets = area.widgets.filter(widget => !widget.isDisposed && widget.parent === parent);
            return;
        }
        area.children.forEach(child => {
            normalizeAreaConfig(parent, child);
        });
    }
    Private.normalizeAreaConfig = normalizeAreaConfig;
    /**
     * A class which manages a panel and sorts its widgets by rank.
     */
    class PanelHandler {
        constructor() {
            /**
             * A message hook for child add/remove messages on the main area dock panel.
             */
            this._panelChildHook = (handler, msg) => {
                switch (msg.type) {
                    case 'child-added':
                        {
                            const widget = msg.child;
                            // If we already know about this widget, we're done
                            if (this._items.find(v => v.widget === widget)) {
                                break;
                            }
                            // Otherwise, add to the end by default
                            const rank = this._items[this._items.length - 1].rank;
                            this._items.push({ widget, rank });
                        }
                        break;
                    case 'child-removed':
                        {
                            const widget = msg.child;
                            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.removeFirstWhere(this._items, v => v.widget === widget);
                        }
                        break;
                    default:
                        break;
                }
                return true;
            };
            this._items = new Array();
            this._panel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.Panel();
            _lumino_messaging__WEBPACK_IMPORTED_MODULE_4__.MessageLoop.installMessageHook(this._panel, this._panelChildHook);
        }
        /**
         * Get the panel managed by the handler.
         */
        get panel() {
            return this._panel;
        }
        /**
         * Add a widget to the panel.
         *
         * If the widget is already added, it will be moved.
         */
        addWidget(widget, rank) {
            widget.parent = null;
            const item = { widget, rank };
            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.upperBound(this._items, item, Private.itemCmp);
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.insert(this._items, index, item);
            this._panel.insertWidget(index, widget);
        }
    }
    Private.PanelHandler = PanelHandler;
    /**
     * A class which manages a side bar and related stacked panel.
     */
    class SideBarHandler {
        /**
         * Construct a new side bar handler.
         */
        constructor() {
            this._items = new Array();
            this._sideBar = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.TabBar({
                insertBehavior: 'none',
                removeBehavior: 'none',
                allowDeselect: true
            });
            this._stackedPanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_7__.StackedPanel();
            this._sideBar.hide();
            this._stackedPanel.hide();
            this._lastCurrent = null;
            this._sideBar.currentChanged.connect(this._onCurrentChanged, this);
            this._sideBar.tabActivateRequested.connect(this._onTabActivateRequested, this);
            this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
        }
        /**
         * Get the tab bar managed by the handler.
         */
        get sideBar() {
            return this._sideBar;
        }
        /**
         * Get the stacked panel managed by the handler
         */
        get stackedPanel() {
            return this._stackedPanel;
        }
        /**
         * Expand the sidebar.
         *
         * #### Notes
         * This will open the most recently used tab, or the first tab
         * if there is no most recently used.
         */
        expand() {
            const previous = this._lastCurrent || (this._items.length > 0 && this._items[0].widget);
            if (previous) {
                this.activate(previous.id);
            }
        }
        /**
         * Activate a widget residing in the side bar by ID.
         *
         * @param id - The widget's unique ID.
         */
        activate(id) {
            const widget = this._findWidgetByID(id);
            if (widget) {
                this._sideBar.currentTitle = widget.title;
                widget.activate();
            }
        }
        /**
         * Test whether the sidebar has the given widget by id.
         */
        has(id) {
            return this._findWidgetByID(id) !== null;
        }
        /**
         * Collapse the sidebar so no items are expanded.
         */
        collapse() {
            this._sideBar.currentTitle = null;
        }
        /**
         * Add a widget and its title to the stacked panel and side bar.
         *
         * If the widget is already added, it will be moved.
         */
        addWidget(widget, rank) {
            widget.parent = null;
            widget.hide();
            const item = { widget, rank };
            const index = this._findInsertIndex(item);
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.insert(this._items, index, item);
            this._stackedPanel.insertWidget(index, widget);
            const title = this._sideBar.insertTab(index, widget.title);
            // Store the parent id in the title dataset
            // in order to dispatch click events to the right widget.
            title.dataset = { id: widget.id };
            if (title.icon instanceof _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.LabIcon) {
                // bind an appropriate style to the icon
                title.icon = title.icon.bindprops({
                    stylesheet: 'sideBar'
                });
            }
            else if (typeof title.icon === 'string' || !title.icon) {
                // add some classes to help with displaying css background imgs
                title.iconClass = (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.classes)(title.iconClass, 'jp-Icon', 'jp-Icon-20');
            }
            this._refreshVisibility();
        }
        /**
         * Dehydrate the side bar data.
         */
        dehydrate() {
            const collapsed = this._sideBar.currentTitle === null;
            const widgets = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.toArray)(this._stackedPanel.widgets);
            const currentWidget = widgets[this._sideBar.currentIndex];
            return { collapsed, currentWidget, widgets };
        }
        /**
         * Rehydrate the side bar.
         */
        rehydrate(data) {
            if (data.currentWidget) {
                this.activate(data.currentWidget.id);
            }
            if (data.collapsed) {
                this.collapse();
            }
        }
        /**
         * Find the insertion index for a rank item.
         */
        _findInsertIndex(item) {
            return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.upperBound(this._items, item, Private.itemCmp);
        }
        /**
         * Find the index of the item with the given widget, or `-1`.
         */
        _findWidgetIndex(widget) {
            return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.findFirstIndex(this._items, i => i.widget === widget);
        }
        /**
         * Find the widget which owns the given title, or `null`.
         */
        _findWidgetByTitle(title) {
            const item = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.find)(this._items, value => value.widget.title === title);
            return item ? item.widget : null;
        }
        /**
         * Find the widget with the given id, or `null`.
         */
        _findWidgetByID(id) {
            const item = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.find)(this._items, value => value.widget.id === id);
            return item ? item.widget : null;
        }
        /**
         * Refresh the visibility of the side bar and stacked panel.
         */
        _refreshVisibility() {
            this._sideBar.setHidden(this._sideBar.titles.length === 0);
            this._stackedPanel.setHidden(this._sideBar.currentTitle === null);
        }
        /**
         * Handle the `currentChanged` signal from the sidebar.
         */
        _onCurrentChanged(sender, args) {
            const oldWidget = args.previousTitle
                ? this._findWidgetByTitle(args.previousTitle)
                : null;
            const newWidget = args.currentTitle
                ? this._findWidgetByTitle(args.currentTitle)
                : null;
            if (oldWidget) {
                oldWidget.hide();
            }
            if (newWidget) {
                newWidget.show();
            }
            this._lastCurrent = newWidget || oldWidget;
            this._refreshVisibility();
        }
        /**
         * Handle a `tabActivateRequest` signal from the sidebar.
         */
        _onTabActivateRequested(sender, args) {
            args.title.owner.activate();
        }
        /*
         * Handle the `widgetRemoved` signal from the stacked panel.
         */
        _onWidgetRemoved(sender, widget) {
            if (widget === this._lastCurrent) {
                this._lastCurrent = null;
            }
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.removeAt(this._items, this._findWidgetIndex(widget));
            this._sideBar.removeTab(widget.title);
            this._refreshVisibility();
        }
    }
    Private.SideBarHandler = SideBarHandler;
})(Private || (Private = {}));
//# sourceMappingURL=shell.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/status.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/status.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ILabStatus": () => (/* binding */ ILabStatus),
/* harmony export */   "LabStatus": () => (/* binding */ LabStatus)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/disposable */ "webpack/sharing/consume/default/@lumino/disposable/@lumino/disposable");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ "../../node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/* tslint:disable */
/**
 * The application status token.
 */
const ILabStatus = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/application:ILabStatus');
/**
 * The application status signals and flags class.
 */
class LabStatus {
    /**
     * Construct a new  status object.
     */
    constructor(app) {
        this._busyCount = 0;
        this._dirtyCount = 0;
        this._busySignal = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(app);
        this._dirtySignal = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(app);
    }
    /**
     * Returns a signal for when application changes its busy status.
     */
    get busySignal() {
        return this._busySignal;
    }
    /**
     * Returns a signal for when application changes its dirty status.
     */
    get dirtySignal() {
        return this._dirtySignal;
    }
    /**
     * Whether the application is busy.
     */
    get isBusy() {
        return this._busyCount > 0;
    }
    /**
     * Whether the application is dirty.
     */
    get isDirty() {
        return this._dirtyCount > 0;
    }
    /**
     * Set the application state to dirty.
     *
     * @returns A disposable used to clear the dirty state for the caller.
     */
    setDirty() {
        const oldDirty = this.isDirty;
        this._dirtyCount++;
        if (this.isDirty !== oldDirty) {
            this._dirtySignal.emit(this.isDirty);
        }
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableDelegate(() => {
            const oldDirty = this.isDirty;
            this._dirtyCount = Math.max(0, this._dirtyCount - 1);
            if (this.isDirty !== oldDirty) {
                this._dirtySignal.emit(this.isDirty);
            }
        });
    }
    /**
     * Set the application state to busy.
     *
     * @returns A disposable used to clear the busy state for the caller.
     */
    setBusy() {
        const oldBusy = this.isBusy;
        this._busyCount++;
        if (this.isBusy !== oldBusy) {
            this._busySignal.emit(this.isBusy);
        }
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableDelegate(() => {
            const oldBusy = this.isBusy;
            this._busyCount--;
            if (this.isBusy !== oldBusy) {
                this._busySignal.emit(this.isBusy);
            }
        });
    }
}
//# sourceMappingURL=status.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/tokens.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/tokens.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IConnectionLost": () => (/* binding */ IConnectionLost),
/* harmony export */   "IRouter": () => (/* binding */ IRouter)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A token for which a plugin can provide to respond to connection failures
 * to the application server.
 */
const IConnectionLost = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:IConnectionLost');
/**
 * The URL Router token.
 */
const IRouter = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/application:IRouter');
//# sourceMappingURL=tokens.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/application/lib/treepathupdater.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/application/lib/treepathupdater.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ITreePathUpdater": () => (/* binding */ ITreePathUpdater)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The tree path updater token.
 */
const ITreePathUpdater = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/application:ITreePathUpdater');
//# sourceMappingURL=treepathupdater.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/rendermime/lib/tokens.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@jupyterlab/rendermime/lib/tokens.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IRenderMimeRegistry": () => (/* binding */ IRenderMimeRegistry),
/* harmony export */   "ILatexTypesetter": () => (/* binding */ ILatexTypesetter)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/* tslint:disable */
/**
 * The rendermime token.
 */
const IRenderMimeRegistry = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/rendermime:IRenderMimeRegistry');
/* tslint:enable */
/* tslint:disable */
/**
 * The latex typesetter token.
 */
const ILatexTypesetter = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/rendermime:ILatexTypesetter');
/* tslint:enable */
//# sourceMappingURL=tokens.js.map

/***/ }),

/***/ "../../node_modules/@lumino/application/dist/index.es6.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@lumino/application/dist/index.es6.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Application": () => (/* binding */ Application)
/* harmony export */ });
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/commands */ "webpack/sharing/consume/default/@lumino/commands/@lumino/commands");
/* harmony import */ var _lumino_commands__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_commands__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);




/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

/**
 * A class for creating pluggable applications.
 *
 * #### Notes
 * The `Application` class is useful when creating large, complex
 * UI applications with the ability to be safely extended by third
 * party code via plugins.
 */
var Application = /** @class */ (function () {
    /**
     * Construct a new application.
     *
     * @param options - The options for creating the application.
     */
    function Application(options) {
        this._started = false;
        this._pluginMap = Private.createPluginMap();
        this._serviceMap = Private.createServiceMap();
        this._delegate = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
        // Create the application command registry.
        var commands = new _lumino_commands__WEBPACK_IMPORTED_MODULE_0__.CommandRegistry();
        // Create the application context menu.
        var renderer = options.contextMenuRenderer;
        var contextMenu = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.ContextMenu({ commands: commands, renderer: renderer });
        // Initialize the application state.
        this.commands = commands;
        this.contextMenu = contextMenu;
        this.shell = options.shell;
    }
    Object.defineProperty(Application.prototype, "started", {
        /**
         * A promise which resolves after the application has started.
         *
         * #### Notes
         * This promise will resolve after the `start()` method is called,
         * when all the bootstrapping and shell mounting work is complete.
         */
        get: function () {
            return this._delegate.promise;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Test whether a plugin is registered with the application.
     *
     * @param id - The id of the plugin of interest.
     *
     * @returns `true` if the plugin is registered, `false` otherwise.
     */
    Application.prototype.hasPlugin = function (id) {
        return id in this._pluginMap;
    };
    /**
     * List the IDs of the plugins registered with the application.
     *
     * @returns A new array of the registered plugin IDs.
     */
    Application.prototype.listPlugins = function () {
        return Object.keys(this._pluginMap);
    };
    /**
     * Register a plugin with the application.
     *
     * @param plugin - The plugin to register.
     *
     * #### Notes
     * An error will be thrown if a plugin with the same id is already
     * registered, or if the plugin has a circular dependency.
     *
     * If the plugin provides a service which has already been provided
     * by another plugin, the new service will override the old service.
     */
    Application.prototype.registerPlugin = function (plugin) {
        // Throw an error if the plugin id is already registered.
        if (plugin.id in this._pluginMap) {
            throw new Error("Plugin '" + plugin.id + "' is already registered.");
        }
        // Create the normalized plugin data.
        var data = Private.createPluginData(plugin);
        // Ensure the plugin does not cause a cyclic dependency.
        Private.ensureNoCycle(data, this._pluginMap, this._serviceMap);
        // Add the service token to the service map.
        if (data.provides) {
            this._serviceMap.set(data.provides, data.id);
        }
        // Add the plugin to the plugin map.
        this._pluginMap[data.id] = data;
    };
    /**
     * Register multiple plugins with the application.
     *
     * @param plugins - The plugins to register.
     *
     * #### Notes
     * This calls `registerPlugin()` for each of the given plugins.
     */
    Application.prototype.registerPlugins = function (plugins) {
        for (var _i = 0, plugins_1 = plugins; _i < plugins_1.length; _i++) {
            var plugin = plugins_1[_i];
            this.registerPlugin(plugin);
        }
    };
    /**
     * Activate the plugin with the given id.
     *
     * @param id - The ID of the plugin of interest.
     *
     * @returns A promise which resolves when the plugin is activated
     *   or rejects with an error if it cannot be activated.
     */
    Application.prototype.activatePlugin = function (id) {
        var _this = this;
        // Reject the promise if the plugin is not registered.
        var data = this._pluginMap[id];
        if (!data) {
            return Promise.reject(new Error("Plugin '" + id + "' is not registered."));
        }
        // Resolve immediately if the plugin is already activated.
        if (data.activated) {
            return Promise.resolve(undefined);
        }
        // Return the pending resolver promise if it exists.
        if (data.promise) {
            return data.promise;
        }
        // Resolve the required services for the plugin.
        var required = data.requires.map(function (t) { return _this.resolveRequiredService(t); });
        // Resolve the optional services for the plugin.
        var optional = data.optional.map(function (t) { return _this.resolveOptionalService(t); });
        // Create the array of promises to resolve.
        var promises = required.concat(optional);
        // Setup the resolver promise for the plugin.
        data.promise = Promise.all(promises).then(function (services) {
            return data.activate.apply(undefined, __spreadArrays([_this], services));
        }).then(function (service) {
            data.service = service;
            data.activated = true;
            data.promise = null;
        }).catch(function (error) {
            data.promise = null;
            throw error;
        });
        // Return the pending resolver promise.
        return data.promise;
    };
    /**
     * Resolve a required service of a given type.
     *
     * @param token - The token for the service type of interest.
     *
     * @returns A promise which resolves to an instance of the requested
     *   service, or rejects with an error if it cannot be resolved.
     *
     * #### Notes
     * Services are singletons. The same instance will be returned each
     * time a given service token is resolved.
     *
     * If the plugin which provides the service has not been activated,
     * resolving the service will automatically activate the plugin.
     *
     * User code will not typically call this method directly. Instead,
     * the required services for the user's plugins will be resolved
     * automatically when the plugin is activated.
     */
    Application.prototype.resolveRequiredService = function (token) {
        // Reject the promise if there is no provider for the type.
        var id = this._serviceMap.get(token);
        if (!id) {
            return Promise.reject(new Error("No provider for: " + token.name + "."));
        }
        // Resolve immediately if the plugin is already activated.
        var data = this._pluginMap[id];
        if (data.activated) {
            return Promise.resolve(data.service);
        }
        // Otherwise, activate the plugin and wait on the results.
        return this.activatePlugin(id).then(function () { return data.service; });
    };
    /**
     * Resolve an optional service of a given type.
     *
     * @param token - The token for the service type of interest.
     *
     * @returns A promise which resolves to an instance of the requested
     *   service, or `null` if it cannot be resolved.
     *
     * #### Notes
     * Services are singletons. The same instance will be returned each
     * time a given service token is resolved.
     *
     * If the plugin which provides the service has not been activated,
     * resolving the service will automatically activate the plugin.
     *
     * User code will not typically call this method directly. Instead,
     * the optional services for the user's plugins will be resolved
     * automatically when the plugin is activated.
     */
    Application.prototype.resolveOptionalService = function (token) {
        // Resolve with `null` if there is no provider for the type.
        var id = this._serviceMap.get(token);
        if (!id) {
            return Promise.resolve(null);
        }
        // Resolve immediately if the plugin is already activated.
        var data = this._pluginMap[id];
        if (data.activated) {
            return Promise.resolve(data.service);
        }
        // Otherwise, activate the plugin and wait on the results.
        return this.activatePlugin(id).then(function () {
            return data.service;
        }).catch(function (reason) {
            console.error(reason);
            return null;
        });
    };
    /**
     * Start the application.
     *
     * @param options - The options for starting the application.
     *
     * @returns A promise which resolves when all bootstrapping work
     *   is complete and the shell is mounted to the DOM.
     *
     * #### Notes
     * This should be called once by the application creator after all
     * initial plugins have been registered.
     *
     * If a plugin fails to the load, the error will be logged and the
     * other valid plugins will continue to be loaded.
     *
     * Bootstrapping the application consists of the following steps:
     * 1. Activate the startup plugins
     * 2. Wait for those plugins to activate
     * 3. Attach the shell widget to the DOM
     * 4. Add the application event listeners
     */
    Application.prototype.start = function (options) {
        var _this = this;
        if (options === void 0) { options = {}; }
        // Return immediately if the application is already started.
        if (this._started) {
            return this._delegate.promise;
        }
        // Mark the application as started;
        this._started = true;
        // Parse the host id for attaching the shell.
        var hostID = options.hostID || '';
        // Collect the ids of the startup plugins.
        var startups = Private.collectStartupPlugins(this._pluginMap, options);
        // Generate the activation promises.
        var promises = startups.map(function (id) {
            return _this.activatePlugin(id).catch(function (error) {
                console.error("Plugin '" + id + "' failed to activate.");
                console.error(error);
            });
        });
        // Wait for the plugins to activate, then finalize startup.
        Promise.all(promises).then(function () {
            _this.attachShell(hostID);
            _this.addEventListeners();
            _this._delegate.resolve(undefined);
        });
        // Return the pending delegate promise.
        return this._delegate.promise;
    };
    /**
     * Handle the DOM events for the application.
     *
     * @param event - The DOM event sent to the application.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events registered for the application. It
     * should not be called directly by user code.
     */
    Application.prototype.handleEvent = function (event) {
        switch (event.type) {
            case 'resize':
                this.evtResize(event);
                break;
            case 'keydown':
                this.evtKeydown(event);
                break;
            case 'contextmenu':
                this.evtContextMenu(event);
                break;
        }
    };
    /**
     * Attach the application shell to the DOM.
     *
     * @param id - The id of the host node for the shell, or `''`.
     *
     * #### Notes
     * If the id is not provided, the document body will be the host.
     *
     * A subclass may reimplement this method as needed.
     */
    Application.prototype.attachShell = function (id) {
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget.attach(this.shell, (id && document.getElementById(id)) || document.body);
    };
    /**
     * Add the application event listeners.
     *
     * #### Notes
     * The default implementation of this method adds listeners for
     * `'keydown'` and `'resize'` events.
     *
     * A subclass may reimplement this method as needed.
     */
    Application.prototype.addEventListeners = function () {
        document.addEventListener('contextmenu', this);
        document.addEventListener('keydown', this, true);
        window.addEventListener('resize', this);
    };
    /**
     * A method invoked on a document `'keydown'` event.
     *
     * #### Notes
     * The default implementation of this method invokes the key down
     * processing method of the application command registry.
     *
     * A subclass may reimplement this method as needed.
     */
    Application.prototype.evtKeydown = function (event) {
        this.commands.processKeydownEvent(event);
    };
    /**
     * A method invoked on a document `'contextmenu'` event.
     *
     * #### Notes
     * The default implementation of this method opens the application
     * `contextMenu` at the current mouse position.
     *
     * If the application context menu has no matching content *or* if
     * the shift key is pressed, the default browser context menu will
     * be opened instead.
     *
     * A subclass may reimplement this method as needed.
     */
    Application.prototype.evtContextMenu = function (event) {
        if (event.shiftKey) {
            return;
        }
        if (this.contextMenu.open(event)) {
            event.preventDefault();
            event.stopPropagation();
        }
    };
    /**
     * A method invoked on a window `'resize'` event.
     *
     * #### Notes
     * The default implementation of this method updates the shell.
     *
     * A subclass may reimplement this method as needed.
     */
    Application.prototype.evtResize = function (event) {
        this.shell.update();
    };
    return Application;
}());
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * Create a new plugin map.
     */
    function createPluginMap() {
        return Object.create(null);
    }
    Private.createPluginMap = createPluginMap;
    /**
     * Create a new service map.
     */
    function createServiceMap() {
        return new Map();
    }
    Private.createServiceMap = createServiceMap;
    /**
     * Create a normalized plugin data object for the given plugin.
     */
    function createPluginData(plugin) {
        return {
            id: plugin.id,
            service: null,
            promise: null,
            activated: false,
            activate: plugin.activate,
            provides: plugin.provides || null,
            autoStart: plugin.autoStart || false,
            requires: plugin.requires ? plugin.requires.slice() : [],
            optional: plugin.optional ? plugin.optional.slice() : []
        };
    }
    Private.createPluginData = createPluginData;
    /**
     * Ensure no cycle is present in the plugin resolution graph.
     *
     * If a cycle is detected, an error will be thrown.
     */
    function ensureNoCycle(data, pluginMap, serviceMap) {
        var dependencies = data.requires.concat(data.optional);
        // Bail early if there cannot be a cycle.
        if (!data.provides || dependencies.length === 0) {
            return;
        }
        // Setup a stack to trace service resolution.
        var trace = [data.id];
        // Throw an exception if a cycle is present.
        if (dependencies.some(visit)) {
            throw new Error("Cycle detected: " + trace.join(' -> ') + ".");
        }
        function visit(token) {
            if (token === data.provides) {
                return true;
            }
            var id = serviceMap.get(token);
            if (!id) {
                return false;
            }
            var other = pluginMap[id];
            var otherDependencies = other.requires.concat(other.optional);
            if (otherDependencies.length === 0) {
                return false;
            }
            trace.push(id);
            if (otherDependencies.some(visit)) {
                return true;
            }
            trace.pop();
            return false;
        }
    }
    Private.ensureNoCycle = ensureNoCycle;
    /**
     * Collect the IDs of the plugins to activate on startup.
     */
    function collectStartupPlugins(pluginMap, options) {
        // Create a map to hold the plugin IDs.
        var resultMap = Object.create(null);
        // Collect the auto-start plugins.
        for (var id in pluginMap) {
            if (pluginMap[id].autoStart) {
                resultMap[id] = true;
            }
        }
        // Add the startup plugins.
        if (options.startPlugins) {
            for (var _i = 0, _a = options.startPlugins; _i < _a.length; _i++) {
                var id = _a[_i];
                resultMap[id] = true;
            }
        }
        // Remove the ignored plugins.
        if (options.ignorePlugins) {
            for (var _b = 0, _c = options.ignorePlugins; _b < _c.length; _b++) {
                var id = _c[_b];
                delete resultMap[id];
            }
        }
        // Return the final startup plugins.
        return Object.keys(resultMap);
    }
    Private.collectStartupPlugins = collectStartupPlugins;
})(Private || (Private = {}));


//# sourceMappingURL=index.es6.js.map


/***/ }),

/***/ "../../node_modules/@lumino/properties/dist/index.es6.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@lumino/properties/dist/index.es6.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AttachedProperty": () => (/* binding */ AttachedProperty)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * A class which attaches a value to an external object.
 *
 * #### Notes
 * Attached properties are used to extend the state of an object with
 * semantic data from an unrelated class. They also encapsulate value
 * creation, coercion, and notification.
 *
 * Because attached property values are stored in a hash table, which
 * in turn is stored in a WeakMap keyed on the owner object, there is
 * non-trivial storage overhead involved in their use. The pattern is
 * therefore best used for the storage of rare data.
 */
var AttachedProperty = /** @class */ (function () {
    /**
     * Construct a new attached property.
     *
     * @param options - The options for initializing the property.
     */
    function AttachedProperty(options) {
        this._pid = Private.nextPID();
        this.name = options.name;
        this._create = options.create;
        this._coerce = options.coerce || null;
        this._compare = options.compare || null;
        this._changed = options.changed || null;
    }
    /**
     * Get the current value of the property for a given owner.
     *
     * @param owner - The property owner of interest.
     *
     * @returns The current value of the property.
     *
     * #### Notes
     * If the value has not yet been set, the default value will be
     * computed and assigned as the current value of the property.
     */
    AttachedProperty.prototype.get = function (owner) {
        var value;
        var map = Private.ensureMap(owner);
        if (this._pid in map) {
            value = map[this._pid];
        }
        else {
            value = map[this._pid] = this._createValue(owner);
        }
        return value;
    };
    /**
     * Set the current value of the property for a given owner.
     *
     * @param owner - The property owner of interest.
     *
     * @param value - The value for the property.
     *
     * #### Notes
     * If the value has not yet been set, the default value will be
     * computed and used as the previous value for the comparison.
     */
    AttachedProperty.prototype.set = function (owner, value) {
        var oldValue;
        var map = Private.ensureMap(owner);
        if (this._pid in map) {
            oldValue = map[this._pid];
        }
        else {
            oldValue = map[this._pid] = this._createValue(owner);
        }
        var newValue = this._coerceValue(owner, value);
        this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
    };
    /**
     * Explicitly coerce the current property value for a given owner.
     *
     * @param owner - The property owner of interest.
     *
     * #### Notes
     * If the value has not yet been set, the default value will be
     * computed and used as the previous value for the comparison.
     */
    AttachedProperty.prototype.coerce = function (owner) {
        var oldValue;
        var map = Private.ensureMap(owner);
        if (this._pid in map) {
            oldValue = map[this._pid];
        }
        else {
            oldValue = map[this._pid] = this._createValue(owner);
        }
        var newValue = this._coerceValue(owner, oldValue);
        this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
    };
    /**
     * Get or create the default value for the given owner.
     */
    AttachedProperty.prototype._createValue = function (owner) {
        var create = this._create;
        return create(owner);
    };
    /**
     * Coerce the value for the given owner.
     */
    AttachedProperty.prototype._coerceValue = function (owner, value) {
        var coerce = this._coerce;
        return coerce ? coerce(owner, value) : value;
    };
    /**
     * Compare the old value and new value for equality.
     */
    AttachedProperty.prototype._compareValue = function (oldValue, newValue) {
        var compare = this._compare;
        return compare ? compare(oldValue, newValue) : oldValue === newValue;
    };
    /**
     * Run the change notification if the given values are different.
     */
    AttachedProperty.prototype._maybeNotify = function (owner, oldValue, newValue) {
        var changed = this._changed;
        if (changed && !this._compareValue(oldValue, newValue)) {
            changed(owner, oldValue, newValue);
        }
    };
    return AttachedProperty;
}());
/**
 * The namespace for the `AttachedProperty` class statics.
 */
(function (AttachedProperty) {
    /**
     * Clear the stored property data for the given owner.
     *
     * @param owner - The property owner of interest.
     *
     * #### Notes
     * This will clear all property values for the owner, but it will
     * **not** run the change notification for any of the properties.
     */
    function clearData(owner) {
        Private.ownerData.delete(owner);
    }
    AttachedProperty.clearData = clearData;
})(AttachedProperty || (AttachedProperty = {}));
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
    /**
     * A weak mapping of property owner to property map.
     */
    Private.ownerData = new WeakMap();
    /**
     * A function which computes successive unique property ids.
     */
    Private.nextPID = (function () {
        var id = 0;
        return function () {
            var rand = Math.random();
            var stem = ("" + rand).slice(2);
            return "pid-" + stem + "-" + id++;
        };
    })();
    /**
     * Lookup the data map for the property owner.
     *
     * This will create the map if one does not already exist.
     */
    function ensureMap(owner) {
        var map = Private.ownerData.get(owner);
        if (map) {
            return map;
        }
        map = Object.create(null);
        Private.ownerData.set(owner, map);
        return map;
    }
    Private.ensureMap = ensureMap;
})(Private || (Private = {}));


//# sourceMappingURL=index.es6.js.map


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_jupyterlab_application_lib_index_js.bundle.js.map