(self["webpackChunk_quetz_frontend_app"] = self["webpackChunk_quetz_frontend_app"] || []).push([["vendors-node_modules_jupyterlab_statusbar_lib_index_js"],{

/***/ "../../node_modules/@jupyterlab/statusbar/lib/components/group.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/components/group.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GroupItem": () => (/* binding */ GroupItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
/* harmony import */ var _style_layout__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../style/layout */ "../../node_modules/@jupyterlab/statusbar/lib/style/layout.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};



const groupItemLayout = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(_style_layout__WEBPACK_IMPORTED_MODULE_2__.centeredFlex, _style_layout__WEBPACK_IMPORTED_MODULE_2__.leftToRight);
/**
 * A tsx component for a set of items logically grouped together.
 */
function GroupItem(props) {
    const { spacing, children, className } = props, rest = __rest(props, ["spacing", "children", "className"]);
    const numChildren = react__WEBPACK_IMPORTED_MODULE_0__.Children.count(children);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ className: (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.classes)(groupItemLayout, className) }, rest), react__WEBPACK_IMPORTED_MODULE_0__.Children.map(children, (child, i) => {
        if (i === 0) {
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginRight: `${spacing}px` } }, child);
        }
        else if (i === numChildren - 1) {
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { marginLeft: `${spacing}px` } }, child);
        }
        else {
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { style: { margin: `0px ${spacing}px` } }, child);
        }
    })));
}
//# sourceMappingURL=group.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/components/hover.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/components/hover.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "showPopup": () => (/* binding */ showPopup),
/* harmony export */   "Popup": () => (/* binding */ Popup)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
/* harmony import */ var _style_statusbar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../style/statusbar */ "../../node_modules/@jupyterlab/statusbar/lib/style/statusbar.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




const hoverItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_2__.style)({
    boxShadow: '0px 4px 4px rgba(0, 0, 0, 0.25)'
});
/**
 * Create and show a popup component.
 *
 * @param options - options for the popup
 *
 * @returns the popup that was created.
 */
function showPopup(options) {
    const dialog = new Popup(options);
    dialog.launch();
    return dialog;
}
/**
 * A class for a Popup widget.
 */
class Popup extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {
    /**
     * Construct a new Popup.
     */
    constructor(options) {
        super();
        this._body = options.body;
        this._body.addClass(hoverItem);
        this._anchor = options.anchor;
        this._align = options.align;
        const layout = (this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.PanelLayout());
        layout.addWidget(options.body);
        this._body.node.addEventListener('resize', () => {
            this.update();
        });
    }
    /**
     * Attach the popup widget to the page.
     */
    launch() {
        this._setGeometry();
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget.attach(this, document.body);
        this.update();
        this._anchor.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.clickedItem);
        this._anchor.removeClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.interactiveItem);
    }
    /**
     * Handle `'update'` messages for the widget.
     */
    onUpdateRequest(msg) {
        this._setGeometry();
        super.onUpdateRequest(msg);
    }
    /**
     * Handle `'after-attach'` messages for the widget.
     */
    onAfterAttach(msg) {
        document.addEventListener('click', this, false);
        this.node.addEventListener('keydown', this, false);
        window.addEventListener('resize', this, false);
    }
    /**
     * Handle `'after-detach'` messages for the widget.
     */
    onAfterDetach(msg) {
        document.removeEventListener('click', this, false);
        this.node.removeEventListener('keydown', this, false);
        window.removeEventListener('resize', this, false);
    }
    /**
     * Handle `'resize'` messages for the widget.
     */
    onResize() {
        this.update();
    }
    /**
     * Dispose of the widget.
     */
    dispose() {
        super.dispose();
        this._anchor.removeClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.clickedItem);
        this._anchor.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.interactiveItem);
    }
    /**
     * Handle DOM events for the widget.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'click':
                this._evtClick(event);
                break;
            case 'resize':
                this.onResize();
                break;
            default:
                break;
        }
    }
    _evtClick(event) {
        if (!!event.target &&
            !(this._body.node.contains(event.target) ||
                this._anchor.node.contains(event.target))) {
            this.dispose();
        }
    }
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                this.dispose();
                break;
            default:
                break;
        }
    }
    _setGeometry() {
        let aligned = 0;
        const anchorRect = this._anchor.node.getBoundingClientRect();
        const bodyRect = this._body.node.getBoundingClientRect();
        if (this._align === 'right') {
            aligned = -(bodyRect.width - anchorRect.width);
        }
        const style = window.getComputedStyle(this._body.node);
        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.HoverBox.setGeometry({
            anchor: anchorRect,
            host: document.body,
            maxHeight: 500,
            minHeight: 20,
            node: this._body.node,
            offset: {
                horizontal: aligned
            },
            privilege: 'forceAbove',
            style
        });
    }
}
//# sourceMappingURL=hover.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/components/index.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/components/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProgressBar": () => (/* reexport safe */ _progressBar__WEBPACK_IMPORTED_MODULE_0__.ProgressBar),
/* harmony export */   "TextItem": () => (/* reexport safe */ _text__WEBPACK_IMPORTED_MODULE_1__.TextItem),
/* harmony export */   "GroupItem": () => (/* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_2__.GroupItem),
/* harmony export */   "Popup": () => (/* reexport safe */ _hover__WEBPACK_IMPORTED_MODULE_3__.Popup),
/* harmony export */   "showPopup": () => (/* reexport safe */ _hover__WEBPACK_IMPORTED_MODULE_3__.showPopup)
/* harmony export */ });
/* harmony import */ var _progressBar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./progressBar */ "../../node_modules/@jupyterlab/statusbar/lib/components/progressBar.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text */ "../../node_modules/@jupyterlab/statusbar/lib/components/text.js");
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./group */ "../../node_modules/@jupyterlab/statusbar/lib/components/group.js");
/* harmony import */ var _hover__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./hover */ "../../node_modules/@jupyterlab/statusbar/lib/components/hover.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/components/progressBar.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/components/progressBar.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProgressBar": () => (/* binding */ ProgressBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _style_progressBar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../style/progressBar */ "../../node_modules/@jupyterlab/statusbar/lib/style/progressBar.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * A functional tsx component for a progress bar.
 */
function ProgressBar(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _style_progressBar__WEBPACK_IMPORTED_MODULE_1__.progressBarItem },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(Filler, { percentage: props.percentage })));
}
/**
 * A functional tsx component for a partially filled div.
 */
function Filler(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { className: _style_progressBar__WEBPACK_IMPORTED_MODULE_1__.fillerItem, style: {
            width: `${props.percentage}px`
        } }));
}
//# sourceMappingURL=progressBar.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/components/text.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/components/text.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TextItem": () => (/* binding */ TextItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
/* harmony import */ var _style_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../style/text */ "../../node_modules/@jupyterlab/statusbar/lib/style/text.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};



/**
 * A functional tsx component for a text item.
 */
function TextItem(props) {
    const { title, source, className } = props, rest = __rest(props, ["title", "source", "className"]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", Object.assign({ className: (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.classes)(_style_text__WEBPACK_IMPORTED_MODULE_2__.textItem, className), title: title }, rest), source));
}
//# sourceMappingURL=text.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/defaults/index.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/defaults/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LineCol": () => (/* reexport safe */ _lineCol__WEBPACK_IMPORTED_MODULE_0__.LineCol),
/* harmony export */   "KernelStatus": () => (/* reexport safe */ _kernelStatus__WEBPACK_IMPORTED_MODULE_1__.KernelStatus),
/* harmony export */   "RunningSessions": () => (/* reexport safe */ _runningSessions__WEBPACK_IMPORTED_MODULE_2__.RunningSessions)
/* harmony export */ });
/* harmony import */ var _lineCol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lineCol */ "../../node_modules/@jupyterlab/statusbar/lib/defaults/lineCol.js");
/* harmony import */ var _kernelStatus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./kernelStatus */ "../../node_modules/@jupyterlab/statusbar/lib/defaults/kernelStatus.js");
/* harmony import */ var _runningSessions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./runningSessions */ "../../node_modules/@jupyterlab/statusbar/lib/defaults/runningSessions.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/defaults/kernelStatus.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/defaults/kernelStatus.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KernelStatus": () => (/* binding */ KernelStatus)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/translation */ "webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! .. */ "../../node_modules/@jupyterlab/statusbar/lib/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * A pure functional component for rendering kernel status.
 */
function KernelStatusComponent(props) {
    const translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator;
    const trans = translator.load('jupyterlab');
    let statusText = '';
    if (props.status) {
        statusText = ` | ${_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.Text.titleCase(trans.__(props.status))}`;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.TextItem, { onClick: props.handleClick, source: `${props.kernelName}${statusText}`, title: trans.__('Change kernel for %1', props.activityName) }));
}
/**
 * A VDomRenderer widget for displaying the status of a kernel.
 */
class KernelStatus extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.VDomRenderer {
    /**
     * Construct the kernel status widget.
     */
    constructor(opts, translator) {
        super(new KernelStatus.Model(translator));
        this.translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator;
        this._handleClick = opts.onClick;
        this.addClass(___WEBPACK_IMPORTED_MODULE_4__.interactiveItem);
    }
    /**
     * Render the kernel status item.
     */
    render() {
        if (this.model === null) {
            return null;
        }
        else {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(KernelStatusComponent, { status: this.model.status, kernelName: this.model.kernelName, activityName: this.model.activityName, handleClick: this._handleClick, translator: this.translator }));
        }
    }
}
/**
 * A namespace for KernelStatus statics.
 */
(function (KernelStatus) {
    /**
     * A VDomModel for the kernel status indicator.
     */
    class Model extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.VDomModel {
        constructor(translator) {
            super();
            /**
             * React to changes to the kernel status.
             */
            this._onKernelStatusChanged = () => {
                var _a;
                this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
                this.stateChanged.emit(void 0);
            };
            /**
             * React to changes in the kernel.
             */
            this._onKernelChanged = (_sessionContext, change) => {
                var _a;
                const oldState = this._getAllState();
                // sync setting of status and display name
                this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
                this._kernelName = _sessionContext.kernelDisplayName;
                this._triggerChange(oldState, this._getAllState());
            };
            this._activityName = 'activity'; // FIXME-TRANS:?
            this._kernelStatus = '';
            this._sessionContext = null;
            translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator;
            this._trans = translator.load('jupyterlab');
            this._kernelName = this._trans.__('No Kernel!');
        }
        /**
         * The name of the kernel.
         */
        get kernelName() {
            return this._kernelName;
        }
        /**
         * The current status of the kernel.
         */
        get status() {
            return this._kernelStatus;
        }
        /**
         * A display name for the activity.
         */
        get activityName() {
            return this._activityName;
        }
        set activityName(val) {
            const oldVal = this._activityName;
            if (oldVal === val) {
                return;
            }
            this._activityName = val;
            this.stateChanged.emit(void 0);
        }
        /**
         * The current client session associated with the kernel status indicator.
         */
        get sessionContext() {
            return this._sessionContext;
        }
        set sessionContext(sessionContext) {
            var _a, _b, _c;
            (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.statusChanged.disconnect(this._onKernelStatusChanged);
            (_b = this._sessionContext) === null || _b === void 0 ? void 0 : _b.kernelChanged.disconnect(this._onKernelChanged);
            const oldState = this._getAllState();
            this._sessionContext = sessionContext;
            this._kernelStatus = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayStatus;
            this._kernelName = (_c = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName) !== null && _c !== void 0 ? _c : 'No Kernel'; // FIXME-TRANS: ?
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.statusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.connectionStatusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelChanged.connect(this._onKernelChanged, this);
            this._triggerChange(oldState, this._getAllState());
        }
        _getAllState() {
            return [this._kernelName, this._kernelStatus, this._activityName];
        }
        _triggerChange(oldState, newState) {
            if (_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.JSONExt.deepEqual(oldState, newState)) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    KernelStatus.Model = Model;
})(KernelStatus || (KernelStatus = {}));
//# sourceMappingURL=kernelStatus.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/defaults/lineCol.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/defaults/lineCol.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LineCol": () => (/* binding */ LineCol)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/translation */ "webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! .. */ "../../node_modules/@jupyterlab/statusbar/lib/index.js");
/* harmony import */ var _style_lineForm__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../style/lineForm */ "../../node_modules/@jupyterlab/statusbar/lib/style/lineForm.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







/**
 * A component for rendering a "go-to-line" form.
 */
class LineFormComponent extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    /**
     * Construct a new LineFormComponent.
     */
    constructor(props) {
        super(props);
        /**
         * Handle a change to the value in the input field.
         */
        this._handleChange = (event) => {
            this.setState({ value: event.currentTarget.value });
        };
        /**
         * Handle submission of the input field.
         */
        this._handleSubmit = (event) => {
            event.preventDefault();
            const value = parseInt(this._textInput.value, 10);
            if (!isNaN(value) &&
                isFinite(value) &&
                1 <= value &&
                value <= this.props.maxLine) {
                this.props.handleSubmit(value);
            }
            return false;
        };
        /**
         * Handle focusing of the input field.
         */
        this._handleFocus = () => {
            this.setState({ hasFocus: true });
        };
        /**
         * Handle blurring of the input field.
         */
        this._handleBlur = () => {
            this.setState({ hasFocus: false });
        };
        this._textInput = null;
        this.translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this.state = {
            value: '',
            hasFocus: false
        };
    }
    /**
     * Focus the element on mount.
     */
    componentDidMount() {
        this._textInput.focus();
    }
    /**
     * Render the LineFormComponent.
     */
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormSearch },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { name: "lineColumnForm", onSubmit: this._handleSubmit, noValidate: true },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_4__.classes)(_style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormWrapper, 'lm-lineForm-wrapper', this.state.hasFocus ? _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormWrapperFocusWithin : undefined) },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "text", className: _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormInput, onChange: this._handleChange, onFocus: this._handleFocus, onBlur: this._handleBlur, value: this.state.value, ref: input => {
                            this._textInput = input;
                        } }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormButtonDiv },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.lineFormIcon.react, { className: _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormButtonIcon, elementPosition: "center" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: "submit", className: _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormButton, value: "" }))),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", { className: _style_lineForm__WEBPACK_IMPORTED_MODULE_6__.lineFormCaption }, this._trans.__('Go to line number between 1 and %1', this.props.maxLine)))));
    }
}
/**
 * A pure functional component for rendering a line/column
 * status item.
 */
function LineColComponent(props) {
    const translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;
    const trans = translator.load('jupyterlab');
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_5__.TextItem, { onClick: props.handleClick, source: trans.__('Ln %1, Col %2', props.line, props.column), title: trans.__('Go to line number…') }));
}
/**
 * A widget implementing a line/column status item.
 */
class LineCol extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.VDomRenderer {
    /**
     * Construct a new LineCol status item.
     */
    constructor(translator) {
        super(new LineCol.Model());
        this._popup = null;
        this.addClass(___WEBPACK_IMPORTED_MODULE_5__.interactiveItem);
        this.translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;
    }
    /**
     * Render the status item.
     */
    render() {
        if (this.model === null) {
            return null;
        }
        else {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LineColComponent, { line: this.model.line, column: this.model.column, translator: this.translator, handleClick: () => this._handleClick() }));
        }
    }
    /**
     * A click handler for the widget.
     */
    _handleClick() {
        if (this._popup) {
            this._popup.dispose();
        }
        const body = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ReactWidget.create(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LineFormComponent, { handleSubmit: val => this._handleSubmit(val), currentLine: this.model.line, maxLine: this.model.editor.lineCount, translator: this.translator }));
        this._popup = (0,___WEBPACK_IMPORTED_MODULE_5__.showPopup)({
            body: body,
            anchor: this,
            align: 'right'
        });
    }
    /**
     * Handle submission for the widget.
     */
    _handleSubmit(value) {
        this.model.editor.setCursorPosition({ line: value - 1, column: 0 });
        this._popup.dispose();
        this.model.editor.focus();
    }
}
/**
 * A namespace for LineCol statics.
 */
(function (LineCol) {
    /**
     * A VDom model for a status item tracking the line/column of an editor.
     */
    class Model extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.VDomModel {
        constructor() {
            super(...arguments);
            /**
             * React to a change in the cursors of the current editor.
             */
            this._onSelectionChanged = () => {
                const oldState = this._getAllState();
                const pos = this.editor.getCursorPosition();
                this._line = pos.line + 1;
                this._column = pos.column + 1;
                this._triggerChange(oldState, this._getAllState());
            };
            this._line = 1;
            this._column = 1;
            this._editor = null;
        }
        /**
         * The current editor of the model.
         */
        get editor() {
            return this._editor;
        }
        set editor(editor) {
            const oldEditor = this._editor;
            if (oldEditor) {
                oldEditor.model.selections.changed.disconnect(this._onSelectionChanged);
            }
            const oldState = this._getAllState();
            this._editor = editor;
            if (!this._editor) {
                this._column = 1;
                this._line = 1;
            }
            else {
                this._editor.model.selections.changed.connect(this._onSelectionChanged);
                const pos = this._editor.getCursorPosition();
                this._column = pos.column + 1;
                this._line = pos.line + 1;
            }
            this._triggerChange(oldState, this._getAllState());
        }
        /**
         * The current line of the model.
         */
        get line() {
            return this._line;
        }
        /**
         * The current column of the model.
         */
        get column() {
            return this._column;
        }
        _getAllState() {
            return [this._line, this._column];
        }
        _triggerChange(oldState, newState) {
            if (oldState[0] !== newState[0] || oldState[1] !== newState[1]) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    LineCol.Model = Model;
})(LineCol || (LineCol = {}));
//# sourceMappingURL=lineCol.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/defaults/runningSessions.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/defaults/runningSessions.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RunningSessions": () => (/* binding */ RunningSessions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/translation */ "webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! .. */ "../../node_modules/@jupyterlab/statusbar/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * Half spacing between subitems in a status item.
 */
const HALF_SPACING = 4;
/**
 * A pure functional component for rendering kernel and terminal sessions.
 *
 * @param props: the props for the component.
 *
 * @returns a tsx component for the running sessions.
 */
function RunningSessionsComponent(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.GroupItem, { spacing: HALF_SPACING, onClick: props.handleClick },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.GroupItem, { spacing: HALF_SPACING },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.TextItem, { source: props.terminals }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.terminalIcon.react, { left: '1px', top: '3px', stylesheet: 'statusBar' })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.GroupItem, { spacing: HALF_SPACING },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(___WEBPACK_IMPORTED_MODULE_4__.TextItem, { source: props.sessions }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.kernelIcon.react, { top: '2px', stylesheet: 'statusBar' }))));
}
/**
 * A VDomRenderer for a RunningSessions status item.
 */
class RunningSessions extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.VDomRenderer {
    /**
     * Create a new RunningSessions widget.
     */
    constructor(opts) {
        super(new RunningSessions.Model());
        this._serviceManager = opts.serviceManager;
        this._handleClick = opts.onClick;
        this.translator = opts.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;
        this._trans = this.translator.load('jupyterload');
        this._serviceManager.sessions.runningChanged.connect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.connect(this._onTerminalsRunningChanged, this);
        this.addClass(___WEBPACK_IMPORTED_MODULE_4__.interactiveItem);
    }
    /**
     * Render the running sessions widget.
     */
    render() {
        if (!this.model) {
            return null;
        }
        // TODO-TRANS: Should probably be handled differently.
        // This is more localizable friendly: "Terminals: %1 | Kernels: %2"
        this.title.caption = this._trans.__('%1 Terminals, %2 Kernel sessions', this.model.terminals, this.model.sessions);
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(RunningSessionsComponent, { sessions: this.model.sessions, terminals: this.model.terminals, handleClick: this._handleClick }));
    }
    /**
     * Dispose of the status item.
     */
    dispose() {
        super.dispose();
        this._serviceManager.sessions.runningChanged.disconnect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.disconnect(this._onTerminalsRunningChanged, this);
    }
    /**
     * Set the number of kernel sessions when the list changes.
     */
    _onSessionsRunningChanged(manager, sessions) {
        this.model.sessions = sessions.length;
    }
    /**
     * Set the number of terminal sessions when the list changes.
     */
    _onTerminalsRunningChanged(manager, terminals) {
        this.model.terminals = terminals.length;
    }
}
/**
 * A namespace for RunninSessions statics.
 */
(function (RunningSessions) {
    /**
     * A VDomModel for the RunninSessions status item.
     */
    class Model extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.VDomModel {
        constructor() {
            super(...arguments);
            this._terminals = 0;
            this._sessions = 0;
        }
        /**
         * The number of active kernel sessions.
         */
        get sessions() {
            return this._sessions;
        }
        set sessions(sessions) {
            const oldSessions = this._sessions;
            this._sessions = sessions;
            if (oldSessions !== this._sessions) {
                this.stateChanged.emit(void 0);
            }
        }
        /**
         * The number of active terminal sessions.
         */
        get terminals() {
            return this._terminals;
        }
        set terminals(terminals) {
            const oldTerminals = this._terminals;
            this._terminals = terminals;
            if (oldTerminals !== this._terminals) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    RunningSessions.Model = Model;
})(RunningSessions || (RunningSessions = {}));
//# sourceMappingURL=runningSessions.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/index.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GroupItem": () => (/* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_0__.GroupItem),
/* harmony export */   "Popup": () => (/* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_0__.Popup),
/* harmony export */   "ProgressBar": () => (/* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_0__.ProgressBar),
/* harmony export */   "TextItem": () => (/* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_0__.TextItem),
/* harmony export */   "showPopup": () => (/* reexport safe */ _components__WEBPACK_IMPORTED_MODULE_0__.showPopup),
/* harmony export */   "KernelStatus": () => (/* reexport safe */ _defaults__WEBPACK_IMPORTED_MODULE_1__.KernelStatus),
/* harmony export */   "LineCol": () => (/* reexport safe */ _defaults__WEBPACK_IMPORTED_MODULE_1__.LineCol),
/* harmony export */   "RunningSessions": () => (/* reexport safe */ _defaults__WEBPACK_IMPORTED_MODULE_1__.RunningSessions),
/* harmony export */   "clickedItem": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.clickedItem),
/* harmony export */   "interactiveItem": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.interactiveItem),
/* harmony export */   "item": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.item),
/* harmony export */   "leftSide": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.leftSide),
/* harmony export */   "rightSide": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.rightSide),
/* harmony export */   "side": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.side),
/* harmony export */   "statusBar": () => (/* reexport safe */ _style_statusbar__WEBPACK_IMPORTED_MODULE_2__.statusBar),
/* harmony export */   "StatusBar": () => (/* reexport safe */ _statusbar__WEBPACK_IMPORTED_MODULE_3__.StatusBar),
/* harmony export */   "IStatusBar": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_4__.IStatusBar)
/* harmony export */ });
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components */ "../../node_modules/@jupyterlab/statusbar/lib/components/index.js");
/* harmony import */ var _defaults__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./defaults */ "../../node_modules/@jupyterlab/statusbar/lib/defaults/index.js");
/* harmony import */ var _style_statusbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style/statusbar */ "../../node_modules/@jupyterlab/statusbar/lib/style/statusbar.js");
/* harmony import */ var _statusbar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./statusbar */ "../../node_modules/@jupyterlab/statusbar/lib/statusbar.js");
/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./tokens */ "../../node_modules/@jupyterlab/statusbar/lib/tokens.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module statusbar
 */





//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/statusbar.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/statusbar.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StatusBar": () => (/* binding */ StatusBar)
/* harmony export */ });
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/disposable */ "webpack/sharing/consume/default/@lumino/disposable/@lumino/disposable");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _style_statusbar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style/statusbar */ "../../node_modules/@jupyterlab/statusbar/lib/style/statusbar.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * Main status bar object which contains all items.
 */
class StatusBar extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {
    constructor() {
        super();
        this._leftRankItems = [];
        this._rightRankItems = [];
        this._statusItems = {};
        this._disposables = new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableSet();
        this.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.statusBar);
        const rootLayout = (this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.PanelLayout());
        const leftPanel = (this._leftSide = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Panel());
        const middlePanel = (this._middlePanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Panel());
        const rightPanel = (this._rightSide = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Panel());
        leftPanel.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.side);
        leftPanel.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.leftSide);
        middlePanel.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.side);
        rightPanel.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.side);
        rightPanel.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.rightSide);
        rootLayout.addWidget(leftPanel);
        rootLayout.addWidget(middlePanel);
        rootLayout.addWidget(rightPanel);
    }
    /**
     * Register a new status item.
     *
     * @param id - a unique id for the status item.
     *
     * @param statusItem - The item to add to the status bar.
     */
    registerStatusItem(id, statusItem) {
        if (id in this._statusItems) {
            throw new Error(`Status item ${id} already registered.`);
        }
        // Populate defaults for the optional properties of the status item.
        const fullStatusItem = Object.assign(Object.assign({}, Private.statusItemDefaults), statusItem);
        const { align, item, rank } = fullStatusItem;
        // Connect the activeStateChanged signal to refreshing the status item,
        // if the signal was provided.
        const onActiveStateChanged = () => {
            this._refreshItem(id);
        };
        if (fullStatusItem.activeStateChanged) {
            fullStatusItem.activeStateChanged.connect(onActiveStateChanged);
        }
        const rankItem = { id, rank };
        fullStatusItem.item.addClass(_style_statusbar__WEBPACK_IMPORTED_MODULE_3__.item);
        this._statusItems[id] = fullStatusItem;
        if (align === 'left') {
            const insertIndex = this._findInsertIndex(this._leftRankItems, rankItem);
            if (insertIndex === -1) {
                this._leftSide.addWidget(item);
                this._leftRankItems.push(rankItem);
            }
            else {
                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(this._leftRankItems, insertIndex, rankItem);
                this._leftSide.insertWidget(insertIndex, item);
            }
        }
        else if (align === 'right') {
            const insertIndex = this._findInsertIndex(this._rightRankItems, rankItem);
            if (insertIndex === -1) {
                this._rightSide.addWidget(item);
                this._rightRankItems.push(rankItem);
            }
            else {
                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(this._rightRankItems, insertIndex, rankItem);
                this._rightSide.insertWidget(insertIndex, item);
            }
        }
        else {
            this._middlePanel.addWidget(item);
        }
        this._refreshItem(id); // Initially refresh the status item.
        const disposable = new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableDelegate(() => {
            delete this._statusItems[id];
            if (fullStatusItem.activeStateChanged) {
                fullStatusItem.activeStateChanged.disconnect(onActiveStateChanged);
            }
            item.parent = null;
            item.dispose();
        });
        this._disposables.add(disposable);
        return disposable;
    }
    /**
     * Dispose of the status bar.
     */
    dispose() {
        this._leftRankItems.length = 0;
        this._rightRankItems.length = 0;
        this._disposables.dispose();
        super.dispose();
    }
    /**
     * Handle an 'update-request' message to the status bar.
     */
    onUpdateRequest(msg) {
        this._refreshAll();
        super.onUpdateRequest(msg);
    }
    _findInsertIndex(side, newItem) {
        return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(side, item => item.rank > newItem.rank);
    }
    _refreshItem(id) {
        const statusItem = this._statusItems[id];
        if (statusItem.isActive()) {
            statusItem.item.show();
            statusItem.item.update();
        }
        else {
            statusItem.item.hide();
        }
    }
    _refreshAll() {
        Object.keys(this._statusItems).forEach(id => {
            this._refreshItem(id);
        });
    }
}
/**
 * A namespace for private functionality.
 */
var Private;
(function (Private) {
    /**
     * Default options for a status item, less the item itself.
     */
    Private.statusItemDefaults = {
        align: 'left',
        rank: 0,
        isActive: () => true,
        activeStateChanged: undefined
    };
})(Private || (Private = {}));
//# sourceMappingURL=statusbar.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/style/layout.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/style/layout.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "centeredFlex": () => (/* binding */ centeredFlex),
/* harmony export */   "leftToRight": () => (/* binding */ leftToRight),
/* harmony export */   "rightToLeft": () => (/* binding */ rightToLeft),
/* harmony export */   "equiDistant": () => (/* binding */ equiDistant)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
const centeredFlex = {
    display: 'flex',
    alignItems: 'center'
};
const leftToRight = {
    flexDirection: 'row'
};
const rightToLeft = {
    flexDirection: 'row-reverse'
};
const equiDistant = {
    justifyContent: 'space-between'
};
//# sourceMappingURL=layout.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/style/lineForm.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/style/lineForm.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hoverItem": () => (/* binding */ hoverItem),
/* harmony export */   "lineFormSearch": () => (/* binding */ lineFormSearch),
/* harmony export */   "lineFormCaption": () => (/* binding */ lineFormCaption),
/* harmony export */   "baseLineForm": () => (/* binding */ baseLineForm),
/* harmony export */   "lineFormButtonDiv": () => (/* binding */ lineFormButtonDiv),
/* harmony export */   "lineFormButtonIcon": () => (/* binding */ lineFormButtonIcon),
/* harmony export */   "lineFormButton": () => (/* binding */ lineFormButton),
/* harmony export */   "lineFormWrapper": () => (/* binding */ lineFormWrapper),
/* harmony export */   "lineFormWrapperFocusWithin": () => (/* binding */ lineFormWrapperFocusWithin),
/* harmony export */   "lineFormInput": () => (/* binding */ lineFormInput)
/* harmony export */ });
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

const hoverItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    boxShadow: '0px 4px 4px rgba(0, 0, 0, 0.25)'
});
const lineFormSearch = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    padding: '4px 12px',
    backgroundColor: 'var(--jp-layout-color2)',
    boxShadow: 'var(--jp-toolbar-box-shadow)',
    zIndex: 2,
    fontSize: 'var(--jp-ui-font-size1)'
});
const lineFormCaption = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    fontSize: 'var(--jp-ui-font-size0)',
    lineHeight: 'var(--jp-ui-font-size1)',
    marginTop: '4px',
    color: 'var(--jp-ui-font-color0)'
});
const baseLineForm = {
    border: 'none',
    borderRadius: '0px',
    position: 'absolute',
    backgroundSize: '16px',
    backgroundRepeat: 'no-repeat',
    backgroundPosition: 'center',
    outline: 'none',
    top: '0px',
    right: '0px'
};
const lineFormButtonDiv = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)(baseLineForm, {
    top: '4px',
    right: '8px',
    height: '24px',
    padding: '0px 12px',
    width: '12px'
});
const lineFormButtonIcon = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)(baseLineForm, {
    backgroundColor: 'var(--jp-brand-color1)',
    height: '100%',
    width: '100%',
    boxSizing: 'border-box',
    padding: '4px 6px'
});
const lineFormButton = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)(baseLineForm, {
    backgroundColor: 'transparent',
    height: '100%',
    width: '100%',
    boxSizing: 'border-box'
});
const lineFormWrapper = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    overflow: 'hidden',
    padding: '0px 8px',
    border: '1px solid var(--jp-border-color0)',
    backgroundColor: 'var(--jp-input-active-background)',
    height: '22px'
});
const lineFormWrapperFocusWithin = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    border: 'var(--jp-border-width) solid var(--md-blue-500)',
    boxShadow: 'inset 0 0 4px var(--md-blue-300)'
});
const lineFormInput = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    background: 'transparent',
    width: '200px',
    height: '100%',
    border: 'none',
    outline: 'none',
    color: 'var(--jp-ui-font-color0)',
    lineHeight: '28px'
});
//# sourceMappingURL=lineForm.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/style/progressBar.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/style/progressBar.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "progressBarItem": () => (/* binding */ progressBarItem),
/* harmony export */   "fillerItem": () => (/* binding */ fillerItem)
/* harmony export */ });
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

const progressBarItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    background: 'black',
    height: '10px',
    width: '100px',
    border: '1px solid black',
    borderRadius: '3px',
    marginLeft: '4px',
    overflow: 'hidden'
});
const fillerItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
    background: 'var(--jp-brand-color2)',
    height: '10px'
});
//# sourceMappingURL=progressBar.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/style/statusbar.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/style/statusbar.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "statusBar": () => (/* binding */ statusBar),
/* harmony export */   "side": () => (/* binding */ side),
/* harmony export */   "leftSide": () => (/* binding */ leftSide),
/* harmony export */   "rightSide": () => (/* binding */ rightSide),
/* harmony export */   "item": () => (/* binding */ item),
/* harmony export */   "clickedItem": () => (/* binding */ clickedItem),
/* harmony export */   "interactiveItem": () => (/* binding */ interactiveItem)
/* harmony export */ });
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./text */ "../../node_modules/@jupyterlab/statusbar/lib/style/text.js");
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
/* harmony import */ var _variables__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./variables */ "../../node_modules/@jupyterlab/statusbar/lib/style/variables.js");
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./layout */ "../../node_modules/@jupyterlab/statusbar/lib/style/layout.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




const itemPadding = {
    paddingLeft: _variables__WEBPACK_IMPORTED_MODULE_2__.default.itemPadding,
    paddingRight: _variables__WEBPACK_IMPORTED_MODULE_2__.default.itemPadding
};
const interactiveHover = {
    $nest: {
        '&:hover': {
            backgroundColor: _variables__WEBPACK_IMPORTED_MODULE_2__.default.hoverColor
        }
    }
};
const clicked = {
    backgroundColor: _variables__WEBPACK_IMPORTED_MODULE_2__.default.clickColor,
    $nest: {
        ['.' + _text__WEBPACK_IMPORTED_MODULE_0__.textItem]: {
            color: _variables__WEBPACK_IMPORTED_MODULE_2__.default.textClickColor
        }
    }
};
const statusBar = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)({
    background: _variables__WEBPACK_IMPORTED_MODULE_2__.default.backgroundColor,
    minHeight: _variables__WEBPACK_IMPORTED_MODULE_2__.default.height,
    justifyContent: 'space-between',
    paddingLeft: _variables__WEBPACK_IMPORTED_MODULE_2__.default.statusBarPadding,
    paddingRight: _variables__WEBPACK_IMPORTED_MODULE_2__.default.statusBarPadding
}, _layout__WEBPACK_IMPORTED_MODULE_3__.centeredFlex);
const side = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(_layout__WEBPACK_IMPORTED_MODULE_3__.centeredFlex);
const leftSide = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(_layout__WEBPACK_IMPORTED_MODULE_3__.leftToRight);
const rightSide = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(_layout__WEBPACK_IMPORTED_MODULE_3__.rightToLeft);
const item = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)({
    maxHeight: _variables__WEBPACK_IMPORTED_MODULE_2__.default.height,
    marginLeft: _variables__WEBPACK_IMPORTED_MODULE_2__.default.itemMargin,
    marginRight: _variables__WEBPACK_IMPORTED_MODULE_2__.default.itemMargin,
    height: _variables__WEBPACK_IMPORTED_MODULE_2__.default.height,
    whiteSpace: _variables__WEBPACK_IMPORTED_MODULE_2__.default.whiteSpace,
    textOverflow: _variables__WEBPACK_IMPORTED_MODULE_2__.default.textOverflow,
    color: _variables__WEBPACK_IMPORTED_MODULE_2__.default.textColor
}, itemPadding);
const clickedItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(clicked);
const interactiveItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(interactiveHover);
//# sourceMappingURL=statusbar.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/style/text.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/style/text.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "baseText": () => (/* binding */ baseText),
/* harmony export */   "textItem": () => (/* binding */ textItem)
/* harmony export */ });
/* harmony import */ var _variables__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./variables */ "../../node_modules/@jupyterlab/statusbar/lib/style/variables.js");
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


const baseText = {
    fontSize: _variables__WEBPACK_IMPORTED_MODULE_0__.default.fontSize,
    fontFamily: _variables__WEBPACK_IMPORTED_MODULE_0__.default.fontFamily
};
const textItem = (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_1__.style)(baseText, {
    lineHeight: '24px',
    color: _variables__WEBPACK_IMPORTED_MODULE_0__.default.textColor
});
//# sourceMappingURL=text.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/style/variables.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/style/variables.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    hoverColor: 'var(--jp-layout-color3)',
    clickColor: 'var(--jp-brand-color1)',
    backgroundColor: 'var(--jp-layout-color2)',
    height: '24px',
    fontSize: 'var(--jp-ui-font-size1)',
    fontFamily: 'var(--jp-ui-font-family)',
    textColor: 'var(--jp-ui-font-color1)',
    textClickColor: 'white',
    itemMargin: '2px',
    itemPadding: '6px',
    statusBarPadding: '10px',
    interItemHalfSpacing: '2px',
    whiteSpace: 'nowrap',
    textOverflow: 'ellipsis'
});
//# sourceMappingURL=variables.js.map

/***/ }),

/***/ "../../node_modules/@jupyterlab/statusbar/lib/tokens.js":
/*!**************************************************************!*\
  !*** ../../node_modules/@jupyterlab/statusbar/lib/tokens.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IStatusBar": () => (/* binding */ IStatusBar)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

// tslint:disable-next-line:variable-name
const IStatusBar = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/statusbar:IStatusBar');
//# sourceMappingURL=tokens.js.map

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_jupyterlab_statusbar_lib_index_js.bundle.js.map