import { ISecurityGroup, IVpc } from '@aws-cdk/aws-ec2';
import { EndpointGroup } from '../lib';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) The security group used by a Global Accelerator to send traffic to resources in a VPC.
 *
 * @experimental
 */
export declare class AcceleratorSecurityGroup {
    /**
     * (experimental) Lookup the Global Accelerator security group at CloudFormation deployment time.
     *
     * As of this writing, Global Accelerators (AGA) create a single security group per VPC. AGA security groups are shared
     * by all AGAs in an account. Additionally, there is no CloudFormation mechanism to reference the AGA security groups.
     *
     * This makes creating security group rules which allow traffic from an AGA complicated in CDK. This lookup will identify
     * the AGA security group for a given VPC at CloudFormation deployment time, and lets you create rules for traffic from AGA
     * to other resources created by CDK.
     *
     * @experimental
     */
    static fromVpc(scope: Construct, id: string, vpc: IVpc, endpointGroup: EndpointGroup): ISecurityGroup;
    private constructor();
}
