import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import * as ga from './globalaccelerator.generated';
import { IListener } from './listener';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) The interface of the EndpointGroup.
 *
 * @experimental
 */
export interface IEndpointGroup extends cdk.IResource {
    /**
     * (experimental) EndpointGroup ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly endpointGroupArn: string;
}
/**
 * (experimental) Options for `addLoadBalancer`, `addElasticIpAddress` and `addEc2Instance` to add endpoints into the endpoint group.
 *
 * @experimental
 */
export interface EndpointConfigurationOptions {
    /**
     * (experimental) Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
     *
     * @default true
     * @experimental
     */
    readonly clientIpReservation?: boolean;
    /**
     * (experimental) The weight associated with the endpoint.
     *
     * When you add weights to endpoints, you configure AWS Global Accelerator
     * to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5,
     * 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is
     * routed both to the second and third endpoints, and 6/20 is routed to the last endpoint.
     *
     * @default - not specified
     * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) Properties to create EndpointConfiguration.
 *
 * @experimental
 */
export interface EndpointConfigurationProps extends EndpointConfigurationOptions {
    /**
     * (experimental) The endopoint group reesource.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly endpointGroup: EndpointGroup;
    /**
     * (experimental) An ID for the endpoint.
     *
     * If the endpoint is a Network Load Balancer or Application Load Balancer,
     * this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address,
     * this is the Elastic IP address allocation ID. For EC2 instances, this is the EC2 instance ID.
     *
     * @experimental
     */
    readonly endpointId: string;
}
/**
 * (experimental) LoadBalancer Interface.
 *
 * @experimental
 */
export interface LoadBalancer {
    /**
     * (experimental) The ARN of this load balancer.
     *
     * @experimental
     */
    readonly loadBalancerArn: string;
}
/**
 * (experimental) EC2 Instance interface.
 *
 * @experimental
 */
export interface Ec2Instance {
    /**
     * (experimental) The id of the instance resource.
     *
     * @experimental
     */
    readonly instanceId: string;
}
/**
 * (experimental) EIP Interface.
 *
 * @experimental
 */
export interface ElasticIpAddress {
    /**
     * (experimental) allocation ID of the EIP resoruce.
     *
     * @experimental
     */
    readonly attrAllocationId: string;
}
/**
 * (experimental) Property of the EndpointGroup.
 *
 * @experimental
 */
export interface EndpointGroupProps {
    /**
     * (experimental) Name of the endpoint group.
     *
     * @default - logical ID of the resource
     * @experimental
     */
    readonly endpointGroupName?: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the listener.
     *
     * @experimental
     */
    readonly listener: IListener;
    /**
     * (experimental) The AWS Region where the endpoint group is located.
     *
     * @default - the region of the current stack
     * @experimental
     */
    readonly region?: string;
}
/**
 * (experimental) The class for endpoint configuration.
 *
 * @experimental
 */
export declare class EndpointConfiguration extends CoreConstruct {
    /**
     * (experimental) The property containing all the configuration to be rendered.
     *
     * @experimental
     */
    readonly props: EndpointConfigurationProps;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EndpointConfigurationProps);
    /**
     * (experimental) render the endpoint configuration for the endpoint group.
     *
     * @experimental
     */
    renderEndpointConfiguration(): ga.CfnEndpointGroup.EndpointConfigurationProperty;
}
/**
 * (experimental) EndpointGroup construct.
 *
 * @experimental
 */
export declare class EndpointGroup extends cdk.Resource implements IEndpointGroup {
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromEndpointGroupArn(scope: Construct, id: string, endpointGroupArn: string): IEndpointGroup;
    /**
     * (experimental) EndpointGroup ARN.
     *
     * @experimental
     */
    readonly endpointGroupArn: string;
    /**
     * (experimental) The name of the endpoint group.
     *
     * @experimental
     * @attribute true
     */
    readonly endpointGroupName: string;
    /**
     * (experimental) The array of the endpoints in this endpoint group.
     *
     * @experimental
     */
    protected readonly endpoints: EndpointConfiguration[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EndpointGroupProps);
    /**
     * (experimental) Add an endpoint.
     *
     * @experimental
     */
    addEndpoint(id: string, endpointId: string, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * (experimental) Add an Elastic Load Balancer as an endpoint in this endpoint group.
     *
     * @experimental
     */
    addLoadBalancer(id: string, lb: LoadBalancer, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * (experimental) Add an EIP as an endpoint in this endpoint group.
     *
     * @experimental
     */
    addElasticIpAddress(id: string, eip: ElasticIpAddress, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * (experimental) Add an EC2 Instance as an endpoint in this endpoint group.
     *
     * @experimental
     */
    addEc2Instance(id: string, instance: Ec2Instance, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * Links a endpoint to this endpoint group
     * @internal
     */
    _linkEndpoint(endpoint: EndpointConfiguration): void;
    private renderEndpoints;
}
