/*
 * Decompiled with CFR 0.152.
 */
package gate.tools.gatenlpworker;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.Plugin;
import gate.gui.ResourceHelper;

public class GatenlpWorker {
    static boolean DEBUG = false;

    public static void main(String[] args) {
        int tmp;
        if (args.length > 4) {
            System.err.println("Need up to four parameters: port number, host address, 0/1 if actions should get logged, 0/1 if worker should be kept running");
            System.exit(1);
        }
        int port = 25333;
        String host = "127.0.0.1";
        boolean logActions = false;
        boolean keep = false;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            host = args[1];
        }
        if (args.length > 2) {
            tmp = Integer.parseInt(args[2]);
            boolean bl = logActions = tmp != 0;
        }
        if (args.length > 3) {
            tmp = Integer.parseInt(args[3]);
            keep = tmp != 0;
        }
        GatenlpWorker runner = new GatenlpWorker();
        System.err.println("Trying to start GATE Worker on port=" + port + " host=" + host + " log=" + logActions + " keep=" + keep);
        try {
            if (DEBUG) {
                System.err.println("Initializing GATE");
            }
            Gate.init();
            if (DEBUG) {
                System.err.println("Loading plugin python");
            }
            Gate.getCreoleRegister().registerPlugin((Plugin)new Plugin.Maven("uk.ac.gate.plugins", "python", "3.0.2"));
            FeatureMap parms = Factory.newFeatureMap();
            parms.put((Object)"port", (Object)port);
            parms.put((Object)"host", (Object)host);
            if (DEBUG) {
                System.err.println("logActions is " + logActions);
            }
            parms.put((Object)"logActions", (Object)logActions);
            parms.put((Object)"keep", (Object)keep);
            if (DEBUG) {
                System.err.println("Creating worker");
            }
            ResourceHelper worker = (ResourceHelper)Factory.createResource((String)"gate.plugin.python.PythonWorkerRunner", (FeatureMap)parms);
            if (DEBUG) {
                System.err.println("Worker created");
            }
            if (DEBUG) {
                System.err.println("Trying to start worker");
            }
            worker.call("start", null, new Object[0]);
            if (DEBUG) {
                System.err.println("After starting worker");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("Finishing main");
        }
    }
}

