"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
class CloudWatchSetAlarmStateAction {
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchSetAlarmStateActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchSetAlarmStateAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        const role = this.props.role ?? role_1.singletonActionRole(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: this.props.reason ?? `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchSetAlarmStateAction", version: "2.51.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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