"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnQueuePolicy = exports.CfnQueue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:34:40.957Z","fingerprint":"diZX6U0xg1KTbZp4rxiPvplJ8m8SSjHNsdgIJvAB064="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnQueueProps`
 *
 * @param properties - the TypeScript properties of a `CfnQueueProps`
 *
 * @returns the result of the validation.
 */
function CfnQueuePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contentBasedDeduplication', cdk.validateBoolean)(properties.contentBasedDeduplication));
    errors.collect(cdk.propertyValidator('deduplicationScope', cdk.validateString)(properties.deduplicationScope));
    errors.collect(cdk.propertyValidator('delaySeconds', cdk.validateNumber)(properties.delaySeconds));
    errors.collect(cdk.propertyValidator('fifoQueue', cdk.validateBoolean)(properties.fifoQueue));
    errors.collect(cdk.propertyValidator('fifoThroughputLimit', cdk.validateString)(properties.fifoThroughputLimit));
    errors.collect(cdk.propertyValidator('kmsDataKeyReusePeriodSeconds', cdk.validateNumber)(properties.kmsDataKeyReusePeriodSeconds));
    errors.collect(cdk.propertyValidator('kmsMasterKeyId', cdk.validateString)(properties.kmsMasterKeyId));
    errors.collect(cdk.propertyValidator('maximumMessageSize', cdk.validateNumber)(properties.maximumMessageSize));
    errors.collect(cdk.propertyValidator('messageRetentionPeriod', cdk.validateNumber)(properties.messageRetentionPeriod));
    errors.collect(cdk.propertyValidator('queueName', cdk.validateString)(properties.queueName));
    errors.collect(cdk.propertyValidator('receiveMessageWaitTimeSeconds', cdk.validateNumber)(properties.receiveMessageWaitTimeSeconds));
    errors.collect(cdk.propertyValidator('redriveAllowPolicy', cdk.validateObject)(properties.redriveAllowPolicy));
    errors.collect(cdk.propertyValidator('redrivePolicy', cdk.validateObject)(properties.redrivePolicy));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('visibilityTimeout', cdk.validateNumber)(properties.visibilityTimeout));
    return errors.wrap('supplied properties not correct for "CfnQueueProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SQS::Queue` resource
 *
 * @param properties - the TypeScript properties of a `CfnQueueProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SQS::Queue` resource.
 */
// @ts-ignore TS6133
function cfnQueuePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnQueuePropsValidator(properties).assertSuccess();
    return {
        ContentBasedDeduplication: cdk.booleanToCloudFormation(properties.contentBasedDeduplication),
        DeduplicationScope: cdk.stringToCloudFormation(properties.deduplicationScope),
        DelaySeconds: cdk.numberToCloudFormation(properties.delaySeconds),
        FifoQueue: cdk.booleanToCloudFormation(properties.fifoQueue),
        FifoThroughputLimit: cdk.stringToCloudFormation(properties.fifoThroughputLimit),
        KmsDataKeyReusePeriodSeconds: cdk.numberToCloudFormation(properties.kmsDataKeyReusePeriodSeconds),
        KmsMasterKeyId: cdk.stringToCloudFormation(properties.kmsMasterKeyId),
        MaximumMessageSize: cdk.numberToCloudFormation(properties.maximumMessageSize),
        MessageRetentionPeriod: cdk.numberToCloudFormation(properties.messageRetentionPeriod),
        QueueName: cdk.stringToCloudFormation(properties.queueName),
        ReceiveMessageWaitTimeSeconds: cdk.numberToCloudFormation(properties.receiveMessageWaitTimeSeconds),
        RedriveAllowPolicy: cdk.objectToCloudFormation(properties.redriveAllowPolicy),
        RedrivePolicy: cdk.objectToCloudFormation(properties.redrivePolicy),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VisibilityTimeout: cdk.numberToCloudFormation(properties.visibilityTimeout),
    };
}
// @ts-ignore TS6133
function CfnQueuePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contentBasedDeduplication', 'ContentBasedDeduplication', properties.ContentBasedDeduplication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ContentBasedDeduplication) : undefined);
    ret.addPropertyResult('deduplicationScope', 'DeduplicationScope', properties.DeduplicationScope != null ? cfn_parse.FromCloudFormation.getString(properties.DeduplicationScope) : undefined);
    ret.addPropertyResult('delaySeconds', 'DelaySeconds', properties.DelaySeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.DelaySeconds) : undefined);
    ret.addPropertyResult('fifoQueue', 'FifoQueue', properties.FifoQueue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.FifoQueue) : undefined);
    ret.addPropertyResult('fifoThroughputLimit', 'FifoThroughputLimit', properties.FifoThroughputLimit != null ? cfn_parse.FromCloudFormation.getString(properties.FifoThroughputLimit) : undefined);
    ret.addPropertyResult('kmsDataKeyReusePeriodSeconds', 'KmsDataKeyReusePeriodSeconds', properties.KmsDataKeyReusePeriodSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.KmsDataKeyReusePeriodSeconds) : undefined);
    ret.addPropertyResult('kmsMasterKeyId', 'KmsMasterKeyId', properties.KmsMasterKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsMasterKeyId) : undefined);
    ret.addPropertyResult('maximumMessageSize', 'MaximumMessageSize', properties.MaximumMessageSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumMessageSize) : undefined);
    ret.addPropertyResult('messageRetentionPeriod', 'MessageRetentionPeriod', properties.MessageRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.MessageRetentionPeriod) : undefined);
    ret.addPropertyResult('queueName', 'QueueName', properties.QueueName != null ? cfn_parse.FromCloudFormation.getString(properties.QueueName) : undefined);
    ret.addPropertyResult('receiveMessageWaitTimeSeconds', 'ReceiveMessageWaitTimeSeconds', properties.ReceiveMessageWaitTimeSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReceiveMessageWaitTimeSeconds) : undefined);
    ret.addPropertyResult('redriveAllowPolicy', 'RedriveAllowPolicy', properties.RedriveAllowPolicy != null ? cfn_parse.FromCloudFormation.getAny(properties.RedriveAllowPolicy) : undefined);
    ret.addPropertyResult('redrivePolicy', 'RedrivePolicy', properties.RedrivePolicy != null ? cfn_parse.FromCloudFormation.getAny(properties.RedrivePolicy) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('visibilityTimeout', 'VisibilityTimeout', properties.VisibilityTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.VisibilityTimeout) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SQS::Queue`
 *
 * The `AWS::SQS::Queue` resource creates an Amazon SQS standard or FIFO queue.
 *
 * Keep the following caveats in mind:
 *
 * - If you don't specify the `FifoQueue` property, Amazon SQS creates a standard queue.
 *
 * > You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see [Moving from a standard queue to a FIFO queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-moving.html) in the *Amazon SQS Developer Guide* .
 * - If you don't provide a value for a property, the queue is created with the default value for the property.
 * - If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
 * - To successfully create a new queue, you must provide a queue name that adheres to the [limits related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html) and is unique within the scope of your queues.
 *
 * For more information about creating FIFO (first-in-first-out) queues, see [Creating an Amazon SQS queue ( AWS CloudFormation )](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/screate-queue-cloudformation.html) in the *Amazon SQS Developer Guide* .
 *
 * @cloudformationResource AWS::SQS::Queue
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html
 */
class CfnQueue extends cdk.CfnResource {
    /**
     * Create a new `AWS::SQS::Queue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnQueue.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings._aws_cdk_aws_sqs_CfnQueueProps(props);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrQueueName = cdk.Token.asString(this.getAtt('QueueName'));
        this.attrQueueUrl = cdk.Token.asString(this.getAtt('QueueUrl'));
        this.contentBasedDeduplication = props.contentBasedDeduplication;
        this.deduplicationScope = props.deduplicationScope;
        this.delaySeconds = props.delaySeconds;
        this.fifoQueue = props.fifoQueue;
        this.fifoThroughputLimit = props.fifoThroughputLimit;
        this.kmsDataKeyReusePeriodSeconds = props.kmsDataKeyReusePeriodSeconds;
        this.kmsMasterKeyId = props.kmsMasterKeyId;
        this.maximumMessageSize = props.maximumMessageSize;
        this.messageRetentionPeriod = props.messageRetentionPeriod;
        this.queueName = props.queueName;
        this.receiveMessageWaitTimeSeconds = props.receiveMessageWaitTimeSeconds;
        this.redriveAllowPolicy = props.redriveAllowPolicy;
        this.redrivePolicy = props.redrivePolicy;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SQS::Queue", props.tags, { tagPropertyName: 'tags' });
        this.visibilityTimeout = props.visibilityTimeout;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::SQS::Queue\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnQueuePropsFromCloudFormation(resourceProperties);
        const ret = new CfnQueue(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnQueue.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            contentBasedDeduplication: this.contentBasedDeduplication,
            deduplicationScope: this.deduplicationScope,
            delaySeconds: this.delaySeconds,
            fifoQueue: this.fifoQueue,
            fifoThroughputLimit: this.fifoThroughputLimit,
            kmsDataKeyReusePeriodSeconds: this.kmsDataKeyReusePeriodSeconds,
            kmsMasterKeyId: this.kmsMasterKeyId,
            maximumMessageSize: this.maximumMessageSize,
            messageRetentionPeriod: this.messageRetentionPeriod,
            queueName: this.queueName,
            receiveMessageWaitTimeSeconds: this.receiveMessageWaitTimeSeconds,
            redriveAllowPolicy: this.redriveAllowPolicy,
            redrivePolicy: this.redrivePolicy,
            tags: this.tags.renderTags(),
            visibilityTimeout: this.visibilityTimeout,
        };
    }
    renderProperties(props) {
        return cfnQueuePropsToCloudFormation(props);
    }
}
exports.CfnQueue = CfnQueue;
_a = JSII_RTTI_SYMBOL_1;
CfnQueue[_a] = { fqn: "@aws-cdk/aws-sqs.CfnQueue", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnQueue.CFN_RESOURCE_TYPE_NAME = "AWS::SQS::Queue";
/**
 * Determine whether the given properties match those of a `CfnQueuePolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnQueuePolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnQueuePolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('policyDocument', cdk.requiredValidator)(properties.policyDocument));
    errors.collect(cdk.propertyValidator('policyDocument', cdk.validateObject)(properties.policyDocument));
    errors.collect(cdk.propertyValidator('queues', cdk.requiredValidator)(properties.queues));
    errors.collect(cdk.propertyValidator('queues', cdk.listValidator(cdk.validateString))(properties.queues));
    return errors.wrap('supplied properties not correct for "CfnQueuePolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SQS::QueuePolicy` resource
 *
 * @param properties - the TypeScript properties of a `CfnQueuePolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SQS::QueuePolicy` resource.
 */
// @ts-ignore TS6133
function cfnQueuePolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnQueuePolicyPropsValidator(properties).assertSuccess();
    return {
        PolicyDocument: cdk.objectToCloudFormation(properties.policyDocument),
        Queues: cdk.listMapper(cdk.stringToCloudFormation)(properties.queues),
    };
}
// @ts-ignore TS6133
function CfnQueuePolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('policyDocument', 'PolicyDocument', cfn_parse.FromCloudFormation.getAny(properties.PolicyDocument));
    ret.addPropertyResult('queues', 'Queues', cfn_parse.FromCloudFormation.getStringArray(properties.Queues));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SQS::QueuePolicy`
 *
 * The `AWS::SQS::QueuePolicy` type applies a policy to Amazon SQS queues. For an example snippet, see [Declaring an Amazon SQS policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-iam.html#scenario-sqs-policy) in the *AWS CloudFormation User Guide* .
 *
 * @cloudformationResource AWS::SQS::QueuePolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queuepolicy.html
 */
class CfnQueuePolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::SQS::QueuePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnQueuePolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings._aws_cdk_aws_sqs_CfnQueuePolicyProps(props);
        cdk.requireProperty(props, 'policyDocument', this);
        cdk.requireProperty(props, 'queues', this);
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.policyDocument = props.policyDocument;
        this.queues = props.queues;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnQueuePolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnQueuePolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnQueuePolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            policyDocument: this.policyDocument,
            queues: this.queues,
        };
    }
    renderProperties(props) {
        return cfnQueuePolicyPropsToCloudFormation(props);
    }
}
exports.CfnQueuePolicy = CfnQueuePolicy;
_b = JSII_RTTI_SYMBOL_1;
CfnQueuePolicy[_b] = { fqn: "@aws-cdk/aws-sqs.CfnQueuePolicy", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnQueuePolicy.CFN_RESOURCE_TYPE_NAME = "AWS::SQS::QueuePolicy";
//# sourceMappingURL=data:application/json;base64,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