# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.configuration.backend
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ...uno.exception import Exception as Exception_85530a09
from ...uno.x_interface import XInterface as XInterface_8f010a43

class MalformedDataException(Exception_85530a09):
    """
    Exception Class

    is raised when the data of a component schema, layer or update is not well-formed, violates the schema or is otherwise invalid.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API MalformedDataException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1configuration_1_1backend_1_1MalformedDataException.html>`_
    """

    typeName: Literal['com.sun.star.configuration.backend.MalformedDataException']

    def __init__(self, Message: typing.Optional[str] = ..., Context: typing.Optional[XInterface_8f010a43] = ..., ErrorDetails: typing.Optional[object] = ...) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            ErrorDetails (object, optional): ErrorDetails value.
        """
        ...
    @property
    def ErrorDetails(self) -> object:
        """
        data that provides more detailed information about the reason and location of the error.
        
        Typically this member should contain an exception characterizing the error in detail.
        
        For example the following exceptions may be used:
        
        If no more detail information is available, this may be left VOID.
        """
        ...


__all__ = ['MalformedDataException']

