# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.table
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .shadow_location import ShadowLocation as ShadowLocation_d4530caf
from ..util.color import Color as Color_68e908c5


class ShadowFormat(object):
    """
    Struct Class

    describes the settings of a cell shadow.

    See Also:
        `API ShadowFormat <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1table_1_1ShadowFormat.html>`_
    """
    typeName: Literal['com.sun.star.table.ShadowFormat']

    def __init__(self, Location: typing.Optional[ShadowLocation_d4530caf] = ..., ShadowWidth: typing.Optional[int] = ..., IsTransparent: typing.Optional[bool] = ..., Color: typing.Optional[Color_68e908c5] = ...) -> None:
        """
        Constructor

        Arguments:
            Location (ShadowLocation, optional): Location value.
            ShadowWidth (int, optional): ShadowWidth value.
            IsTransparent (bool, optional): IsTransparent value.
            Color (Color, optional): Color value.
        """
        ...


    @property
    def Location(self) -> ShadowLocation_d4530caf:
        """
        contains the location of the shadow.
        """
        ...


    @property
    def ShadowWidth(self) -> int:
        """
        contains the size of the shadow.
        """
        ...


    @property
    def IsTransparent(self) -> bool:
        """
        is TRUE, if shadow is transparent.
        """
        ...


    @property
    def Color(self) -> Color_68e908c5:
        """
        contains the color value of the shadow.
        """
        ...


