# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..task.classified_interaction_request import ClassifiedInteractionRequest as ClassifiedInteractionRequest_9f72121b
from ..uno.x_interface import XInterface as XInterface_8f010a43
from ..task.interaction_classification import InteractionClassification as InteractionClassification_6c4d10e7
from ..security.x_certificate import XCertificate as XCertificate_e55b0d3b

class CertificateValidationRequest(ClassifiedInteractionRequest_9f72121b):
    """
    Exception Class

    An error specifying an invalid certificate.

    See Also:
        `API CertificateValidationRequest <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1ucb_1_1CertificateValidationRequest.html>`_
    """

    typeName: Literal['com.sun.star.ucb.CertificateValidationRequest']

    def __init__(self, Message: typing.Optional[str] = ..., Context: typing.Optional[XInterface_8f010a43] = ..., Classification: typing.Optional[InteractionClassification_6c4d10e7] = ..., CertificateValidity: typing.Optional[int] = ..., Certificate: typing.Optional[XCertificate_e55b0d3b] = ..., HostName: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            Classification (InteractionClassification, optional): Classification value.
            CertificateValidity (int, optional): CertificateValidity value.
            Certificate (XCertificate, optional): Certificate value.
            HostName (str, optional): HostName value.
        """
        ...
    @property
    def CertificateValidity(self) -> int:
        """
        This value describes the validity of the certificate.
        """
        ...

    @property
    def Certificate(self) -> XCertificate_e55b0d3b:
        """
        The certificate himself.
        """
        ...

    @property
    def HostName(self) -> str:
        """
        The host name.
        """
        ...


__all__ = ['CertificateValidationRequest']

