# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from typing_extensions import Literal
from ..lang.event_object import EventObject as EventObject_a3d70b03
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .remote_content_provider_change_action import RemoteContentProviderChangeAction as RemoteContentProviderChangeAction_e9701378


class RemoteContentProviderChangeEvent(EventObject_a3d70b03):
    """
    Struct Class

    The description of a change to a com.sun.star.ucb.XRemoteContentProviderSupplier.

    See Also:
        `API RemoteContentProviderChangeEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1RemoteContentProviderChangeEvent.html>`_
    """
    typeName: Literal['com.sun.star.ucb.RemoteContentProviderChangeEvent']

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = ..., Identifier: typing.Optional[str] = ..., Action: typing.Optional[RemoteContentProviderChangeAction_e9701378] = ...) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Identifier (str, optional): Identifier value.
            Action (RemoteContentProviderChangeAction, optional): Action value.
        """
        ...


    @property
    def Identifier(self) -> str:
        """
        The identifier with which the remote content provider is registered at the com.sun.star.ucb.XRemoteContentProviderSupplier.
        """
        ...


    @property
    def Action(self) -> RemoteContentProviderChangeAction_e9701378:
        """
        An indicator whether a remote content provider has been added or removed.
        """
        ...


