# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.view
from typing_extensions import Literal
import typing
from .x_control_access import XControlAccess as XControlAccess_c89d0c4e
if typing.TYPE_CHECKING:
    from ..form.x_form import XForm as XForm_684408a8
    from ..form.runtime.x_form_controller import XFormController as XFormController_4a570ffe

class XFormLayerAccess(XControlAccess_c89d0c4e):
    """
    provides access to the form layer elements in a view
    
    **since**
    
        OOo 2.3

    See Also:
        `API XFormLayerAccess <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1view_1_1XFormLayerAccess.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.view.XFormLayerAccess']

    def getFormController(self, Form: 'XForm_684408a8') -> 'XFormController_4a570ffe':
        """
        returns the com.sun.star.form.FormController instance which operates on a given form.
        
        A form controller is a component which controls the user interaction with the form layer, as long as the form is not in design mode.
        """
        ...
    def isFormDesignMode(self) -> bool:
        """
        determines whether the view's form layer is currently in design or alive mode
        
        Note: This is a convenience method. In the user interface, the design mode is coupled with the .uno:SwitchControlDesignMode feature (see com.sun.star.frame.XDispatchProvider), and asking for the current mode is the same as asking for the state of this feature.
        """
        ...
    def setFormDesignMode(self, DesignMode: bool) -> None:
        """
        determines whether the view's form layer is currently in design or alive mode
        
        Note: This is a convenience method. In the user interface, the design mode is coupled with the .uno:SwitchControlDesignMode feature (see com.sun.star.frame.XDispatchProvider), and changing the current mode is the same as dispatching this feature URL.
        """
        ...


