# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-s3-object-store-test-result.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_11_11.web.objects.TypedObject import TypedObject
from delphixpy.v1_11_11 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class S3ObjectStoreTestResult(TypedObject):
    """
    *(extends* :py:class:`v1_11_11.web.vo.TypedObject` *)* An Amazon S3 object
    store connectivity test result.
    """
    def __init__(self, undef_enabled=True):
        super(S3ObjectStoreTestResult, self).__init__()
        self._type = ("S3ObjectStoreTestResult", True)
        self._result = (self.__undef__, True)

    API_VERSION = "1.11.11"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(S3ObjectStoreTestResult, cls).from_dict(data, dirty, undef_enabled)
        obj._result = (data.get("result", obj.__undef__), dirty)
        if obj._result[0] is not None and obj._result[0] is not obj.__undef__:
            assert isinstance(obj._result[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._result[0], type(obj._result[0])))
            common.validate_format(obj._result[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(S3ObjectStoreTestResult, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "result" == "type" or (self.result is not self.__undef__ and (not (dirty and not self._result[1]))):
            dct["result"] = dictify(self.result)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._result = (self._result[0], True)

    def is_dirty(self):
        return any([self._result[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, S3ObjectStoreTestResult):
            return False
        return super(S3ObjectStoreTestResult, self).__eq__(other) and \
               self.result == other.result

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def result(self):
        """
        The result of the connectivity test.

        :rtype: ``bool``
        """
        return self._result[0]

    @result.setter
    def result(self, value):
        self._result = (value, True)

